/* $Id: LogManager.java,v 1.5 2005/08/26 04:48:30 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.servlet;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

import javax.servlet.ServletContext;

import org.apache.log4j.PropertyConfigurator;

/**
 * OǗNXłB
 *
 * @author  ysahara(Argo 21, Corp.)
 * @version $Revision: 1.5 $
 * @since   Nautica Workflow 0.9
 */
public class LogManager {
	
	private static String NAUTICA_CONFIG_FILE_NAME = "logging.properties";
	
	private static String LOG4J_CONFIG_FILE_NAME = "log4j.properties";
	
	private static String confPath = "/WEB-INF/conf/";
	
	/**
	 * LogManageȑsB
	 * 
	 */
	static void create(ServletContext context)	{
		URL url = getConfigURL(context);
		if (url == null) {
			System.out.println("Oݒt@C̓ǂݍ݂ł܂łB" +
					"(Ot@C=" + NAUTICA_CONFIG_FILE_NAME);
		}
		PropertyConfigurator.configure(url);
	}
	
	/**
	 * Oݒt@C URL ԂB
	 * Oݒt@C݂Ȃꍇ null ԂB
	 *
	 * @return Oݒt@C URL
	 */
	private static URL getConfigURL(ServletContext context) {
//		Oݒt@C WEB-INF/conf ɂꍇAD悵ēǂ݂ށB
		String realPath = context.getRealPath(confPath + NAUTICA_CONFIG_FILE_NAME);
		URL configURL = null;
		try {
			 configURL = createURL(realPath);
			 
			if (configURL != null && !configURL.equals("")) {
				return configURL;
			}
			configURL = LogManager.class.getClassLoader().
				getResource(confPath + LOG4J_CONFIG_FILE_NAME);
			if (configURL != null && !configURL.equals("")) {
				return configURL;
			}
			
		} catch (Exception ex) {
		    // ł͂ȂɂȂB
		}
		
		// Oݒt@CNXpXɂꍇAǂ݂ށB
		configURL = LogManager.class.getClassLoader().
			getResource(NAUTICA_CONFIG_FILE_NAME);
		if (configURL != null && !configURL.equals("")) {
			return configURL;
		}
		configURL = LogManager.class.getClassLoader().
			getResource(LOG4J_CONFIG_FILE_NAME);
		if (configURL != null && !configURL.equals("")) {
			return configURL;
		}
		return null;
	}
	
	/**
	 * t@CpXURLɕϊB
	 * 
	 *
	 * @param filePath t@CpX
	 * @return URL
	 */
	private static URL createURL(String filePath) 
	throws MalformedURLException {
        char separetor = File.separator.charAt(0);
        String file = filePath.replace(separetor, '/');
        	if (file.charAt(0) != '/') {
        	    String dir = System.getProperty("user.dir");
        	    dir = dir.replace(separetor, '/') + '/';
        	    if (dir.charAt(0) != '/') {
        	        dir = "/" + dir;
        	    }
        	    file = dir + file;
        	}
      	return new URL("file", "", file);
    }
}
