/* $Id: NWFRequestUtil.java,v 1.8 2005/08/26 04:48:37 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.servlet;

import javax.servlet.http.HttpServletRequest;

import jp.co.argo21.nautica.workflow.filter.GroupFilter;
import jp.co.argo21.nautica.workflow.wfmc.ActivityState;
import jp.co.argo21.nautica.workflow.wfmc.Attribute;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.Participant;
import jp.co.argo21.nautica.workflow.wfmc.ProcessDefinitionState;
import jp.co.argo21.nautica.workflow.wfmc.ProcessState;
import jp.co.argo21.nautica.workflow.wfmc.WorkItemState;

/**
 * HttpServletRequest 烏[Nt[GW̃C^tF[X
 * ĂяoۂɎgp擾邽߂̃NXłB
 *
 * @author  ysahara(Argo 21, Corp.)
 * @version $Revision: 1.8 $
 * @since   Nautica Workflow 0.9
 */
public class NWFRequestUtil {

	// HttpServletRequest KvȒl擾邽߂̃L[l
	private static final String ACTIVITY_DEFINITION_ID	= "NWF_ACTIVITY_DEFINITION_ID";
	private static final String ACTIVITY_INSTANCE_ID	 	= "NWF_ACTIVITY_INSTANCE_ID";
	private static final String ACTIVITY_INSTANCE_STATE 	= "NWF_ACTIVITY_INSTANCE_STATE";
	private static final String ACTIVITY_STATE			= "NWF_ACTIVITY_STATE";
	private static final String ATTRIBUTE        			= "NWF_ATTRIBUTE";
	private static final String ATTRIBUTE_NAME   			= "NWF_ATTRIBUTE_NAME";
	private static final String DEFINITION_NAME   		= "NWF_DEFINITION_NAME";
	private static final String DEFINITION_PATH   		= "NWF_DEFINITION_PATH";
	private static final String PASSWORD		  			= "NWF_PASSWORD";
	private static final String PROCESS_DEFINITION_ID	= "NWF_PROCESS_DEFINITION_ID";
	private static final String PROCESS_DEFINITION_STATE	= "NWF_PROCESS_DEFINITION_STATE";
	private static final String PROCESS_INSTANCE_ID		= "NWF_PROCESS_INSTANCE_ID";
	private static final String PROCESS_INSTANCE_NAME	= "NWF_PROCESS_INSTANCE_NAME";
	private static final String PROCESS_STATE				= "NWF_PROCESS_STATE";
	private static final String SESSION          			= "NWF_SESSION";
	private static final String SOURCE_USER      			= "NWF_SOURCE_USER";
	private static final String TARGET_USER      			= "NWF_TARGET_USER";
	private static final String USER						= "NWF_USER";
	private static final String WORKITEM_ID      			= "NWF_WORKITEM_ID";
	private static final String WORKITEM_STATE   			= "NWF_WORKITEM_STATE";

	/**
	 * HttpServletRequest tB^[擾AԂB
	 * Y HttpServletRequest ɑ݂Ȃꍇ́Anull ԂB
	 * 
	 *
	 * @param req HttpServletRequest IuWFNg
	 * @param methodName \bh
	 * @return Filter IuWFNg
	 */
	static Filter getFilter(HttpServletRequest req, String methodName) {
		String key = "NWF_" + methodName.toUpperCase() + "_FILTER";
		Object filter = getObjectFromRequest(req, key);
		if (filter == null) {
		    return null;
		}
		if (filter instanceof Filter[]) {
		    return new GroupFilter((Filter[])filter);
		
		} else if (filter instanceof Filter) {
		    return (Filter) filter;
		
		} else {
		    throw new RuntimeException(
		    "Invalid Filter[Filter=" + filter + "]");
		}
	}
	
	/**
	 * HttpServletRequest ANeBreB` ID 擾AԂB
	 * Y HttpServletRequest ɑ݂Ȃꍇ́Anull ԂB
	 * 
	 * @param req HttpServletRequest IuWFNg
	 * @return ANeBreB`ID
	 */
	static String getActivityDefinitionID(HttpServletRequest req) {
    	return getStringFromRequest(req, ACTIVITY_DEFINITION_ID);
    }
	
	/**
	 * HttpServletRequest ANeBreB ID 擾AԂB
	 * Y HttpServletRequest ɑ݂Ȃꍇ́Anull ԂB
	 *
	 * @param req HttpServletRequest IuWFNg
	 * @return  ANeBreB ID 
	 */
	static String getActivityInstanceID(HttpServletRequest req) {
    	return getStringFromRequest(req, ACTIVITY_INSTANCE_ID);
    }
	
	/**
	 * HttpServletRequest ANeBreBԂ擾AԂB
	 * Y HttpServletRequest ɑ݂Ȃꍇ́Anull ԂB
	 *
	 * @param req HttpServletRequest IuWFNg
	 * @return ANeBreB
	 */
	static ActivityState getActivityInstanceState(HttpServletRequest req) {
    	return (ActivityState) getObjectFromRequest(req, ACTIVITY_INSTANCE_STATE);
    }
	
    /**
     * HttpServletRequest vZXԂ擾AԂB
     * Y HttpServletRequest ɑ݂Ȃꍇ́Anull ԂB
     *
     * @param req HttpServletRequest IuWFNg
     * @return ANeBreB
     */
    static ActivityState getActivityState(HttpServletRequest req) {
		return (ActivityState) getObjectFromRequest(req, ACTIVITY_STATE);
	}
	
	/**
	 * HttpServletRequest 瑮擾AԂB
	 * Y HttpServletRequest ɑ݂Ȃꍇ́Anull ԂB
	 *
	 * @param req HttpServletRequest IuWFNg
	 * @return 
	 */
    static Attribute getAttribute(HttpServletRequest req) {
    	return (Attribute) getObjectFromRequest(req, ATTRIBUTE);
    }
	
	/**
	 * HttpServletRequest 瑮擾AԂB
	 * Y HttpServletRequest ɑ݂Ȃꍇ́Anull ԂB
	 * 
	 * @param req HttpServletRequest IuWFNg
	 * @return 
	 */
	static String getAttributeName(HttpServletRequest req) {
    	return getStringFromRequest(req, ATTRIBUTE_NAME);
    }
    
    /**
     * HttpServletRequest `擾AԂB
     * Y HttpServletRequest ɑ݂Ȃꍇ́Anull ԂB
     *
     * @param req HttpServletRequest IuWFNg
     * @return `
     */
    static String getDefinitionName(HttpServletRequest req) {
		return (String) getStringFromRequest(req, DEFINITION_NAME);
	}
    
    /**
     * HttpServletRequest `pX擾AԂB
     * Y HttpServletRequest ɑ݂Ȃꍇ́Anull ԂB
     *
     * @param req HttpServletRequest IuWFNg
     * @return `pX
     */
    static String getDefinitionPath(HttpServletRequest req) {
		return (String) getStringFromRequest(req, DEFINITION_PATH);
	}
    
    /**
     * HttpServletRequest pX[h擾AԂB
     * Y HttpServletRequest ɑ݂Ȃꍇ́Anull ԂB
     *
     * @param req HttpServletRequest IuWFNg
     * @return pX[h
     */
    static String getPassword(HttpServletRequest req) {
		return (String) getStringFromRequest(req, PASSWORD);
	}
    
    /**
     * HttpServletRequest vZX` ID 擾AԂB
     * Y HttpServletRequest ɑ݂Ȃꍇ́Anull ԂB
     *
     * @param req HttpServletRequest IuWFNg
     * @return vZX` ID 
     */
    static String getProcessDefinitionID(HttpServletRequest req) {
		return (String) getStringFromRequest(req, PROCESS_DEFINITION_ID);
	}
    
    /**
     * HttpServletRequest vZX`Ԃ擾AԂB
     * Y HttpServletRequest ɑ݂Ȃꍇ́Anull ԂB
     *
     * @param req HttpServletRequest IuWFNg
     * @return vZX`
     */
    static ProcessDefinitionState getProcessDefinitionState(HttpServletRequest req) {
		return (ProcessDefinitionState) getObjectFromRequest(req, PROCESS_DEFINITION_STATE);
	}
    
    /**
     * HttpServletRequest vZX ID 擾AԂB
     * Y HttpServletRequest ɑ݂Ȃꍇ́Anull ԂB
     *
     * @param req HttpServletRequest IuWFNg
     * @return vZX ID 
     */
    static String getProcessInstanceID(HttpServletRequest req) {
		return (String) getStringFromRequest(req, PROCESS_INSTANCE_ID);
	}
    
    /**
     * HttpServletRequest vZXCX^X擾AԂB
     * Y HttpServletRequest ɑ݂Ȃꍇ́Anull ԂB
     *
     * @param req HttpServletRequest IuWFNg
     * @return vZXCX^X
     */
    static String getProcessInstanceName(HttpServletRequest req) {
		return (String) getStringFromRequest(req, PROCESS_INSTANCE_NAME);
	}
    
    /**
     * HttpServletRequest vZXԂ擾AԂB
     * Y HttpServletRequest ɑ݂Ȃꍇ́Anull ԂB
     *
     * @param req HttpServletRequest IuWFNg
     * @return vZX
     */
    static ProcessState getProcessState(HttpServletRequest req) {
		return (ProcessState) getObjectFromRequest(req, PROCESS_STATE);
	}
    
    /**
     * HttpServletRequest ZbV ID 擾AԂB
     * Y HttpServletRequest ɑ݂Ȃꍇ́Anull ԂB
     *
     * @param req HttpServletRequest IuWFNg
     * @return ZbV ID 
     */
	static String getSession(HttpServletRequest req) {
		return (String) getStringFromRequest(req, SESSION);
	}
	
    /**
     * HttpServletRequest 烏[Nt[Q҂擾AԂB
     * Y HttpServletRequest ɑ݂Ȃꍇ́Anull ԂB
     *
     * @param req HttpServletRequest IuWFNg
     * @return [Nt[Q
     */
    static Participant getSourceUser(HttpServletRequest req) {
    	return (Participant) getObjectFromRequest(req, SOURCE_USER);
    }
    
    /**
     * HttpServletRequest 烏[Nt[Q҂擾AԂB
     * Y HttpServletRequest ɑ݂Ȃꍇ́Anull ԂB
     *
     * @param req HttpServletRequest IuWFNg
     * @return [Nt[Q
     */
    static Participant getTargetUser(HttpServletRequest req) {
    	return (Participant) getObjectFromRequest(req, TARGET_USER);
    }
	
	/**
	 * HttpServletRequest 烆[U擾AԂB
	 * Y HttpServletRequest ɑ݂Ȃꍇ́Anull ԂB
	 *
	 * @param req HttpServletRequest IuWFNg
	 * @return [U
	 */
	static String getUser(HttpServletRequest req) {
		return (String) getStringFromRequest(req, USER);
	}
	
	/**
	 * HttpServletRequest ƍ ID 擾AԂB
	 * Y HttpServletRequest ɑ݂Ȃꍇ́Anull ԂB
	 *
	 * @param req HttpServletRequest IuWFNg
	 * @return ƍ ID 
	 */
    static String getWorkItemID(HttpServletRequest req) {
    	return (String) getStringFromRequest(req, WORKITEM_ID);
    }
    
    /**
     * HttpServletRequest ƍڏԂ擾AԂB
     * Y HttpServletRequest ɑ݂Ȃꍇ́Anull ԂB
     *
     * @param req HttpServletRequest IuWFNg
     * @return ƍڏ
     */
    static WorkItemState getWorkItemState(HttpServletRequest req) {
    	return (WorkItemState) getObjectFromRequest(req, WORKITEM_STATE);
    }
	
	/**
	 * HttpServletRequest ɊY鑮ԂB
	 * 
	 *
	 * @param req HttpServletRequest IuWFNg
	 * @param key L[l
	 * @return 
	 */
	private static String getStringFromRequest(HttpServletRequest req, String key) {
		// I HttpServletRequest  getParameter(String) 
		// l擾邱ƂlA\bhƂĐ؂oĂB
		return (String) req.getAttribute(key);
	}
	
	/**
	 * HttpServletRequest ɊY鑮ԂB
	 * I HttpServletRequest  getParameter(String) 
	 * l擾ꍇÃ\bhKvȂȂ邱ƂlB
	 *
	 * @param req HttpServletRequest IuWFNg
	 * @param key L[l
	 * @return 
	 */
	private static Object getObjectFromRequest(HttpServletRequest req, String key) {
		// I HttpServletRequest  getParameter(String) 
		// l擾AIuWFNg\z邱ƂlA\bhƂĐ؂oĂB
		return req.getAttribute(key);
	}
}
