/* $Id: WorkflowServletConfig.java,v 1.6 2005/08/26 04:48:21 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import javax.servlet.ServletContext;

import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.util.StringManager;

import org.apache.log4j.Logger;

/**
 * [Nt[ɊւݒێNXłB
 *
 * @author  root(Argo 21, Corp.)
 * @version $Revision: 1.6 $
 * @since   Nautica Workflow 0.9
 */
class WorkflowServletConfig {

    private static final String FILE_PATH = "/WEB-INF/conf/nautica.properties";
    
	/** Oo͗pIuWFNg */
	private static Logger log =
		Logger.getLogger(WorkflowServletConfig.class);
	
	private static String CONFIG_FILE_NAME = "nautica.properties";
	
	private static String NAUTICA_WORKFLOW_URL = "nautica.workflow.url";
	
	private static String NAUTICA_WORKFLOW_SCOPE = "nautica.workflow.scope";
	
	private static WorkflowServletConfig instance;
	
	private String url = "iiop://localhost:1050";
	
	private String scope = "";
	
	/**
	 * RXgN^ 
	 */
	private WorkflowServletConfig(String url, String scope) {
		this.url = url;
		this.scope = scope;
	}
	
	/**
	 * ݒǂ݂ށB
	 * ̃NX getInstance \bhĂтO
	 * ̃\bhĂтÃNX̃IuWFNg
	 * KvB
	 * 
	 * @throws WorkflowException ݒ̓ǂݍ݂Ɏsꍇ
	 */
	static void create(ServletContext context) throws WorkflowException {
		// ݒǂ݂ށB
		InputStream is = context.getResourceAsStream(FILE_PATH);
		if (is == null) {
			String E4001 = StringManager.get("E4001")
				+ "(FileName=" + CONFIG_FILE_NAME + ")";
			log.fatal(E4001);
			throw new WorkflowException(E4001);
		}
		
		Properties props = new Properties();
		try {
			props.load(is);
		
		} catch (IOException ex) {
			String E4002 = StringManager.get("E4002");
			log.fatal(E4002, ex);
			throw new WorkflowException(E4002, ex);
		}
		String url = (String) props.get(NAUTICA_WORKFLOW_URL);
		String scope = (String) props.get(NAUTICA_WORKFLOW_SCOPE);
		if (url == null || url.equals("")) {
			String E4003 = StringManager.get("E4003") 
				+ "(ConfigKey=" + NAUTICA_WORKFLOW_URL  
				+ ", ConfigValue=" + url + ")";
			log.fatal(E4003);
			throw new WorkflowException(E4003);
		}
		
		String I4003 = StringManager.get("I4003")
			+ "(URL=" + url 
			+ ", Scope=" + scope +")";
		log.info(I4003);
		
		// ݒɂăRlN^B
		instance = new WorkflowServletConfig(url, scope);
	}
	
	/**
	 * RlN^CX^XԂB
	 * ̃\bhĂԑO create() \bhł̃NX
	 * KvB
	 *
	 * @return WorkflowServletConfig CX^X
	 */
	static WorkflowServletConfig getInstance() {
		return instance;
	}
	
	/**
	 * URL ԂB
	 * 
	 * @return URL
	 */
	String getURL() {
		return this.url;
	}
	
	/**
	 * XR[vԂB
	 *
	 * @return XR[v
	 */
	String getScope() {
		return this.scope;
	}
}
