/* $Id: DesktopPane.java,v 1.1 2007/10/19 07:29:57 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm;

import java.awt.Color;
import java.awt.Point;

import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;

/**
 * Nauticaワークフロー運用管理ツールのデスクトップ。
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class DesktopPane extends JDesktopPane
{
	/** シリアルバージョンID */
	private static final long serialVersionUID = 1L;

	/**
	 * Nauticaワークフロー運用管理ツールのデスクトップを生成する。
	 */
	public DesktopPane()
	{
		setBackground(Color.gray);
	}

	/**
	 * 開かれているすべてのフレームを閉じる。
	 */
	public void closeAllFrame()
	{
		JInternalFrame[] frames = getAllFrames();
		for (int i = frames.length - 1; i >= 0; i--) {
			frames[i].setVisible(false);
			frames[i].dispose();
		}
	}

	/**
	 * デスクトップ上の次の表示位置を返す。
	 *
	 * @return 次の表示位置
	 */
	public Point getNextLocation()
	{
		JInternalFrame[] frames = getAllFramesInLayer(JLayeredPane.DEFAULT_LAYER.intValue());
		if (frames == null) return new Point(0, 0);

		int count = frames.length;
		return new Point(25 * (count % 6), 25 * (count % 6));
	}
}
