/* $Id: MenuBar.java,v 1.1 2007/10/19 07:29:57 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm;

import javax.swing.ActionMap;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

import jp.co.argo21.nautica.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfadm.action.ActionNames;

/**
 * Nauticaワークフロー運用管理ツールのメニューバーである。
 *
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
final class MenuBar extends JMenuBar
{
	/** シリアルバージョンID */
	private static final long serialVersionUID = 1L;

	/** ファイル */
	private JMenu     fileMenu            = new JMenu();
	/** 定義登録 */
	private JMenuItem registerDefItem     = new JMenuItem();
	/** 開く */
	private JMenuItem openItem            = new JMenuItem();
	/** シャットダウン */
//	private JMenuItem shutdownItem        = new JMenuItem();
	/** 終了 */
	private JMenuItem exitItem            = new JMenuItem();


	/** ツール */
	private JMenu     toolMenu            = new JMenu();
	/** 例外ビューア */
	private JMenuItem exceptionViewerItem = new JMenuItem();
	/** 設定 */
	private JMenuItem preferenceItem      = new JMenuItem();

	/** ヘルプ */
	private JMenu     helpMenu            = new JMenu();
	/** ヘルプ表示 */
	private JMenuItem helpItem            = new JMenuItem();
	/** バージョン表示 */
	private JMenuItem versionItem         = new JMenuItem();

	/**
	 * メニューバーを構築する。
	 */
	public MenuBar()
	{
		ResourceManager rm = WorkflowAdminManager.getResourceManager();
		ActionMap am = WorkflowAdminManager.getActionMap();
		
		initFileMenu(rm, am);
		initToolMenu(rm, am);
		initHelpMenu(rm, am);
	}
	
	/**
	 * ファイルメニューを構築する。
	 * 
	 * @param rm	リソースマネージャ
	 * @param am	アクションマップ
	 */
	private void initFileMenu(ResourceManager rm, ActionMap am)
	{
		registerDefItem.setText(rm.getResource("Menu.file.register"));
		registerDefItem.setMnemonic('R');
		registerDefItem.addActionListener(am.get(ActionNames.REGISTER_DEF));

		openItem.setText(rm.getResource("Menu.file.open"));
		openItem.setMnemonic('O');
		openItem.addActionListener(am.get(ActionNames.OPEN_ENGINE));

//		shutdownItem.setText(rm.getResource("Menu.file.shutdown"));
//		shutdownItem.setMnemonic('D');
//		shutdownItem.addActionListener(am.get(ActionNames.SHUTDOWN_ENGINE));

		exitItem.setText(rm.getResource("Menu.file.exit"));
		exitItem.setMnemonic('X');
		exitItem.addActionListener(am.get(ActionNames.EXIT));

		fileMenu.setText(rm.getResource("Menu.file"));
		fileMenu.setMnemonic('F');
		fileMenu.add(registerDefItem);
		fileMenu.add(openItem);
//		fileMenu.add(shutdownItem);
		fileMenu.addSeparator();
		fileMenu.add(exitItem);

		add(fileMenu);
	}
	
	/**
	 * ツールメニューを構築する。
	 * 
	 * @param rm	リソースマネージャ
	 * @param am	アクションマップ
	 */
	private void initToolMenu(ResourceManager rm, ActionMap am)
	{
		exceptionViewerItem.setText(rm.getResource("Menu.tool.exception"));
		exceptionViewerItem.setMnemonic('E');
		exceptionViewerItem.addActionListener(am.get(ActionNames.EXCEPTION_VIEWER));

		preferenceItem.setText(rm.getResource("Menu.tool.preference"));
		preferenceItem.setMnemonic('O');
		preferenceItem.addActionListener(am.get(ActionNames.PREFERENCES));

		toolMenu.setText(rm.getResource("Menu.tool"));
		toolMenu.setMnemonic('T');
		toolMenu.add(exceptionViewerItem);
		toolMenu.addSeparator();
		toolMenu.add(preferenceItem);

		add(toolMenu);
	}
	
	/**
	 * ヘルプメニューを構築する。
	 * 
	 * @param rm	リソースマネージャ
	 * @param am	アクションマップ
	 */
	private void initHelpMenu(ResourceManager rm, ActionMap am)
	{
		helpItem.setText(rm.getResource("Menu.help.help"));
		helpItem.setMnemonic('H');
		helpItem.addActionListener(am.get(ActionNames.HELP));

		versionItem.setText(rm.getResource("Menu.help.version"));
		versionItem.setMnemonic('A');
		versionItem.addActionListener(am.get(ActionNames.ABOUT));

		helpMenu.setText(rm.getResource("Menu.help"));
		helpMenu.setMnemonic('H');
		helpMenu.add(helpItem);
		helpMenu.addSeparator();
		helpMenu.add(versionItem);

		add(helpMenu);
	}
}
