/* $Id: RegisterInfo.java,v 1.1 2007/10/19 07:29:57 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm.definition.register;

/**
 * 定義ファイル登録情報。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class RegisterInfo
{
	/** パッケージ名 */
	private String packageName;
	/** XPDL定義ファイル相対パス */
	private String registerPath;

	/**
	 * 定義ファイル登録情報を生成する。
	 */
	public RegisterInfo()
	{
	}

	/**
	 * 定義ファイル登録情報を生成する。
	 * パッケージは16文字の英数字。相対パスは、リポジトリに配置した
	 * XPDL定義ファイルの相対パスである。(ex. foo/bar.xpdl)
	 *
	 * @param packageName パッケージ名
	 * @param registerPath パッケージ相対パス
	 */
	public RegisterInfo(String packageName, String registerPath)
	{
		this.packageName = packageName;
		this.registerPath = registerPath;
	}

	/**
	 * パッケージ名を返す。
	 *
	 * @return パッケージ名
	 */
	public String getPackageName()
	{
		return packageName;
	}

	/**
	 * XPDL定義ファイル相対パスを返す。
	 *
	 * @return XPDL定義ファイル相対パス
	 */
	public String getRegisterPath()
	{
		return registerPath;
	}

	/**
	 * パッケージ名を設定する。
	 * 
	 * @param packageName パッケージ名への設定値
	 */
	public void setPackageName(String packageName)
	{
		this.packageName = packageName;
	}

	/**
	 * XPDL定義ファイル相対パスを設定する。
	 * 
	 * @param registerPath XPDL定義ファイル相対パスへの設定値
	 */
	public void setRegisterPath(String registerPath)
	{
		this.registerPath = registerPath;
	}
}
