/* $Id: ActivityDefinitionPropertyDialog.java,v 1.2 2007/12/10 09:34:42 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm.engineview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Properties;

import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import jp.co.argo21.nautica.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfadm.WorkflowAdminManager;
import jp.co.argo21.nautica.tool.wfadm.common.DialogComponent;
import jp.co.argo21.nautica.workflow.definition.TransitionDefinition;
import jp.co.argo21.nautica.workflow.definition.VariableDefinition;

/**
 * アクティビティ定義用プロパティ値表示用のダイアログを提供する。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.2 $
 * @since   Nautica Workflow 1.0
 */
public class ActivityDefinitionPropertyDialog  extends JDialog
{
	/** シリアルバージョンID */
	private static final long serialVersionUID = 1L;

	/** 表示中のDialogComponent */
	private DialogComponent dialogComponent;

	/**
	 * ダイアログを表示する。
	 * 
	 * @param c	 親コンポーネント
	 * @param title タイトル情報
	 * @param prop プロパティ
	 * @param trs 遷移情報
	 * @param vars プロセス変数
	 */
	public static void showDialog(Component c, String title, Properties prop, List<TransitionDefinition> trs, List<VariableDefinition> vars)
	{
		Frame frame = JOptionPane.getFrameForComponent(c);
		ActivityDefinitionPropertyDialog dialog =
			new ActivityDefinitionPropertyDialog(frame, title,  prop, trs, vars);
		dialog.setVisible(true);
		dialog.dispose();
	}

	/**
	 * ダイアログを生成する。
	 * 
	 * @param frame 親フレーム
	 * @param title タイトル情報
	 * @param prop プロパティ
	 * @param trs 遷移情報
	 * @param vars プロセス変数
	 */
	private ActivityDefinitionPropertyDialog(Frame frame, String title, Properties prop, List<TransitionDefinition> trs, List<VariableDefinition> vars)
	{
		super(frame, true);
		
		dialogComponent = new ActivityDefinitionPropertyComponent(prop, trs, vars);
		createDialog(title);
		setLocationRelativeTo(frame);
	}

	/**
	 * ダイアログを作成する。
	 *
	 * @param title タイトル情報
	 */
	private void createDialog(String title)
	{
		ResourceManager rm = WorkflowAdminManager.getResourceManager();

		setTitle(rm.getResource("PropertyDialog.title") + "(" + title + ")");
		
		JScrollPane scroll = new JScrollPane();
		scroll.setViewportView((JComponent)dialogComponent);

		JPanel buttonPane = new JPanel();
		buttonPane.setLayout(new FlowLayout(FlowLayout.RIGHT, 10, 10));

		ActionListener closeListener = new CloseAction();
		JButton closeButton = new JButton(rm.getResource("JButton.label.close"));
		closeButton.addActionListener(closeListener);
		buttonPane.add(closeButton);

		Container contentPane = getContentPane();
		contentPane.add(scroll, BorderLayout.CENTER);
		contentPane.add(buttonPane, BorderLayout.PAGE_END);

		pack();
	}

	/**
	 * 閉じるボタンが押されたときの処理
	 */
	private class CloseAction implements ActionListener
	{
		/**
		 * 閉じる。
		 * 
		 * @param e	イベント
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			setVisible(false);
		}
	}
}
