/* $Id: ProcessDefinitionFlowPanel.java,v 1.2 2007/12/10 09:34:42 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm.engineview;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

import jp.co.argo21.nautica.commons.swing.DialogUtilities;
import jp.co.argo21.nautica.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfadm.IconManager;
import jp.co.argo21.nautica.tool.wfadm.WorkflowAdminManager;
import jp.co.argo21.nautica.workflow.definition.ActivityDefinition;
import jp.co.argo21.nautica.workflow.definition.PackageDefinition;
import jp.co.argo21.nautica.workflow.definition.ProcessDefinition;
import jp.co.argo21.nautica.workflow.definition.TransitionDefinition;
import jp.co.argo21.nautica.workflow.definition.VariableDefinition;
import jp.co.argo21.nautica.workflow.wfmc.ProcDef;

/**
 * プロセス定義フロー表示用のパネルである。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.2 $
 * @since   Nautica Workflow 1.0
 */
public class ProcessDefinitionFlowPanel extends JPanel
{
	/** シリアルバージョンID */
	private static final long serialVersionUID = 1L;

	/** ツールバー */
	private JToolBar toolbar;
	/** エンジンビューフレーム */
	@SuppressWarnings("unused")
	private EngineViewFrame frame;
	/** フロー表示エリア */
	private ProcessDefinitionFlowView view;
	/** プロセス定義情報 */
	private ProcDef procDef;
	/** パッケージ定義 */
	private PackageDefinition packageDefinition;
	
	/**
	 * プロセス定義フロー表示用のパネルを生成する。
	 *
	 * @param isDoubleBuffered
	 */
	public ProcessDefinitionFlowPanel(EngineViewFrame frame, ProcDef pd, PackageDefinition def)
	{
		super(new BorderLayout(), true);
		
		this.frame = frame;
		this.procDef = pd;
		this.packageDefinition = def;
		
		createFlowView();
		createToolBar();
	}
	
	/**
	 * プロセス定義名を返します。
	 *
	 * @return
	 */
	String getProcessDefinitionName()
	{
		return procDef.getID();
	}
	
	/**
	 * ツールバーを作成します。
	 */
	private void createToolBar()
	{
		ResourceManager rm = WorkflowAdminManager.getResourceManager();

		toolbar = new JToolBar(JToolBar.VERTICAL);
		toolbar.setFloatable(false);

		Icon icon = IconManager.getIcon("property");
		JButton propButton = new JButton();
		propButton.setIcon(icon);
		propButton.setToolTipText(rm.getResource("ProcessDefinitionFlowPanel.toolbar.label.0"));
		propButton.addActionListener(new ShowPropertyAction());

		toolbar.add(propButton);

		add(toolbar, BorderLayout.WEST);
	}

	/**
	 * フロー表示エリアを作成します。
	 */
	private void createFlowView()
	{
		int index = getProcessDefinitionIndex();
		List<ProcessDefinition> procs = packageDefinition.getProcesses();
		ProcessDefinition def = procs.get(index);
		view = new ProcessDefinitionFlowView(def);
		JScrollPane sp = new JScrollPane(view);
		add(sp, BorderLayout.CENTER);
	}

	/**
	 * アクティビティ定義のプロパティ情報を作成して返す。
	 *
	 * @param rm リソースマネージャ
	 * @param act アクティビティ定義
	 * @return プロパティ情報
	 */
	private Properties getProperties(ResourceManager rm, ActivityDefinition act)
	{
		Properties prop = new Properties();
		
		prop.put(rm.getResource("ActivityDefinition.key.0"),  "" + act.getAffiliateBID());
		prop.put(rm.getResource("ActivityDefinition.key.1"),  "" + act.getApplicationID());
		prop.put(rm.getResource("ActivityDefinition.key.2"),  "" + act.getBlockID());
		prop.put(rm.getResource("ActivityDefinition.key.3"),  "" + act.getDescription());
		prop.put(rm.getResource("ActivityDefinition.key.4"),  "" + act.getEngineName());
		prop.put(rm.getResource("ActivityDefinition.key.5"),  "" + act.getID());
		prop.put(rm.getResource("ActivityDefinition.key.6"),  "" + act.getName());
		prop.put(rm.getResource("ActivityDefinition.key.7"),  "" + act.getParentBID());
		prop.put(rm.getResource("ActivityDefinition.key.8"),  "" + act.getPerformerID());
		prop.put(rm.getResource("ActivityDefinition.key.9"),  "" + act.getSubprocessID());
		prop.put(rm.getResource("ActivityDefinition.key.10"), "" + act.getType());
		prop.put(rm.getResource("ActivityDefinition.key.11"), "" + act.getExecution());
		prop.put(rm.getResource("ActivityDefinition.key.12"), "" + act.getLimit());
		prop.put(rm.getResource("ActivityDefinition.key.13"), "" + act.getLogicalX());
		prop.put(rm.getResource("ActivityDefinition.key.14"), "" + act.getLogicalY());
		
		return prop;
	}
	
	/**
	 * プロセス定義のインデクス番号を返す。
	 *
	 * @return インデクス番号
	 */
	private int getProcessDefinitionIndex()
	{
		String pdid = procDef.getID();
		
		int begin = pdid.lastIndexOf('-') + 1;
		int end = pdid.length();
		String indexString = pdid.substring(begin, end);
		int index = Integer.parseInt(indexString);
		return index;
	}
	
	/**
	 * アクティビティ要素の遷移情報を取得する。
	 * 
	 * @param act アクティビティ要素
	 * @return 遷移情報
	 */
	private List<TransitionDefinition> getTransitions(ActivityDefinition act)
	{
		List<TransitionDefinition> trs = new ArrayList<TransitionDefinition>();
		if (act == null) return trs;

		int index = getProcessDefinitionIndex();
		List<ProcessDefinition> procs = packageDefinition.getProcesses();
		ProcessDefinition proc = procs.get(index);
		for (TransitionDefinition t : proc.getTransitions()) {
			if (act == t.getSource()) {
				trs.add(t);
			}
		}
		return trs;
	}
	
	/**
	 * プロパティを表示するアクション。
	 *
	 * @author  nito(Argo 21, Corp.)
	 * @version $Revision: 1.2 $
	 * @since   Nautica Workflow 1.0
	 */
	private class ShowPropertyAction implements ActionListener
	{
		/**
		 * プロパティを表示する。
		 *
		 * @param e イベント
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			if (view == null) return;
			
			ResourceManager rm = WorkflowAdminManager.getResourceManager();

			ActivityDefinition act = view.getSelectedActivity();
			if (act == null) {
				DialogUtilities.showError(rm.getResource("E9018"));
				return;
			}

			Properties prop = getProperties(rm, act);
			List<TransitionDefinition> trs = getTransitions(act);
			List<VariableDefinition> vars = packageDefinition.getVariables();
			//PropertyDialog.showDialog(ProcessDefinitionFlowPanel.this, act.getName(), prop);
			ActivityDefinitionPropertyDialog.showDialog(
					ProcessDefinitionFlowPanel.this, act.getName(), prop, trs, vars);
		}
	}
}
