/* $Id: ProcessNode.java,v 1.2 2007/12/10 09:34:42 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm.engineview;

import java.util.Enumeration;
import java.util.Properties;

import javax.swing.tree.TreeNode;

import jp.co.argo21.nautica.commons.util.ResourceManager;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.Process;
import jp.co.argo21.nautica.workflow.wfmc.ProcessState;

/**
 * エンジンビューのプロセスツリーの末端ノードである。
 * プロセス定義ノード配下にマップされる。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.2 $
 * @since   Nautica Workflow 1.0
 */
public class ProcessNode implements EngineTreeNode
{
	/** 親ノード */
	private ProcessDefinitionNode parentNode;

	/** プロセス情報 */
	private Process process;

	/**
	 * プロセスノードを生成する。
	 */
	public ProcessNode(ProcessDefinitionNode parent, Process proc)
	{
		parentNode = parent;
		process = proc;
	}

	/**
	 * 子ノードをEnumerationで返す。
	 *
	 * @return 子ノード
	 * @see javax.swing.tree.TreeNode#children()
	 */
	public Enumeration<?> children()
	{
		return null;
	}

	/**
	 * 子ノードを受け入れるかどうかを返す。
	 *
	 * @return 判定値
	 * @see javax.swing.tree.TreeNode#getAllowsChildren()
	 */
	public boolean getAllowsChildren()
	{
		return false;
	}

	/**
	 * インデクスで指定された子ノードを返す。
	 *
	 * @param childIndex インデクス
	 * @return 子ノード
	 * @see javax.swing.tree.TreeNode#getChildAt(int)
	 */
	public TreeNode getChildAt(int childIndex)
	{
		return null;
	}

	/**
	 * 子ノードの数を返す。
	 *
	 * @return 子ノード数
	 * @see javax.swing.tree.TreeNode#getChildCount()
	 */
	public int getChildCount()
	{
		return 0;
	}

	/**
	 * 指定されたノードのインデクス値を返す。
	 *
	 * @param node ノード
	 * @return インデクス
	 * @see javax.swing.tree.TreeNode#getIndex(javax.swing.tree.TreeNode)
	 */
	public int getIndex(TreeNode node)
	{
		return 0;
	}
	
	/**
	 * 親ノードを返す。
	 *
	 * @return 親ノード
	 * @see javax.swing.tree.TreeNode#getParent()
	 */
	public TreeNode getParent()
	{
		return parentNode;
	}

	/**
	 * 末端ノードかどうかを返す。
	 *
	 * @return 末端ノードならtrue
	 * @see javax.swing.tree.TreeNode#isLeaf()
	 */
	public boolean isLeaf()
	{
		return true;
	}
	
	/**
	 * ノード名を返す。
	 *
	 * @return
	 * @see java.lang.Object#toString()
	 */
	public String toString()
	{
		return process.getName() + "(" + process.getID() + ")";
	}
	
	/**
	 * ノードの情報を更新する。
	 *
	 * @param filter
	 * @throws Exception
	 * @see jp.co.argo21.nautica.tool.wfadm.engineview.EngineTreeNode#reload(jp.co.argo21.nautica.workflow.wfmc.Filter)
	 */
	public void reload(Filter filter) throws Exception
	{
	}
	
	/**
	 * ノードのプロパティ情報を返す。
	 *
	 * @param rm リソースマネージャ
	 * @return プロパティ
	 * @see jp.co.argo21.nautica.tool.wfadm.engineview.EngineTreeNode#getProperties()
	 */
	public Properties getProperties(ResourceManager rm)
	{
		Properties prop = new Properties();

		ProcessState state = ProcessState.getState(process.getProcessState());
		prop.put(rm.getResource("ProcessNode.key.0"), process.getID());
		prop.put(rm.getResource("ProcessNode.key.1"), "" + process.getName());
		prop.put(rm.getResource("ProcessNode.key.2"), "" + process.getPackageID());
		prop.put(rm.getResource("ProcessNode.key.3"), "" + process.getProcDefinitionID());
		prop.put(rm.getResource("ProcessNode.key.4"), "" + process.getDurationLimit());
		prop.put(rm.getResource("ProcessNode.key.5"), "" + process.getStartDate());
		prop.put(rm.getResource("ProcessNode.key.6"), "" + process.getStarterID());
		prop.put(rm.getResource("ProcessNode.key.7"), "" + process.getUpdateDate());
		prop.put(rm.getResource("ProcessNode.key.8"), state.toString());
		prop.put(rm.getResource("ProcessNode.key.9"), "" + state.toInt());

		return prop;
	}
	
	/**
	 * エンジンビューフレームを返す。
	 *
	 * @return エンジンビューフレーム
	 */
	EngineViewFrame getFrame()
	{
		return parentNode.getFrame();
	}
	
	/**
	 * 保持しているプロセス情報を返す。
	 *
	 * @return プロセス情報
	 */
	Process getProcess()
	{
		return process;
	}

	/**
	 * プロセス情報を設定する。
	 * 
	 * @param process プロセス情報
	 */
	public void setProcess(Process process)
	{
		this.process = process;
	}
}
