-- テーブル作成

-- スキーマ定義名：ワークフローエンジン
-- スキーマ定義ID：NAUTICA
-- 備考：テーブル操作用
CREATE SCHEMA NAUTICA;


--テーブル作成のための準備
SET SCHEMA NAUTICA;


-- テーブル名：キーシーケンス管理
-- テーブルID：WF_KEYSEQ
-- M/T：T
-- 備考：ユニークキー取得用
CREATE TABLE WF_KEYSEQ (
    NAME            VARCHAR(32)     NOT NULL    PRIMARY KEY,
    SEQ             INTEGER         NOT NULL    DEFAULT 0
);


-- テーブル名：ワークフロー定義管理
-- テーブルID：WF_DEFINITION
-- M/T：M
-- 備考：
CREATE TABLE WF_DEFINITION (
    PROC_DEF_ID     VARCHAR(64)     NOT NULL    PRIMARY KEY,
    PATH            VARCHAR(128)    NOT NULL,
    INTERNAL_PDID   VARCHAR(64)     NOT NULL,
    REGISTER_DATE   TIMESTAMP       NOT NULL,
    DEF_STATE       INTEGER         NOT NULL
);


-- テーブル名：組織
-- テーブルID：WF_ORGANIZATION
-- M/T：M
-- 備考：
CREATE TABLE WF_ORGANIZATION (
    ORG_ID          VARCHAR(64)     NOT NULL    PRIMARY KEY,
    ORG_NAME        VARCHAR(128)    NOT NULL,
    HIGHER_ORG_ID   VARCHAR(64)
);


-- テーブル名：ユーザ
-- テーブルID：WF_USER
-- M/T：M
-- 備考：
CREATE TABLE WF_USER (
    USER_ID         VARCHAR(64)     NOT NULL    PRIMARY KEY,
    FIRST_NAME      VARCHAR(64)     NOT NULL,
    LAST_NAME       VARCHAR(64)     NOT NULL,
    PASSWORD        VARCHAR(64)     NOT NULL,
    MAIL_ADDRESS    VARCHAR(64)     NOT NULL
);


-- テーブル名：役割
-- テーブルID：WF_ROLE
-- M/T：M
-- 備考：
CREATE TABLE WF_ROLE (
    ROLE_ID         VARCHAR(64)     NOT NULL    PRIMARY KEY,
    DESCRIPTION     VARCHAR(128)
);


-- テーブル名：組織ユーザ関連
-- テーブルID：WF_ORGUSERMAP
-- M/T：M
-- 備考：
CREATE TABLE WF_ORGUSERMAP (
    ORG_ID          VARCHAR(64)     NOT NULL,
    USER_ID         VARCHAR(64)     NOT NULL,
    CONSTRAINT WF_ORGUSERMAP_PK PRIMARY KEY (
        ORG_ID,
        USER_ID
    )
);


-- テーブル名：組織役割関連
-- テーブルID：WF_ORGROLEMAP
-- M/T：M
-- 備考：
CREATE TABLE WF_ORGROLEMAP (
    ROLE_ID         VARCHAR(64)     NOT NULL,
    ORG_ID          VARCHAR(64)     NOT NULL,
    CONSTRAINT WF_ORGROLEMAP_PK PRIMARY KEY (
        ROLE_ID,
        ORG_ID
    )
);


-- テーブル名：ユーザ役割関連
-- テーブルID：WF_USERROLEMAP
-- M/T：M
-- 備考：
CREATE TABLE WF_USERROLEMAP (
    ROLE_ID         VARCHAR(64)     NOT NULL,
    USER_ID         VARCHAR(64)     NOT NULL,
    CONSTRAINT WF_USERROLEMAP_PK PRIMARY KEY (
        ROLE_ID,
        USER_ID
    )
);


-- テーブル名：プロセスインスタンス
-- テーブルID：WF_PROCESS
-- M/T：T
-- 備考：
CREATE TABLE WF_PROCESS (
    PROC_ID         VARCHAR(64)     NOT NULL    PRIMARY KEY,
    NAME            VARCHAR(128),
    PACKAGE_ID      VARCHAR(64)     NOT NULL,
    PROC_DEF_ID     VARCHAR(64)     NOT NULL,
    START_DATE      TIMESTAMP       NOT NULL,
    STARTER_ID      VARCHAR(64)     NOT NULL,
    DURATION_LIMIT  TIMESTAMP       NOT NULL,
    PROC_STATE      INTEGER         NOT NULL    DEFAULT 1,
    UPDATE_DATE     TIMESTAMP
);


-- テーブル名：プロセス変数インスタンス
-- テーブルID：WF_VARIABLE
-- M/T：T
-- 備考：
CREATE TABLE WF_VARIABLE (
    VAR_ID          VARCHAR(64)     NOT NULL    PRIMARY KEY,
    NAME            VARCHAR(128)    NOT NULL,
    PROC_ID         VARCHAR(64)     NOT NULL,
    VAR_DEF_ID      VARCHAR(64)     NOT NULL,
    TYPE            INTEGER         NOT NULL,
    VALUE           VARCHAR(32672)    NOT NULL,
    UPDATE_DATE     TIMESTAMP
);


-- テーブル名：アクティビティインスタンス
-- テーブルID：WF_ACTIVITY
-- M/T：T
-- 備考：
CREATE TABLE WF_ACTIVITY (
    PROC_ID         VARCHAR(64)     NOT NULL,
    ACT_ID          VARCHAR(64)     NOT NULL,
    ACT_DEF_ID      VARCHAR(64)     NOT NULL,
    START_DATE      TIMESTAMP       NOT NULL,
    STARTER_ID      VARCHAR(64)     NOT NULL,
    DURATION_LIMIT  TIMESTAMP       NOT NULL,
    BLOCK_ID        VARCHAR(64),
    ACT_STATE       INTEGER         NOT NULL    DEFAULT 1,
    ACTOR_ID        VARCHAR(64),
    UPDATE_DATE     TIMESTAMP,
    CONSTRAINT WF_ACTIVITY_PK PRIMARY KEY (
        PROC_ID,
        ACT_ID
    )
);


-- テーブル名：作業項目
-- テーブルID：WF_WORKITEM
-- M/T：T
-- 備考：
CREATE TABLE WF_WORKITEM (
    WORK_ID         VARCHAR(64)     NOT NULL    PRIMARY KEY,
    PROC_ID         VARCHAR(64)     NOT NULL,
    ACT_ID          VARCHAR(64)     NOT NULL,
    PARTICIPANT_TYPE INTEGER,
    PARTICIPANT_NAME VARCHAR(128)
);


-- テーブル名：プロセス完了待ちアクティビティ
-- テーブルID：WF_WAITPROCACT
-- M/T：T
-- 備考：
CREATE TABLE WF_WAITPROCACT (
    PROC_ID         VARCHAR(64)     NOT NULL,
    ACT_ID          VARCHAR(64)     NOT NULL,
    SUBPROC_ID      VARCHAR(64)     NOT NULL
);


-- テーブル名：並行処理ブロック
-- テーブルID：WF_CONCURBLOCK
-- M/T：T
-- 備考：
CREATE TABLE WF_CONCURBLOCK (
    BLOCK_ID        VARCHAR(64)     NOT NULL,
    UPPER_BLOCK_ID  VARCHAR(64),
    PROC_ID         VARCHAR(64)     NOT NULL,
    ACT_ID          VARCHAR(64)     NOT NULL
);


-- テーブル名：アプリケーション実行
-- テーブルID：WF_APPEXEC
-- M/T：T
-- 備考：
CREATE TABLE WF_APPEXEC (
    APP_NAME        VARCHAR(64)     NOT NULL,
    TOOL_AGENT      VARCHAR(64)     NOT NULL,
    EXEC_ID         BIGINT          NOT NULL,
    START_DATE      TIMESTAMP,
    STARTER_ID      VARCHAR(64),
    END_DATE        TIMESTAMP,
    APP_STATE       INTEGER                     DEFAULT 2,
    CONSTRAINT WF_APPEXEC_PK PRIMARY KEY (
        APP_NAME,
        TOOL_AGENT,
        EXEC_ID
    )
);


-- テーブル名：プロセス状態変更履歴
-- テーブルID：WF_PROCESSHIST
-- M/T：T
-- 備考：
CREATE TABLE WF_PROCESSHIST (
    PROC_ID         VARCHAR(64)     NOT NULL,
    PACKAGE_ID      VARCHAR(64)     NOT NULL,
    PROC_DEF_ID     VARCHAR(64)     NOT NULL,
    PREV_STATE      INTEGER,
    NEW_STATE       INTEGER,
    UPDATE_DATE     TIMESTAMP,
    REASON          VARCHAR(128)
);


-- テーブル名：プロセス変数変更履歴
-- テーブルID：WF_VARIABLEHIST
-- M/T：T
-- 備考：
CREATE TABLE WF_VARIABLEHIST (
    VAR_ID          VARCHAR(64)     NOT NULL,
    PROC_ID         VARCHAR(64)     NOT NULL,
    VAR_DEF_ID      VARCHAR(64)     NOT NULL,
    TYPE            INTEGER         NOT NULL    DEFAULT 0,
    PREV_VALUE      VARCHAR(32672),
    NEW_VALUE       VARCHAR(32672)    NOT NULL,
    UPDATE_DATE     TIMESTAMP       NOT NULL,
    REASON          VARCHAR(128),
    ACT_ID          VARCHAR(64)
);


-- テーブル名：アクティビティ状態変更履歴
-- テーブルID：WF_ACTIVITYHIST
-- M/T：T
-- 備考：
CREATE TABLE WF_ACTIVITYHIST (
    PROC_ID         VARCHAR(64)     NOT NULL,
    ACT_ID          VARCHAR(64)     NOT NULL,
    ACT_DEF_ID      VARCHAR(64)     NOT NULL,
    ACTOR_ID        VARCHAR(64)     NOT NULL,
    PREV_STATE      INTEGER,
    NEW_STATE       INTEGER         NOT NULL,
    UPDATE_DATE     TIMESTAMP       NOT NULL,
    REASON          VARCHAR(128)
);


-- テーブル名：起動先プロセス
-- テーブルID：WF_ETAPROCESS
-- M/T：T
-- 備考：
CREATE TABLE WF_ETAPROCESS (
    ENGINE_ID       VARCHAR(64)     NOT NULL,
    PROCESS_ID      VARCHAR(64)     NOT NULL,
    ROOT_PROC_ID    VARCHAR(64)     NOT NULL,
    ROOT_ACT_ID     VARCHAR(64)     NOT NULL,
    CONSTRAINT WF_ETAPROCESS_PK PRIMARY KEY (
        ENGINE_ID,
        PROCESS_ID
    )
);


-- テーブル名：起動元アクティビティ
-- テーブルID：WF_ETAACTIVITY
-- M/T：T
-- 備考：
CREATE TABLE WF_ETAACTIVITY (
    PROCESS_ID      VARCHAR(64)     NOT NULL    PRIMARY KEY,
    ENGINE_ID       VARCHAR(64)     NOT NULL,
    ROOT_PROC_ID    VARCHAR(64)     NOT NULL,
    ROOT_ACT_ID     VARCHAR(64)     NOT NULL
);


-- 外部キー制約作成

-- 制約名：WF_ORGANIZATION_FK
-- 親キー
--   テーブルID：WF_ORGANIZATION
--   項目ID：ORG_ID
-- 子キー
--   テーブルID：WF_ORGANIZATION
--   項目ID：HIGHER_ORG_ID
ALTER TABLE WF_ORGANIZATION ADD CONSTRAINT WF_ORGANIZATION_FK
        FOREIGN KEY (HIGHER_ORG_ID)
    REFERENCES 
        WF_ORGANIZATION (ORG_ID);


-- 制約名：WF_ORGANIZATION_ORGUSERMAP_FK
-- 親キー
--   テーブルID：WF_ORGANIZATION
--   項目ID：ORG_ID
-- 子キー
--   テーブルID：WF_ORGUSERMAP
--   項目ID：ORG_ID
ALTER TABLE WF_ORGUSERMAP ADD CONSTRAINT WF_ORGANIZATION_ORGUSERMAP_FK 
        FOREIGN KEY (ORG_ID)
    REFERENCES 
        WF_ORGANIZATION (ORG_ID);


-- 制約名：WF_USER_ORGUSERMAP_FK
-- 親キー
--   テーブルID：WF_USER
--   項目ID：USER_ID
-- 子キー
--   テーブルID：WF_ORGUSERMAP
--   項目ID：USER_ID
ALTER TABLE WF_ORGUSERMAP ADD CONSTRAINT WF_USER_ORGUSERMAP_FK 
        FOREIGN KEY (USER_ID)
    REFERENCES 
        WF_USER (USER_ID);


-- 制約名：WF_USER_USERROLEMAP_FK
-- 親キー
--   テーブルID：WF_USER
--   項目ID：USER_ID
-- 子キー
--   テーブルID：WF_USERROLEMAP
--   項目ID：USER_ID
ALTER TABLE WF_USERROLEMAP ADD CONSTRAINT WF_USER_USERROLEMAP_FK 
        FOREIGN KEY (USER_ID)
    REFERENCES 
        WF_USER (USER_ID);


-- 制約名：WF_ROLE_USERROLEMAP_FK
-- 親キー
--   テーブルID：WF_ROLE
--   項目ID：ROLE_ID
-- 子キー
--   テーブルID：WF_USERROLEMAP
--   項目ID：ROLE_ID
ALTER TABLE WF_USERROLEMAP ADD CONSTRAINT WF_ROLE_USERROLEMAP_FK 
        FOREIGN KEY (ROLE_ID)
    REFERENCES 
        WF_ROLE (ROLE_ID);


-- 制約名：WF_ROLE_ORGROLEMAP_FK
-- 親キー
--   テーブルID：WF_ROLE
--   項目ID：ROLE_ID
-- 子キー
--   テーブルID：WF_ORGROLEMAP
--   項目ID：ROLE_ID
ALTER TABLE WF_ORGROLEMAP ADD CONSTRAINT WF_ROLE_ORGROLEMAP_FK 
        FOREIGN KEY (ROLE_ID)
    REFERENCES 
        WF_ROLE (ROLE_ID);


-- 制約名：WF_ORGANIZATION_ORGROLEMAP_FK
-- 親キー
--   テーブルID：WF_ORGANIZATION
--   項目ID：ORG_ID
-- 子キー
--   テーブルID：WF_ORGROLEMAP
--   項目ID：ORG_ID
ALTER TABLE WF_ORGROLEMAP ADD CONSTRAINT WF_ORGANIZATION_ORGROLEMAP_FK 
        FOREIGN KEY (ORG_ID)
    REFERENCES 
        WF_ORGANIZATION (ORG_ID);


-- 制約名：WF_PROCESS_VARIABLE_FK
-- 親キー
--   テーブルID：WF_PROCESS
--   項目ID：PROC_ID
-- 子キー
--   テーブルID：WF_VARIABLE
--   項目ID：PROC_ID
ALTER TABLE WF_VARIABLE ADD CONSTRAINT WF_PROCESS_VARIABLE_FK 
        FOREIGN KEY (PROC_ID)
    REFERENCES 
        WF_PROCESS (PROC_ID);


-- 制約名：WF_PROCESS_ACTIVITY_FK
-- 親キー
--   テーブルID：WF_PROCESS
--   項目ID：PROC_ID
-- 子キー
--   テーブルID：WF_ACTIVITY
--   項目ID：PROC_ID
ALTER TABLE WF_ACTIVITY ADD CONSTRAINT WF_PROCESS_ACTIVITY_FK 
        FOREIGN KEY (PROC_ID)
    REFERENCES 
        WF_PROCESS (PROC_ID);


-- 制約名：WF_ACTIVITY_WORKITEM_FK
-- 親キー
--   テーブルID：WF_ACTIVITY
--   項目ID：PROC_ID, ACT_ID
-- 子キー
--   テーブルID：WF_WORKITEM
--   項目ID：PROC_ID, ACT_ID
ALTER TABLE WF_WORKITEM ADD CONSTRAINT WF_ACTIVITY_WORKITEM_FK
        FOREIGN KEY (PROC_ID, ACT_ID)
    REFERENCES 
        WF_ACTIVITY (PROC_ID, ACT_ID);


-- 制約名：WF_ACTIVITY_CONCURBLOCK_FK
-- 親キー
--   テーブルID：WF_ACTIVITY
--   項目ID：PROC_ID, ACT_ID
-- 子キー
--   テーブルID：WF_CONCURBLOCK
--   項目ID：PROC_ID, ACT_ID
ALTER TABLE WF_CONCURBLOCK ADD CONSTRAINT WF_ACTIVITY_CONCURBLOCK_FK
        FOREIGN KEY (PROC_ID, ACT_ID)
    REFERENCES 
        WF_ACTIVITY (PROC_ID, ACT_ID);


-- 制約名：WF_ACTIVITY_WAITPROCACT_FK
-- 親キー
--   テーブルID：WF_ACTIVITY
--   項目ID：PROC_ID, ACT_ID
-- 子キー
--   テーブルID：WF_WAITPROCACT
--   項目ID：PROC_ID, ACT_ID
ALTER TABLE WF_WAITPROCACT ADD CONSTRAINT WF_ACTIVITY_WAITPROCACT_FK
        FOREIGN KEY (PROC_ID, ACT_ID)
    REFERENCES 
        WF_ACTIVITY (PROC_ID, ACT_ID);
