<?php
/*
 NCE (Neetchan Cloud Environment.)
 name: nc_update_readcnt_db.php
 author: Akira Ohta (akohta001.gmail.com)
 date: 2013-apr-14th
 description:
 
 */
include_once "account.php";
include_once "preference.php";
include_once "database.php";
include_once "log.php";
include_once "http_util.php";
include_once "error_code.php";

$user_id = $_POST['user'];
$hashed_passwd = $_POST['hashed_passwd'];
$board_name = $_POST['board_name'];
$dat_name = $_POST['dat_name'];
$type1 = $_POST['type1'];
$type2 = $_POST['type2'];

//--- authorization ---
$user = chk_passwd( $user_id, $hashed_passwd);
if(FALSE === $user){
	echo $ERROR_MSG;
	exit;
}

//--- parameter check start ---
if(!chk_param($board_name) || !chk_param($dat_name) || 
	!chk_param($type1)){
	echo ERROR303;
	exit;
}
if(!is_numeric($type1)){
	echo ERROR303;
	exit;
}
if($type1!=2 && $type1!=3 && $type1!=5 && $type1!=6){
	echo ERROR304;
	exit;
}
//--- parameter check end ---

$table_name = TABLE_PREFIX."tbl{$user->home_dir}";
$query = <<< QUERY1
select res_number, record_type from $table_name 
    where board_name='{$board_name}' and dat_name='{$dat_name}' 
    and ( record_type = '{$type1}'
QUERY1;

if(chk_param($type2)){
	if(!is_numeric($type2) ||
		($type2!=2 && $type2!=3 && $type2!=5 && $type2!=6) ||
		($type1 == $type2)){
		echo ERROR303;
		exit;
	}
	$query = $query." or record_type = '{$type2}')"; 
}else{
	$query = $query." )"; 
}

try{
	$db->open();
	$result = $db->execute($query);
	
	if(!$result){
		echo ERROR503;
		exit;
	}
	$db->close();
}catch(Exception $e){
	$error = __FILE__."(".__LINE__.
		") An error occured during query.";
	nc_logging($error, $e);
	echo ERROR500;
	exit;
}

echo SUCCESS100;
for($i = 0; $i < $result->num_rows; $i++){
	$row = $result->fetch_assoc();
	echo $row['record_type']."=".$row['res_number']."\n";
}

?>
