/*
    TCFbEAdjustedWeightedSumWithMedianOfColumn.h    June 6, 2004.

    Copyright (C) 2003-2004 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#ifndef TCFbEAdjustedWeightedSumWithMedianOfColumnH
#define TCFbEAdjustedWeightedSumWithMedianOfColumnH
//---------------------------------------------------------------------------
#include "TCFbEWeightedSum.h"

#include "TCFbEToolkit.h"
#include <math.h>

#include "TCFbENeighbor.h"
//---------------------------------------------------------------------------
class TCFbEAdjustedWeightedSumWithMedianOfColumn : public TCFbEWeightedSum
{
public:
    virtual __fastcall TCFbEAdjustedWeightedSumWithMedianOfColumn(void);    // RXgN^
    __fastcall ~TCFbEAdjustedWeightedSumWithMedianOfColumn();    // fXgN^

    // vZɕKvȃLbV
    virtual void __fastcall PrepareCache(TCFbECustomTableEx* PredictionTable) {
        PredictionTable->AddChildCache(new TCFbEColumnCachedTable(PredictionTable), "Median.column", true);
    }

protected:
    bool    CashEnabled;
    double    MedianOfColumn;

    virtual void __fastcall ClearCash(void);    // LbVNA
    virtual double __fastcall GetNumerator(int NeighborIndex);    // q̒l𓾂
    virtual double __fastcall GetPredictedValue(double Numerator, double Denominator);    // \l𓾂

private:

};
//---------------------------------------------------------------------------
#endif
