/*
    TCFbEDataSetEx.h    June 6, 2004.

    Copyright (C) 2003-2004 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#ifndef TCFbEDataSetExH
#define TCFbEDataSetExH
//---------------------------------------------------------------------------
// #include "Maprof.h"

#include "math.h"
#include "TCFbEToolkit.h"
#include "TCFbETypes.h"

#include "TCFbECustomTableEx.h"

#include "TCFbETableEx.h"
#include "TCFbERotatedTableEx.h"
#include "TCFbECell.h"
#include "TCFbENeighbor.h"

#include "TCFbESimilarityComputationAlgorithm.h"
#include "TCFbEPredictionAlgorithm.h"
//---------------------------------------------------------------------------
// Facade IȃNX
class TCFbEDataSetEx : public TCFbETableEx
{
public:
    // ANZT
    virtual TCFbECustomTableEx* __fastcall GetPredictionTable(void) {
        return this->PredictionTable;
    }

    virtual TCFbECustomTableEx* __fastcall GetSimilarityComputationTable(void) {
        return this->SimilarityComputationTable;
    }

    virtual void __fastcall SetValueByIndex(int TargetRowIndex, int TargetColumnIndex, double Value) {
        TCFbETableEx::SetValueByIndex(TargetRowIndex, TargetColumnIndex, Value);
        this->RePrepareCF(TargetRowIndex, TargetColumnIndex);
    }

    virtual void __fastcall UnableElementByIndex(int TargetRowIndex, int TargetColumnIndex) {
        TCFbETableEx::UnableElementByIndex(TargetRowIndex, TargetColumnIndex);
        this->RePrepareCF(TargetRowIndex, TargetColumnIndex);
    }

    virtual bool IsPrepared(void) { // CF ̏łĂ trueCłĂȂ false
        return this->FIsPrepared;
    }

    virtual double __fastcall GetSimilarity(const char* TargetRowLabel, const char* ComparedRowLabel) {
        return this->GetSimilarityByIndex(this->GetRowLabelList()->IndexOf(TargetRowLabel), this->GetRowLabelList()->IndexOf(ComparedRowLabel));
    }

    virtual double __fastcall GetPredictedValue(const char* TargetRowLabel, const char* TargetColumnLabel) {
        return this->GetPredictedValueByIndex(this->GetRowLabelList()->IndexOf(TargetRowLabel), this->GetColumnLabelList()->IndexOf(TargetColumnLabel));
    }

    virtual double __fastcall GetSimilarityByIndex(int TargetRowIndex, int ComparedRowIndex);
    virtual double __fastcall GetPredictedValueByIndex(int TargetRowIndex, int TargetColumnIndex);

    virtual TCFbESimilarityComputationAlgorithm*    GetSimilarityComputationAlgorithm(void) { return this->FSimilarityComputationAlgorithm; }
    virtual TCFbEPredictionAlgorithm*               GetPredictionAlgorithm(void) { return this->FPredictionAlgorithm; }
    
    virtual __fastcall TCFbEDataSetEx(void);   // RXgN^
    virtual __fastcall TCFbEDataSetEx(TStringList* SourceCsvStringList); // RXgN^
    __fastcall ~TCFbEDataSetEx();    // fXgN^

    virtual void __fastcall InitCache(void);    // LbV

    virtual void    __fastcall PrepareCF(TCFbEValueBase ValueBase, TCFbEAlgorithmBase AlgorithmBase, TCFbESimilarityComputationAlgorithm* SimilarityComputationAlgorithm, TCFbEPredictionAlgorithm* PredictionAlgorithm, int NeighborhoodSize, bool DefaultValueEnabled, double DefaultValue, bool InverseCaseFrequencyEnabled, double CaseAmplifier);    // CF ̏siPredictionTable 

    virtual void __fastcall GetNearestNeighbors(int TargetRowIndex, int TargetColumnIndex, int NeighborhoodSize, TObjectList* NeighborList);    // TargetRowIndex ɑ΂ NearestNeigobors 𒲂ׂ

    virtual void    __fastcall FillColumns(TCFbEDataSetEx* BaseDataSet);    // BaseDataSet ɂāCthis ɂȂVȗƂĒǉ
    virtual bool    __fastcall IsConsistentWith(TCFbEDataSetEx* TargetDataSet);    // TargetDataSet Ǝѐ邩ǂ𒲂ׂ

    virtual double  __fastcall DisOrderingEx(double Order, int ColumnIndex);  // ColumnIndex ڂ Ordering ꂽl Order  DisOrdering ĕԂ

    virtual void    __fastcall TemporallyUnable(int TargetRowIndex, int TargetColumnIndex); // TargetRowIndex, TargetColumnIndex ̃ZꎞI Enabled = false ɂ
    virtual void    __fastcall RecoverEnabled(void);    // ꎞI Enabled = false ɂĂZɂǂ

protected:
    virtual void __fastcall RePrepareCF(int TargetRowIndex, int TargetColumnIndex);
    virtual void __fastcall CellIsUpdatedByIndex(int RowIndex, int ColumnIndex) {
        if (this->IsPrepared()) {
            TCFbETableEx::CellIsUpdatedByIndex(RowIndex, ColumnIndex);
        }
    }

    TCFbEValueBase      FValueBase;
    TCFbEAlgorithmBase  FAlgorithmBase;
    TCFbESimilarityComputationAlgorithm*    FSimilarityComputationAlgorithm;
    TCFbEPredictionAlgorithm*               FPredictionAlgorithm;
    int     FNeighborhoodSize;
    bool    FDefaultValueEnabled;
    double  FDefaultValue;
    bool    FInverseCaseFrequencyEnabled;
    double  FCaseAmplifier;
    bool    FIsPrepared;

    int     TemporallyUnableRowIndex;
    int     TemporallyUnableColumnIndex;
    double  TemporallyUnableValue;

    TCFbETableEx* NormalizedTable;
    TCFbECustomTableEx* SimilarityComputationTable;
    TCFbECustomTableEx* PredictionTable;
    TCFbERowRowCachedTable* SimilarityCache;
    TCFbECustomTableEx* PredictedValueCache;

private:

};
//---------------------------------------------------------------------------
#endif
