/*
    TCFbETestCase0.cpp    June 6, 2004.

    Copyright (C) 2003-2004 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#ifndef TCFbETestCase0H
#define TCFbETestCase0H
//---------------------------------------------------------------------------
#pragma hdrstop
//---------------------------------------------------------------------------
#include <cppunit/TestCase.h>
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestRunner.h>

USING_NAMESPACE_CPPUNIT
//---------------------------------------------------------------------------
#include <System.hpp>

#include "TCFbERowCachedTable.h"
#include "TCFbEColumnCachedTable.h"

#include "TCFbETableEx.h"
#include "TCFbEDataSetEx.h"
#include "TCFbECommandLineParser.h"
#include "TCFbEOutputCash.h"
#include "TCFbEOutputFormatter.h"
#include "TCFbECsvOutputFormatter.h"
#include "TCFbERecommendationOutputFormatter.h"
#include "TCFbEDataLoader.h"
//---------------------------------------------------------------------------
// eXgP[X1
class TCFbETestCase0 : public TestCase
{
    // RXgN^
    TEST_CASE_COMMON(TCFbETestCase0)

public:
    TCFbETableEx*    Table;
    TCFbEDataSetEx*    LearningData;
    TCFbEDataSetEx*    EstimatingData;

    // eXg
    /*
                column_0    column_1    column_2    column_3    column_4
        row_0    1                        4            100
        row_1    2                        10            1
        row_2    -5            2            3            4            5
        row_3                            3
    */
    virtual void setUp() {
        this->Table = new TCFbETableEx();
        Table->AddColumn("column_0");
        Table->AddColumn("column_1");
        Table->AddColumn("column_2");
        Table->AddColumn("column_3");
        Table->AddColumn("column_4");
        Table->AddRow("row_0");
        Table->AddRow("row_1");
        Table->AddRow("row_2");
        Table->AddRow("row_3");
        Table->SetValue("row_0", "column_0", 1.0);
        Table->SetValue("row_0", "column_2", 4.0);
        Table->SetValue("row_0", "column_3", 100.0);
        Table->SetValue("row_1", "column_0", 2.0);
        Table->SetValue("row_1", "column_2", 10.0);
        Table->SetValue("row_1", "column_3", 1.0);
        Table->SetValue("row_2", "column_0", -5.0);
        Table->SetValue("row_2", "column_1", 2.0);
        Table->SetValue("row_2", "column_2", 3.0);
        Table->SetValue("row_2", "column_3", 4.0);
        Table->SetValue("row_2", "column_4", 5.0);
        Table->SetValue("row_3", "column_2", 3.0);

        TStringList* TestStringList = new TStringList();
        TestStringList->Add("FILENAME,    BUG,    LOC,    N_COMM,    HALVOL,    SCPMN,    N_VEXUSE");
        TestStringList->Add("module_2,    0,        250,    0.2,    3200,    3.5,    0.4");
        TestStringList->Add("module_3,    0,        500,    0,        3200,    3,        0.3");
        TestStringList->Add("module_4,    1,        700,    0.25,    3500,    4,        0.8");
        TestStringList->Add("module_5,    0,        600,    0.2,    3200,    2.5,    0.1");
        TestStringList->Add("module_6,    1,        900,    0.35,    3800,    4.1,    0.75");

        this->LearningData = new TCFbEDataSetEx(TestStringList);

        TestStringList->Clear();
        TestStringList->Add("FILENAME,    BUG,    LOC,    N_COMM,    HALVOL,    SCPMN,    N_VEXUSE");
        TestStringList->Add("module_1,    1,        800,    0.3,    3600,    4,        0.6");

        this->EstimatingData = new TCFbEDataSetEx(TestStringList);
        delete TestStringList;
    }

    // eXǧЕt
    virtual void tearDown() {
        delete this->EstimatingData;
        delete this->LearningData;
        delete this->Table;
    }

    //---------------------------------------------------------------------------
    // ȉCTCFbEDataLoader ̃eXg
    //---------------------------------------------------------------------------
    //    test\\Test_TCFbEDataLoader000_learn.csv
    //---------------------------------------------------------------------------
    //    FILENAME    BUG    LOC    N_COMM    HALVOL    SCPMN    N_VEXUSE    REV
    //    module_2    0    250    0.2        3200    3.5        0.4
    //    module_3    0        0                3        0.3            5
    //    module_4    1    700    0.25    3500    4        0.8            11
    //    module_5    0        0.2                2.5        0.1            20
    //    module_6    1    900    0.35    3800    4.1        0.75
    //---------------------------------------------------------------------------
    //    test\\Test_TCFbEDataLoader000_apply.csv
    //---------------------------------------------------------------------------
    //    FILENAME    SCPMN    LOC    BUG    N_COMM    HALVOL    N_VEXUSE    REV
    //    module_1    4        800    1    0.3                0.6            12
    //---------------------------------------------------------------------------
    virtual void Test_TCFbEDataLoader() {
        char* argv[] = { "docfbe_test"
            , "-n=normalize"
            , "-ns=5"
            , "-t=BUG"
            , "-dd"
            , "-dn"
            , "-ds"
            , "-dv"
            , "-l=test\\Test_TCFbEDataLoader000_learn.csv"
            , "-e=test\\Test_TCFbEDataLoader000_apply.csv"
            , "-s=AdjustedCosineSimilarityWithAverage"
            , "-p=AmplifiedWeightedSumWithMedianOfMultiplier"
        };

        TCFbECommandLineParser*    Parser = new TCFbECommandLineParser(12, argv);
        TCFbEDataLoader*    Loader = new TCFbEDataLoader(Parser);

        TEST_ASSERT_EQUALS(5,    Loader->LearningData->GetNumberOfRows());
        TEST_ASSERT_EQUALS(7,    Loader->LearningData->GetNumberOfColumns());

        TEST_ASSERT_EQUALS("BUG",    Loader->LearningData->GetColumnLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("LOC",    Loader->LearningData->GetColumnLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("N_COMM",    Loader->LearningData->GetColumnLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("HALVOL",    Loader->LearningData->GetColumnLabelList()->Strings[3].c_str());
        TEST_ASSERT_EQUALS("SCPMN",    Loader->LearningData->GetColumnLabelList()->Strings[4].c_str());
        TEST_ASSERT_EQUALS("N_VEXUSE",    Loader->LearningData->GetColumnLabelList()->Strings[5].c_str());
        TEST_ASSERT_EQUALS("REV",    Loader->LearningData->GetColumnLabelList()->Strings[6].c_str());

        TEST_ASSERT_EQUALS("module_2",    Loader->LearningData->GetRowLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("module_3",    Loader->LearningData->GetRowLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("module_4",    Loader->LearningData->GetRowLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("module_5",    Loader->LearningData->GetRowLabelList()->Strings[3].c_str());
        TEST_ASSERT_EQUALS("module_6",    Loader->LearningData->GetRowLabelList()->Strings[4].c_str());

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(0, 0));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(0, 1));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(0, 2));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(0, 3));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(0, 4));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(0, 5));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(0, 6));

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(1, 0));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(1, 1));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(1, 2));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(1, 3));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(1, 4));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(1, 5));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(1, 6));

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(2, 0));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(2, 1));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(2, 2));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(2, 3));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(2, 4));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(2, 5));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(2, 6));

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(3, 0));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(3, 1));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(3, 2));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(3, 3));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(3, 4));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(3, 5));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(3, 6));

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(4, 0));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(4, 1));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(4, 2));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(4, 3));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(4, 4));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(4, 5));
        TEST_ASSERT_EQUALS((int)false,   Loader->LearningData->GetEnabledByIndex(4, 6));

        TEST_ASSERT_EQUALS_DOUBLE(0.0,   Loader->LearningData->GetValueByIndex(0, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(250.0, Loader->LearningData->GetValueByIndex(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2,   Loader->LearningData->GetValueByIndex(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3200.0,Loader->LearningData->GetValueByIndex(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5,   Loader->LearningData->GetValueByIndex(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4,   Loader->LearningData->GetValueByIndex(0, 5), 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(0.0,    Loader->LearningData->GetValueByIndex(1, 0), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0,    Loader->LearningData->GetValueByIndex(1, 2), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(3.0,    Loader->LearningData->GetValueByIndex(1, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3,    Loader->LearningData->GetValueByIndex(1, 5), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.0,    Loader->LearningData->GetValueByIndex(1, 6), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1.0,    Loader->LearningData->GetValueByIndex(2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(700.0,    Loader->LearningData->GetValueByIndex(2, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.25,    Loader->LearningData->GetValueByIndex(2, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3500.0,    Loader->LearningData->GetValueByIndex(2, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0,    Loader->LearningData->GetValueByIndex(2, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8,    Loader->LearningData->GetValueByIndex(2, 5), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(11.0,    Loader->LearningData->GetValueByIndex(2, 6), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0,    Loader->LearningData->GetValueByIndex(3, 0), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.2,    Loader->LearningData->GetValueByIndex(3, 2), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(2.5,    Loader->LearningData->GetValueByIndex(3, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1,    Loader->LearningData->GetValueByIndex(3, 5), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(20.0,    Loader->LearningData->GetValueByIndex(3, 6), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1.0,    Loader->LearningData->GetValueByIndex(4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(900.0,    Loader->LearningData->GetValueByIndex(4, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.35,    Loader->LearningData->GetValueByIndex(4, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3800.0,    Loader->LearningData->GetValueByIndex(4, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.1,    Loader->LearningData->GetValueByIndex(4, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.75,    Loader->LearningData->GetValueByIndex(4, 5), 1E-6);


        TEST_ASSERT_EQUALS(1,    Loader->EstimatingData->GetNumberOfRows());
        TEST_ASSERT_EQUALS(7,    Loader->EstimatingData->GetNumberOfColumns());

        TEST_ASSERT_EQUALS("SCPMN",    Loader->EstimatingData->GetColumnLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("LOC",    Loader->EstimatingData->GetColumnLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("BUG",    Loader->EstimatingData->GetColumnLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("N_COMM",    Loader->EstimatingData->GetColumnLabelList()->Strings[3].c_str());
        TEST_ASSERT_EQUALS("HALVOL",    Loader->EstimatingData->GetColumnLabelList()->Strings[4].c_str());
        TEST_ASSERT_EQUALS("N_VEXUSE",    Loader->EstimatingData->GetColumnLabelList()->Strings[5].c_str());
        TEST_ASSERT_EQUALS("REV",    Loader->EstimatingData->GetColumnLabelList()->Strings[6].c_str());

        TEST_ASSERT_EQUALS("module_1",    Loader->EstimatingData->GetRowLabelList()->Strings[0].c_str());

        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->GetEnabledByIndex(0, 0));
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->GetEnabledByIndex(0, 1));
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->GetEnabledByIndex(0, 2));
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->GetEnabledByIndex(0, 3));
        TEST_ASSERT_EQUALS((int)false,    Loader->EstimatingData->GetEnabledByIndex(0, 4));
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->GetEnabledByIndex(0, 5));
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->GetEnabledByIndex(0, 6));

        TEST_ASSERT_EQUALS_DOUBLE(4.0,    Loader->EstimatingData->GetValueByIndex(0, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(800.0,    Loader->EstimatingData->GetValueByIndex(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0,    Loader->EstimatingData->GetValueByIndex(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3,    Loader->EstimatingData->GetValueByIndex(0, 3), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.6,    Loader->EstimatingData->GetValueByIndex(0, 5), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(12.0,    Loader->EstimatingData->GetValueByIndex(0, 6), 1E-6);

        delete Loader;
        delete Parser;
    }

    virtual void Test_TCFbEDataLoader_AdoptData_tmbLearningData() {
        char* argv[] = { "docfbe_test"
            , "-n=normalize"
            , "-ns=5"
            , "-t=BUG"
            , "-m=learning"
            , "-l=test\\Test_TCFbEDataLoader001_learn.csv"
            , "-e=test\\Test_TCFbEDataLoader001_apply.csv"
            , "-s=AdjustedCosineSimilarityWithAverage"
            , "-p=AmplifiedWeightedSumWithMedianOfMultiplier"
        };

        TCFbECommandLineParser*    Parser = new TCFbECommandLineParser(9, argv);
        TCFbEDataLoader*    Loader = new TCFbEDataLoader(Parser);

        //    FILENAME    BUG        LOC        N_COMM        HALVOL
        //    module_2    0        250        0.2            3200
        //    module_3    0                0
        //    module_4    1        700        0.25        3500
        //    module_5    0                0.2
        //    module_6    1        900        0.35        3800
        TEST_ASSERT_EQUALS(5,    Loader->LearningData->GetNumberOfRows());
        TEST_ASSERT_EQUALS(4,    Loader->LearningData->GetNumberOfColumns());

        TEST_ASSERT_EQUALS("BUG",    Loader->LearningData->GetColumnLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("LOC",    Loader->LearningData->GetColumnLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("N_COMM",    Loader->LearningData->GetColumnLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("HALVOL",    Loader->LearningData->GetColumnLabelList()->Strings[3].c_str());

        TEST_ASSERT_EQUALS("module_2",    Loader->LearningData->GetRowLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("module_3",    Loader->LearningData->GetRowLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("module_4",    Loader->LearningData->GetRowLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("module_5",    Loader->LearningData->GetRowLabelList()->Strings[3].c_str());
        TEST_ASSERT_EQUALS("module_6",    Loader->LearningData->GetRowLabelList()->Strings[4].c_str());

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(0, 0));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(0, 1));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(0, 2));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(0, 3));

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(1, 0));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(1, 1));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(1, 2));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(1, 3));

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(2, 0));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(2, 1));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(2, 2));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(2, 3));

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(3, 0));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(3, 1));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(3, 2));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(3, 3));

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(4, 0));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(4, 1));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(4, 2));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(4, 3));

        TEST_ASSERT_EQUALS_DOUBLE(0.0,    Loader->LearningData->GetValueByIndex(0, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(250.0,    Loader->LearningData->GetValueByIndex(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2,    Loader->LearningData->GetValueByIndex(0, 2), 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(0.0,    Loader->LearningData->GetValueByIndex(1, 0), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0,    Loader->LearningData->GetValueByIndex(1, 2), 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(1.0,    Loader->LearningData->GetValueByIndex(2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(700.0,    Loader->LearningData->GetValueByIndex(2, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.25,    Loader->LearningData->GetValueByIndex(2, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3500.0,    Loader->LearningData->GetValueByIndex(2, 3), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0,    Loader->LearningData->GetValueByIndex(3, 0), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.2,    Loader->LearningData->GetValueByIndex(3, 2), 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(1.0,    Loader->LearningData->GetValueByIndex(4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(900.0,    Loader->LearningData->GetValueByIndex(4, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.35,    Loader->LearningData->GetValueByIndex(4, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3800.0,    Loader->LearningData->GetValueByIndex(4, 3), 1E-6);


        //    FILENAME    BUG        LOC        N_COMM        HALVOL
        //    module_1                    0.3
        TEST_ASSERT_EQUALS(1,    Loader->EstimatingData->GetNumberOfRows());
        TEST_ASSERT_EQUALS(4,    Loader->EstimatingData->GetNumberOfColumns());

        TEST_ASSERT_EQUALS("BUG",        Loader->EstimatingData->GetColumnLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("LOC",        Loader->EstimatingData->GetColumnLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("N_COMM",    Loader->EstimatingData->GetColumnLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("HALVOL",    Loader->EstimatingData->GetColumnLabelList()->Strings[3].c_str());

        TEST_ASSERT_EQUALS("module_1",    Loader->EstimatingData->GetRowLabelList()->Strings[0].c_str());

        TEST_ASSERT_EQUALS((int)false,    Loader->EstimatingData->GetEnabledByIndex(0, 0));
        TEST_ASSERT_EQUALS((int)false,    Loader->EstimatingData->GetEnabledByIndex(0, 1));
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->GetEnabledByIndex(0, 2));
        TEST_ASSERT_EQUALS((int)false,    Loader->EstimatingData->GetEnabledByIndex(0, 3));


        TEST_ASSERT_EQUALS_DOUBLE(0.3,    Loader->EstimatingData->GetValueByIndex(0, 2), 1E-6);

        delete Loader;
        delete Parser;
    }

    virtual void Test_TCFbEDataLoader_AdoptData_tmbEstimatingData() {
        char* argv[] = { "docfbe_test"
            , "-n=normalize"
            , "-ns=5"
            , "-t=BUG"
            , "-m=estimating"
            , "-l=test\\Test_TCFbEDataLoader001_learn.csv"
            , "-e=test\\Test_TCFbEDataLoader001_apply.csv"
            , "-s=AdjustedCosineSimilarityWithAverage"
            , "-p=AmplifiedWeightedSumWithMedianOfMultiplier"
        };

        TCFbECommandLineParser*    Parser = new TCFbECommandLineParser(9, argv);
        TCFbEDataLoader*    Loader = new TCFbEDataLoader(Parser);

        //    FILENAME    N_COMM    HALVOL    SCPMN    N_VEXUSE    REV
        //    module_2    0.2        3200
        //    module_3    0
        //    module_4    0.25    3500
        //    module_5    0.2
        //    module_6    0.35    3800
        TEST_ASSERT_EQUALS(5,    Loader->LearningData->GetNumberOfRows());
        TEST_ASSERT_EQUALS(5,    Loader->LearningData->GetNumberOfColumns());

        TEST_ASSERT_EQUALS("N_COMM",    Loader->LearningData->GetColumnLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("HALVOL",    Loader->LearningData->GetColumnLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("SCPMN",        Loader->LearningData->GetColumnLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("N_VEXUSE",    Loader->LearningData->GetColumnLabelList()->Strings[3].c_str());
        TEST_ASSERT_EQUALS("REV",        Loader->LearningData->GetColumnLabelList()->Strings[4].c_str());

        TEST_ASSERT_EQUALS("module_2",    Loader->LearningData->GetRowLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("module_3",    Loader->LearningData->GetRowLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("module_4",    Loader->LearningData->GetRowLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("module_5",    Loader->LearningData->GetRowLabelList()->Strings[3].c_str());
        TEST_ASSERT_EQUALS("module_6",    Loader->LearningData->GetRowLabelList()->Strings[4].c_str());

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(0, 0));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(0, 1));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(0, 2));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(0, 3));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(0, 4));

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(1, 0));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(1, 1));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(0, 2));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(0, 3));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(0, 4));

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(2, 0));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(2, 1));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(0, 2));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(0, 3));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(0, 4));

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(3, 0));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(3, 1));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(0, 2));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(0, 3));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(0, 4));

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(4, 0));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(4, 1));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(0, 2));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(0, 3));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(0, 4));

        TEST_ASSERT_EQUALS_DOUBLE(0.2,    Loader->LearningData->GetValueByIndex(0, 0), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0,    Loader->LearningData->GetValueByIndex(1, 0), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.25,    Loader->LearningData->GetValueByIndex(2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3500.0,    Loader->LearningData->GetValueByIndex(2, 1), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.2,    Loader->LearningData->GetValueByIndex(3, 0), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.35,    Loader->LearningData->GetValueByIndex(4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3800.0,    Loader->LearningData->GetValueByIndex(4, 1), 1E-6);


        //    FILENAME    N_COMM    HALVOL    SCPMN    N_VEXUSE    REV
        //    module_1    0.3                4        0.6            12
        TEST_ASSERT_EQUALS(1,    Loader->EstimatingData->GetNumberOfRows());
        TEST_ASSERT_EQUALS(5,    Loader->EstimatingData->GetNumberOfColumns());

        TEST_ASSERT_EQUALS("N_COMM",    Loader->EstimatingData->GetColumnLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("HALVOL",    Loader->EstimatingData->GetColumnLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("SCPMN",        Loader->EstimatingData->GetColumnLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("N_VEXUSE",    Loader->EstimatingData->GetColumnLabelList()->Strings[3].c_str());
        TEST_ASSERT_EQUALS("REV",        Loader->EstimatingData->GetColumnLabelList()->Strings[4].c_str());

        TEST_ASSERT_EQUALS("module_1",    Loader->EstimatingData->GetRowLabelList()->Strings[0].c_str());

        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->GetEnabledByIndex(0, 0));
        TEST_ASSERT_EQUALS((int)false,    Loader->EstimatingData->GetEnabledByIndex(0, 1));
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->GetEnabledByIndex(0, 2));
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->GetEnabledByIndex(0, 3));
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->GetEnabledByIndex(0, 4));


        TEST_ASSERT_EQUALS_DOUBLE(0.3,    Loader->EstimatingData->GetValueByIndex(0, 0), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(4.0,    Loader->EstimatingData->GetValueByIndex(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6,    Loader->EstimatingData->GetValueByIndex(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(12.0,    Loader->EstimatingData->GetValueByIndex(0, 4), 1E-6);

        delete Loader;
        delete Parser;
    }

    virtual void Test_TCFbEDataLoader_AdoptData_tmbBoth() {
        char* argv[] = { "docfbe_test"
            , "-n=normalize"
            , "-ns=5"
            , "-t=BUG"
            , "-m=both"
            , "-l=test\\Test_TCFbEDataLoader001_learn.csv"
            , "-e=test\\Test_TCFbEDataLoader001_apply.csv"
            , "-s=AdjustedCosineSimilarityWithAverage"
            , "-p=AmplifiedWeightedSumWithMedianOfMultiplier"
        };

        TCFbECommandLineParser*    Parser = new TCFbECommandLineParser(9, argv);
        TCFbEDataLoader*    Loader = new TCFbEDataLoader(Parser);

        //    FILENAME    BUG        LOC        N_COMM        HALVOL    SCPMN    N_VEXUSE    REV
        //    module_2    0        250        0.2            3200
        //    module_3    0                0
        //    module_4    1        700        0.25        3500
        //    module_5    0                0.2
        //    module_6    1        900        0.35        3800
        TEST_ASSERT_EQUALS(5,    Loader->LearningData->GetNumberOfRows());
        TEST_ASSERT_EQUALS(7,    Loader->LearningData->GetNumberOfColumns());

        TEST_ASSERT_EQUALS("BUG",        Loader->LearningData->GetColumnLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("LOC",        Loader->LearningData->GetColumnLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("N_COMM",    Loader->LearningData->GetColumnLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("HALVOL",    Loader->LearningData->GetColumnLabelList()->Strings[3].c_str());
        TEST_ASSERT_EQUALS("SCPMN",        Loader->LearningData->GetColumnLabelList()->Strings[4].c_str());
        TEST_ASSERT_EQUALS("N_VEXUSE",    Loader->LearningData->GetColumnLabelList()->Strings[5].c_str());
        TEST_ASSERT_EQUALS("REV",        Loader->LearningData->GetColumnLabelList()->Strings[6].c_str());

        TEST_ASSERT_EQUALS("module_2",    Loader->LearningData->GetRowLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("module_3",    Loader->LearningData->GetRowLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("module_4",    Loader->LearningData->GetRowLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("module_5",    Loader->LearningData->GetRowLabelList()->Strings[3].c_str());
        TEST_ASSERT_EQUALS("module_6",    Loader->LearningData->GetRowLabelList()->Strings[4].c_str());

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(0, 0));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(0, 1));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(0, 2));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(0, 3));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(0, 4));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(0, 5));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(0, 6));

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(1, 0));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(1, 1));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(1, 2));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(1, 3));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(1, 4));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(1, 5));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(1, 6));

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(2, 0));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(2, 1));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(2, 2));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(2, 3));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(2, 4));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(2, 5));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(2, 6));

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(3, 0));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(3, 1));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(3, 2));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(3, 3));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(3, 4));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(3, 5));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(3, 6));

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(4, 0));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(4, 1));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(4, 2));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(4, 3));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(4, 4));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(4, 5));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(4, 6));

        TEST_ASSERT_EQUALS_DOUBLE(0.0,    Loader->LearningData->GetValueByIndex(0, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(250.0,Loader->LearningData->GetValueByIndex(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2,    Loader->LearningData->GetValueByIndex(0, 2), 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(0.0,    Loader->LearningData->GetValueByIndex(1, 0), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0,    Loader->LearningData->GetValueByIndex(1, 2), 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(1.0,    Loader->LearningData->GetValueByIndex(2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(700.0,    Loader->LearningData->GetValueByIndex(2, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.25,    Loader->LearningData->GetValueByIndex(2, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3500.0,    Loader->LearningData->GetValueByIndex(2, 3), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0,    Loader->LearningData->GetValueByIndex(3, 0), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.2,    Loader->LearningData->GetValueByIndex(3, 2), 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(1.0,    Loader->LearningData->GetValueByIndex(4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(900.0,    Loader->LearningData->GetValueByIndex(4, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.35,    Loader->LearningData->GetValueByIndex(4, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3800.0,    Loader->LearningData->GetValueByIndex(4, 3), 1E-6);


        //    FILENAME    N_COMM    HALVOL    SCPMN    N_VEXUSE    REV        BUG        LOC
        //    module_1    0.3                4        0.6            12
        TEST_ASSERT_EQUALS(1,    Loader->EstimatingData->GetNumberOfRows());
        TEST_ASSERT_EQUALS(7,    Loader->EstimatingData->GetNumberOfColumns());

        TEST_ASSERT_EQUALS("N_COMM",    Loader->EstimatingData->GetColumnLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("HALVOL",    Loader->EstimatingData->GetColumnLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("SCPMN",        Loader->EstimatingData->GetColumnLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("N_VEXUSE",    Loader->EstimatingData->GetColumnLabelList()->Strings[3].c_str());
        TEST_ASSERT_EQUALS("REV",        Loader->EstimatingData->GetColumnLabelList()->Strings[4].c_str());
        TEST_ASSERT_EQUALS("BUG",        Loader->EstimatingData->GetColumnLabelList()->Strings[5].c_str());
        TEST_ASSERT_EQUALS("LOC",        Loader->EstimatingData->GetColumnLabelList()->Strings[6].c_str());

        TEST_ASSERT_EQUALS("module_1",    Loader->EstimatingData->GetRowLabelList()->Strings[0].c_str());

        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->GetEnabledByIndex(0, 0));
        TEST_ASSERT_EQUALS((int)false,    Loader->EstimatingData->GetEnabledByIndex(0, 1));
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->GetEnabledByIndex(0, 2));
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->GetEnabledByIndex(0, 3));
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->GetEnabledByIndex(0, 4));
        TEST_ASSERT_EQUALS((int)false,    Loader->EstimatingData->GetEnabledByIndex(0, 5));
        TEST_ASSERT_EQUALS((int)false,    Loader->EstimatingData->GetEnabledByIndex(0, 6));


        TEST_ASSERT_EQUALS_DOUBLE(0.3,    Loader->EstimatingData->GetValueByIndex(0, 0), 1E-6);
                
        TEST_ASSERT_EQUALS_DOUBLE(4.0,    Loader->EstimatingData->GetValueByIndex(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6,    Loader->EstimatingData->GetValueByIndex(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(12.0,    Loader->EstimatingData->GetValueByIndex(0, 4), 1E-6);

        delete Loader;
        delete Parser;
    }


    //            column_0    column_1    column_2    column_3    column_4
    //    row_0    1                        4            100
    //    row_1    2                        10            1
    //    row_2    -5            2            3            4            5
    //    row_3                            3
    virtual void Test_TCFbEDataLoader_Merge() {
        char* argv[] = { "docfbe_test"
            , "-n=normalize"
            , "-ns=5"
            , "-t=BUG"
            , "-m=both"
            , "-l=test\\Test_TCFbEDataLoader_merge000.csv,test\\Test_TCFbEDataLoader_merge001.csv"
            , "-e=test\\Test_TCFbEDataLoader_merge001.csv,test\\Test_TCFbEDataLoader_merge000.csv"
            , "-s=AdjustedCosineSimilarityWithAverage"
            , "-p=AmplifiedWeightedSumWithMedianOfMultiplier"
        };

        TCFbECommandLineParser*    Parser = new TCFbECommandLineParser(9, argv);
        TCFbEDataLoader*    Loader = new TCFbEDataLoader(Parser);

        TEST_ASSERT_EQUALS(4,    Loader->LearningData->GetNumberOfRows());
        TEST_ASSERT_EQUALS(5,    Loader->LearningData->GetNumberOfColumns());

        TEST_ASSERT_EQUALS("column_0",    Loader->LearningData->GetColumnLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("column_1",    Loader->LearningData->GetColumnLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("column_2",    Loader->LearningData->GetColumnLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("column_3",    Loader->LearningData->GetColumnLabelList()->Strings[3].c_str());
        TEST_ASSERT_EQUALS("column_4",    Loader->LearningData->GetColumnLabelList()->Strings[4].c_str());

        TEST_ASSERT_EQUALS("row_0",    Loader->LearningData->GetRowLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("row_1",    Loader->LearningData->GetRowLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("row_2",    Loader->LearningData->GetRowLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("row_3",    Loader->LearningData->GetRowLabelList()->Strings[3].c_str());

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(0, 0));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(0, 1));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(0, 2));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(0, 3));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(0, 4));

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(1, 0));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(1, 1));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(1, 2));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(1, 3));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(1, 4));

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(2, 0));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(2, 1));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(2, 2));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(2, 3));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(2, 4));

        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(3, 0));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(3, 1));
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->GetEnabledByIndex(3, 2));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(3, 3));
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->GetEnabledByIndex(3, 4));

        TEST_ASSERT_EQUALS_DOUBLE(1.0,        Loader->LearningData->GetValueByIndex(0, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0,        Loader->LearningData->GetValueByIndex(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(100.0,    Loader->LearningData->GetValueByIndex(0, 3), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(2.0,        Loader->LearningData->GetValueByIndex(1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(10.0,        Loader->LearningData->GetValueByIndex(1, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0,        Loader->LearningData->GetValueByIndex(1, 3), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(-5.0,        Loader->LearningData->GetValueByIndex(2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.0,        Loader->LearningData->GetValueByIndex(2, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0,        Loader->LearningData->GetValueByIndex(2, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0,        Loader->LearningData->GetValueByIndex(2, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.0,        Loader->LearningData->GetValueByIndex(2, 4), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(3.0,        Loader->LearningData->GetValueByIndex(3, 2), 1E-6);


        TEST_ASSERT_EQUALS(4,    Loader->EstimatingData->GetNumberOfRows());
        TEST_ASSERT_EQUALS(5,    Loader->EstimatingData->GetNumberOfColumns());

        TEST_ASSERT_EQUALS("column_0",    Loader->EstimatingData->GetColumnLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("column_1",    Loader->EstimatingData->GetColumnLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("column_2",    Loader->EstimatingData->GetColumnLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("column_3",    Loader->EstimatingData->GetColumnLabelList()->Strings[3].c_str());
        TEST_ASSERT_EQUALS("column_4",    Loader->EstimatingData->GetColumnLabelList()->Strings[4].c_str());

        TEST_ASSERT_EQUALS("row_0",    Loader->EstimatingData->GetRowLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("row_1",    Loader->EstimatingData->GetRowLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("row_2",    Loader->EstimatingData->GetRowLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("row_3",    Loader->EstimatingData->GetRowLabelList()->Strings[3].c_str());

        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->GetEnabledByIndex(0, 0));
        TEST_ASSERT_EQUALS((int)false,    Loader->EstimatingData->GetEnabledByIndex(0, 1));
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->GetEnabledByIndex(0, 2));
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->GetEnabledByIndex(0, 3));
        TEST_ASSERT_EQUALS((int)false,    Loader->EstimatingData->GetEnabledByIndex(0, 4));

        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->GetEnabledByIndex(1, 0));
        TEST_ASSERT_EQUALS((int)false,    Loader->EstimatingData->GetEnabledByIndex(1, 1));
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->GetEnabledByIndex(1, 2));
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->GetEnabledByIndex(1, 3));
        TEST_ASSERT_EQUALS((int)false,    Loader->EstimatingData->GetEnabledByIndex(1, 4));

        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->GetEnabledByIndex(2, 0));
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->GetEnabledByIndex(2, 1));
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->GetEnabledByIndex(2, 2));
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->GetEnabledByIndex(2, 3));
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->GetEnabledByIndex(2, 4));

        TEST_ASSERT_EQUALS((int)false,    Loader->EstimatingData->GetEnabledByIndex(3, 0));
        TEST_ASSERT_EQUALS((int)false,    Loader->EstimatingData->GetEnabledByIndex(3, 1));
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->GetEnabledByIndex(3, 2));
        TEST_ASSERT_EQUALS((int)false,    Loader->EstimatingData->GetEnabledByIndex(3, 3));
        TEST_ASSERT_EQUALS((int)false,    Loader->EstimatingData->GetEnabledByIndex(3, 4));

        TEST_ASSERT_EQUALS_DOUBLE(1.0,        Loader->EstimatingData->GetValueByIndex(0, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0,        Loader->EstimatingData->GetValueByIndex(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(100.0,    Loader->EstimatingData->GetValueByIndex(0, 3), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(2.0,        Loader->EstimatingData->GetValueByIndex(1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(10.0,        Loader->EstimatingData->GetValueByIndex(1, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0,        Loader->EstimatingData->GetValueByIndex(1, 3), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(-5.0,        Loader->EstimatingData->GetValueByIndex(2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.0,        Loader->EstimatingData->GetValueByIndex(2, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0,        Loader->EstimatingData->GetValueByIndex(2, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0,        Loader->EstimatingData->GetValueByIndex(2, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.0,        Loader->EstimatingData->GetValueByIndex(2, 4), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(3.0,        Loader->EstimatingData->GetValueByIndex(3, 2), 1E-6);

        delete Loader;
        delete Parser;
    }

    virtual void Test_TCFbEOutputCash_Jacknifing1() {
        char* argv[] = { "docfbe_test"
            , "-n=normalize"
            , "-ns=0"
            , "-t=BUG"
            , "-l=test\\Test_TCFbEOutputCash_Jacknifing1.csv"
            , "-e=test\\Test_TCFbEOutputCash_Jacknifing1.csv"
            , "-s=AdjustedCosineSimilarityWithAverage"
            , "-p=AmplifiedWeightedSumWithMedianOfMultiplier"
        };

        TCFbECommandLineParser* Parser = new TCFbECommandLineParser(8, argv);
        TCFbEDataLoader*    DataLoader = new TCFbEDataLoader(Parser);
        TCFbEOutputCash*    Cash = new TCFbEOutputCash(Parser, DataLoader);

        TEST_ASSERT_EQUALS((int)true,    (int)Cash->GetResultEnabled(0, 0));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 1));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 2));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 3));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 4));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 5));

        TEST_ASSERT_EQUALS("module_6",  Cash->GetNeighbor(0, 0)->GetLabel().c_str());
        TEST_ASSERT_EQUALS("module_4",  Cash->GetNeighbor(0, 1)->GetLabel().c_str());
        TEST_ASSERT_EQUALS("module_5",  Cash->GetNeighbor(0, 2)->GetLabel().c_str());
        TEST_ASSERT_EQUALS("module_2",  Cash->GetNeighbor(0, 3)->GetLabel().c_str());
        TEST_ASSERT_EQUALS("module_3",  Cash->GetNeighbor(0, 4)->GetLabel().c_str());

        TEST_ASSERT_EQUALS_DOUBLE(0.952721939,  Cash->GetNeighbor(0, 0)->GetSimilarity(), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.868253765,   Cash->GetNeighbor(0, 1)->GetSimilarity(), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.821182611, Cash->GetNeighbor(0, 2)->GetSimilarity(), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.838714428, Cash->GetNeighbor(0, 3)->GetSimilarity(), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.921658759,  Cash->GetNeighbor(0, 4)->GetSimilarity(), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1.0,    Cash->GetNeighbor(0, 0)->GetValue(), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0,    Cash->GetNeighbor(0, 1)->GetValue(), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0,    Cash->GetNeighbor(0, 2)->GetValue(), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0,    Cash->GetNeighbor(0, 3)->GetValue(), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0,    Cash->GetNeighbor(0, 4)->GetValue(), 1E-6);

        TEST_ASSERT_EQUALS(1,    Cash->GetDistribution(0, 0));
        TEST_ASSERT_EQUALS(2,    Cash->GetDistribution(0, 1));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 2));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 3));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 4));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 5));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 6));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 7));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 8));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 9));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 10));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 11));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 12));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 13));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 14));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 15));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 16));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 17));
        TEST_ASSERT_EQUALS(1,    Cash->GetDistribution(0, 18));
        TEST_ASSERT_EQUALS(1,    Cash->GetDistribution(0, 19));

        TEST_ASSERT_EQUALS_DOUBLE(0.420284215,    Cash->GetResultValue(0, 0), 1E-6);

        delete Cash;
        delete DataLoader;
        delete Parser;
    }

    //---------------------------------------------------------------------------
    // ȉCTCFbEDataSetEx ̃eXg
    //---------------------------------------------------------------------------
    virtual void Test_TCFbEDataSetEx() {
        TStringList*    TestStringList0 = new TStringList();
        TestStringList0->Add("FILENAME,BUG,EFFORT,AGE");
        TestStringList0->Add("FILE1,10,,9");
        TestStringList0->Add("FILE2,,8,43");
        TestStringList0->Add("FILE3,100,,1000");

        TStringList*    TestStringList1 = new TStringList();
        TestStringList1->Add("FILENAME,EFFORT,AGE, BUG");
        TestStringList1->Add("FILE4,,,100");
        TestStringList1->Add("FILE5,,3,10000");
        TestStringList1->Add("FILE6,78,,");

        TStringList*    TestStringList2 = new TStringList();
        TestStringList2->Add("EFFORT,FILENAME,AGE, BUG");
        TestStringList2->Add("4,FILE4,,5");
        TestStringList2->Add("10,FILE5,3,0.2");
        TestStringList2->Add("8,FILE6,,");


        TCFbEDataSetEx*    DataSet0 = new TCFbEDataSetEx(TestStringList0);
        TCFbEDataSetEx*    DataSet1 = new TCFbEDataSetEx(TestStringList0);
        TCFbEDataSetEx*    DataSet2 = new TCFbEDataSetEx(TestStringList1);
        TCFbEDataSetEx*    DataSet3 = new TCFbEDataSetEx(TestStringList2);

        TEST_ASSERT_EQUALS((int)true, DataSet0->IsConsistentWith(DataSet0));
        TEST_ASSERT_EQUALS((int)true, DataSet0->IsConsistentWith(DataSet1));
        TEST_ASSERT_EQUALS((int)true, DataSet0->IsConsistentWith(DataSet2));
        TEST_ASSERT_EQUALS((int)true, DataSet0->IsConsistentWith(DataSet2));

        delete DataSet3;
        delete DataSet2;
        delete DataSet1;
        delete DataSet0;
        delete TestStringList2;
        delete TestStringList1;
        delete TestStringList0;
    }

    //---------------------------------------------------------------------------
    // ȉCTCFbECommandLineParser ̃eXg
    //---------------------------------------------------------------------------
    virtual void Test_TCFbECommandLineParser() {
        char* argv0[] = { "docfbe_test"
            , "-l=test\\module1_learn.csv"
            , "-e=test\\module1_apply.csv"
            , "-s=CosineSimilarity"
            , "-p=WeightedSum"
        };

        TCFbECommandLineParser* Parser = new TCFbECommandLineParser(5, argv0);
        TEST_ASSERT_EQUALS("test\\module1_learn.csv",    Parser->LearningDataFileNameList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("test\\module1_apply.csv",    Parser->EstimatingDataFileNameList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("TCFbECosineSimilarity",    AnsiString(Parser->GetSimilarityComputationAlgorithm()->ClassName()).c_str());
        TEST_ASSERT_EQUALS("TCFbEWeightedSum",    AnsiString(Parser->GetPredictionAlgorithm()->ClassName()).c_str());
        TEST_ASSERT_EQUALS((int)vbValue,    (int)Parser->ValueBase);
        TEST_ASSERT_EQUALS((int)abRow,    (int)Parser->AlgorithmBase);
        TEST_ASSERT_EQUALS(0,    Parser->NeighborsSize);
        TEST_ASSERT_EQUALS(0,    Parser->TargetColumnLabelList->Count);
        TEST_ASSERT_EQUALS((int)false,    Parser->DisplayNeighbors);
        TEST_ASSERT_EQUALS((int)false,    Parser->DisplaySimilarities);
        TEST_ASSERT_EQUALS((int)false,    Parser->DisplayDistribution);
        TEST_ASSERT_EQUALS("",    Parser->OutputFileName.c_str());
        delete Parser;

        char* argv1[] = { "docfbe_test"
            , "--learning=test\\module1_learn.csv"
            , "--estimating=test\\module1_apply.csv"
            , "--similarity=CosineSimilarity"
            , "--prediction=WeightedSum"
        };

        Parser = new TCFbECommandLineParser(5, argv1);
        TEST_ASSERT_EQUALS("test\\module1_learn.csv",    Parser->LearningDataFileNameList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("test\\module1_apply.csv",    Parser->EstimatingDataFileNameList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("TCFbECosineSimilarity",    AnsiString(Parser->GetSimilarityComputationAlgorithm()->ClassName()).c_str());
        TEST_ASSERT_EQUALS("TCFbEWeightedSum",    AnsiString(Parser->GetPredictionAlgorithm()->ClassName()).c_str());
        TEST_ASSERT_EQUALS((int)vbValue,    (int)Parser->ValueBase);
        TEST_ASSERT_EQUALS((int)abRow,    (int)Parser->AlgorithmBase);
        TEST_ASSERT_EQUALS(0,    Parser->NeighborsSize);
        TEST_ASSERT_EQUALS(0,    Parser->TargetColumnLabelList->Count);
        TEST_ASSERT_EQUALS((int)false,    Parser->DisplayNeighbors);
        TEST_ASSERT_EQUALS((int)false,    Parser->DisplaySimilarities);
        TEST_ASSERT_EQUALS((int)false,    Parser->DisplayDistribution);
        TEST_ASSERT_EQUALS("",    Parser->OutputFileName.c_str());
        delete Parser;

        char* argv2[] = { "docfbe_test"
            , "-n=Normalize"
            , "-i"
            , "-ns=10"
            , "-t=BUG,EFFORT"
            , "-dn"
            , "-ds"
            , "-dd"
            , "-o=output.txt"
            , "-l=test\\module1_learn.csv"
            , "-e=test\\module1_apply.csv"
            , "-s=CosineSimilarity"
            , "-p=WeightedSum"
        };

        Parser = new TCFbECommandLineParser(13, argv2);
        TEST_ASSERT_EQUALS("test\\module1_learn.csv",    Parser->LearningDataFileNameList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("test\\module1_apply.csv",    Parser->EstimatingDataFileNameList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("TCFbECosineSimilarity",    AnsiString(Parser->GetSimilarityComputationAlgorithm()->ClassName()).c_str());
        TEST_ASSERT_EQUALS("TCFbEWeightedSum",    AnsiString(Parser->GetPredictionAlgorithm()->ClassName()).c_str());
        TEST_ASSERT_EQUALS((int)vbNormalizedValue,    (int)Parser->ValueBase);
        TEST_ASSERT_EQUALS((int)abColumn,    (int)Parser->AlgorithmBase);
        TEST_ASSERT_EQUALS(10,    Parser->NeighborsSize);
        TEST_ASSERT_EQUALS(2,    Parser->TargetColumnLabelList->Count);
        TEST_ASSERT_EQUALS("BUG",    Parser->TargetColumnLabelList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("EFFORT",    Parser->TargetColumnLabelList->Strings[1].c_str());
        TEST_ASSERT_EQUALS((int)true,    Parser->DisplayNeighbors);
        TEST_ASSERT_EQUALS((int)true,    Parser->DisplaySimilarities);
        TEST_ASSERT_EQUALS((int)true,    Parser->DisplayDistribution);
        TEST_ASSERT_EQUALS("output.txt",    Parser->OutputFileName.c_str());
        delete Parser;

        char* argv3[] = { "docfbe_test"
            , "--normalize=normalize"
            , "--itembased"
            , "--neighbors-size=10"
            , "--target=\"B,U,G\",\"EFFORT\""
            , "--disp-neighbors"
            , "--disp-similarities"
            , "--disp-distribution"
            , "--output=output.txt"
            , "--learning=test\\module1_learn.csv"
            , "--estimating=test\\module1_apply.csv"
            , "--similarity=CosineSimilarity"
            , "--prediction=WeightedSum"
        };

        Parser = new TCFbECommandLineParser(13, argv3);
        TEST_ASSERT_EQUALS("test\\module1_learn.csv",    Parser->LearningDataFileNameList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("test\\module1_apply.csv",    Parser->EstimatingDataFileNameList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("TCFbECosineSimilarity",    AnsiString(Parser->GetSimilarityComputationAlgorithm()->ClassName()).c_str());
        TEST_ASSERT_EQUALS("TCFbEWeightedSum",    AnsiString(Parser->GetPredictionAlgorithm()->ClassName()).c_str());
        TEST_ASSERT_EQUALS((int)vbNormalizedValue,    (int)Parser->ValueBase);
        TEST_ASSERT_EQUALS((int)abColumn,    (int)Parser->AlgorithmBase);
        TEST_ASSERT_EQUALS(10,    Parser->NeighborsSize);
        TEST_ASSERT_EQUALS(2,    Parser->TargetColumnLabelList->Count);
        TEST_ASSERT_EQUALS("B,U,G",    Parser->TargetColumnLabelList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("EFFORT",    Parser->TargetColumnLabelList->Strings[1].c_str());
        TEST_ASSERT_EQUALS((int)true,    Parser->DisplayNeighbors);
        TEST_ASSERT_EQUALS((int)true,    Parser->DisplaySimilarities);
        TEST_ASSERT_EQUALS((int)true,    Parser->DisplayDistribution);
        TEST_ASSERT_EQUALS("output.txt",    Parser->OutputFileName.c_str());
        delete Parser;
    }

    //---------------------------------------------------------------------------
    // ȉCTCFbETableEx ̃eXg
    //---------------------------------------------------------------------------
    /*
                column_0    column_1    column_2    column_3    column_4
        row_0    1                        4            100
        row_1    2                        10            1
        row_2    -5            2            3            4            5
        row_3                            3
    */
    virtual void Test_TCFbETableEx_Assign() {
        TCFbETableEx* TestTable = new TCFbETableEx();
        TestTable->Assign(this->Table);

        TEST_ASSERT_EQUALS((int)true,    TestTable->GetEnabledByIndex(0, 0));
        TEST_ASSERT_EQUALS((int)false,    TestTable->GetEnabledByIndex(0, 1));
        TEST_ASSERT_EQUALS((int)true,    TestTable->GetEnabledByIndex(0, 2));
        TEST_ASSERT_EQUALS((int)true,    TestTable->GetEnabledByIndex(0, 3));
        TEST_ASSERT_EQUALS((int)false,    TestTable->GetEnabledByIndex(0, 4));

        TEST_ASSERT_EQUALS((int)true,    TestTable->GetEnabledByIndex(1, 0));
        TEST_ASSERT_EQUALS((int)false,    TestTable->GetEnabledByIndex(1, 1));
        TEST_ASSERT_EQUALS((int)true,    TestTable->GetEnabledByIndex(1, 2));
        TEST_ASSERT_EQUALS((int)true,    TestTable->GetEnabledByIndex(1, 3));
        TEST_ASSERT_EQUALS((int)false,    TestTable->GetEnabledByIndex(1, 4));

        TEST_ASSERT_EQUALS((int)true,    TestTable->GetEnabledByIndex(2, 0));
        TEST_ASSERT_EQUALS((int)true,    TestTable->GetEnabledByIndex(2, 1));
        TEST_ASSERT_EQUALS((int)true,    TestTable->GetEnabledByIndex(2, 2));
        TEST_ASSERT_EQUALS((int)true,    TestTable->GetEnabledByIndex(2, 3));
        TEST_ASSERT_EQUALS((int)true,    TestTable->GetEnabledByIndex(2, 4));

        TEST_ASSERT_EQUALS((int)false,    TestTable->GetEnabledByIndex(3, 0));
        TEST_ASSERT_EQUALS((int)false,    TestTable->GetEnabledByIndex(3, 1));
        TEST_ASSERT_EQUALS((int)true,    TestTable->GetEnabledByIndex(3, 2));
        TEST_ASSERT_EQUALS((int)false,    TestTable->GetEnabledByIndex(3, 3));
        TEST_ASSERT_EQUALS((int)false,    TestTable->GetEnabledByIndex(3, 4));

        TEST_ASSERT_EQUALS_DOUBLE(1.0,    TestTable->GetValueByIndex(0, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0,    TestTable->GetValueByIndex(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(100.0,TestTable->GetValueByIndex(0, 3), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(2.0,    TestTable->GetValueByIndex(1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(10.0,    TestTable->GetValueByIndex(1, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0,    TestTable->GetValueByIndex(1, 3), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(-5.0,    TestTable->GetValueByIndex(2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.0,    TestTable->GetValueByIndex(2, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0,    TestTable->GetValueByIndex(2, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0,    TestTable->GetValueByIndex(2, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.0,    TestTable->GetValueByIndex(2, 4), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(3.0,    TestTable->GetValueByIndex(3, 2), 1E-6);

        delete TestTable;
    }

    /*
                column_0    column_1    column_2    column_3    column_4
        row_0    1                        4            100
        row_1    2                        10            1
        row_2    -5            2            3            4            5
        row_3                            3
    */
    virtual void Test_TCFbETableEx_RotatedAssign() {
        TCFbETableEx* TestTable = new TCFbETableEx();
        TestTable->RotatedAssign(this->Table);

        TEST_ASSERT_EQUALS((int)true,    TestTable->GetEnabledByIndex(0, 0));
        TEST_ASSERT_EQUALS((int)false,    TestTable->GetEnabledByIndex(1, 0));
        TEST_ASSERT_EQUALS((int)true,    TestTable->GetEnabledByIndex(2, 0));
        TEST_ASSERT_EQUALS((int)true,    TestTable->GetEnabledByIndex(3, 0));
        TEST_ASSERT_EQUALS((int)false,    TestTable->GetEnabledByIndex(4, 0));

        TEST_ASSERT_EQUALS((int)true,    TestTable->GetEnabledByIndex(0, 1));
        TEST_ASSERT_EQUALS((int)false,    TestTable->GetEnabledByIndex(1, 1));
        TEST_ASSERT_EQUALS((int)true,    TestTable->GetEnabledByIndex(2, 1));
        TEST_ASSERT_EQUALS((int)true,    TestTable->GetEnabledByIndex(3, 1));
        TEST_ASSERT_EQUALS((int)false,    TestTable->GetEnabledByIndex(4, 1));

        TEST_ASSERT_EQUALS((int)true,    TestTable->GetEnabledByIndex(0, 2));
        TEST_ASSERT_EQUALS((int)true,    TestTable->GetEnabledByIndex(1, 2));
        TEST_ASSERT_EQUALS((int)true,    TestTable->GetEnabledByIndex(2, 2));
        TEST_ASSERT_EQUALS((int)true,    TestTable->GetEnabledByIndex(3, 2));
        TEST_ASSERT_EQUALS((int)true,    TestTable->GetEnabledByIndex(4, 2));

        TEST_ASSERT_EQUALS((int)false,    TestTable->GetEnabledByIndex(0, 3));
        TEST_ASSERT_EQUALS((int)false,    TestTable->GetEnabledByIndex(1, 3));
        TEST_ASSERT_EQUALS((int)true,    TestTable->GetEnabledByIndex(2, 3));
        TEST_ASSERT_EQUALS((int)false,    TestTable->GetEnabledByIndex(3, 3));
        TEST_ASSERT_EQUALS((int)false,    TestTable->GetEnabledByIndex(4, 3));

        TEST_ASSERT_EQUALS_DOUBLE(1.0,    TestTable->GetValueByIndex(0, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0,    TestTable->GetValueByIndex(2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(100.0,TestTable->GetValueByIndex(3, 0), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(2.0,    TestTable->GetValueByIndex(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(10.0,    TestTable->GetValueByIndex(2, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0,    TestTable->GetValueByIndex(3, 1), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(-5.0,    TestTable->GetValueByIndex(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.0,    TestTable->GetValueByIndex(1, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0,    TestTable->GetValueByIndex(2, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0,    TestTable->GetValueByIndex(3, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.0,    TestTable->GetValueByIndex(4, 2), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(3.0,    TestTable->GetValueByIndex(2, 3), 1E-6);

        delete TestTable;
    }

    // 100    10    5    3
    virtual void Test_TCFbETableEx_GetMaxOfRow() {
        Table->AddChildCache(new TCFbERowCachedTable(Table), "Max.row", true);
        TEST_ASSERT_EQUALS_DOUBLE(100.0, Table->GetMaxOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(10.0, Table->GetMaxOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.0, Table->GetMaxOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0, Table->GetMaxOfRow(3), 1E-6);
    }

    // 1    1    -5    3
    virtual void Test_TCFbETableEx_GetMinOfRow() {
        Table->AddChildCache(new TCFbERowCachedTable(Table), "Min.row", true);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, Table->GetMinOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, Table->GetMinOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-5.0, Table->GetMinOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0, Table->GetMinOfRow(3), 1E-6);
    }

    // 35    4.333333333    1.8    3
    virtual void Test_TCFbETableEx_GetAverageOfRow() {
        Table->AddChildCache(new TCFbERowCachedTable(Table), "Average.row", true);
        TEST_ASSERT_EQUALS_DOUBLE(35.0, Table->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.333333333, Table->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.8, Table->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0, Table->GetAverageOfRow(3), 1E-6);
    }

    // 4    2    3    3
    virtual void Test_TCFbETableEx_GetMedianOfRow() {
        Table->AddChildCache(new TCFbERowCachedTable(Table), "Median.row", true);
        TEST_ASSERT_EQUALS_DOUBLE(4.0, Table->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.0, Table->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0, Table->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0, Table->GetMedianOfRow(3), 1E-6);
    }

    // 45.97825573    4.027681991    3.544009029    0
    virtual void Test_TCFbETableEx_GetStdevOfRow() {
        Table->AddChildCache(new TCFbERowCachedTable(Table), "Average.row", true);
        Table->AddChildCache(new TCFbERowCachedTable(Table), "Stdev.row", true);
        TEST_ASSERT_EQUALS_DOUBLE(45.97825573, Table->GetStdevOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.027681991, Table->GetStdevOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.544009029, Table->GetStdevOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, Table->GetStdevOfRow(3), 1E-6);
    }

    // 33.63333333    8.844444444    1.333333333
    virtual void Test_TCFbETableEx_GetAveragedMultiplierOfRow() {
        TEST_ASSERT_EQUALS_DOUBLE(33.63333333, Table->GetAveragedMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(8.844444444, Table->GetAveragedMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.333333333, Table->GetAveragedMultiplierOfRow(0, 3), 1E-6);
    }

    // 0.5    1.333333333    1.333333333
    virtual void Test_TCFbETableEx_GetMedianOfMultiplierOfRow() {
        TEST_ASSERT_EQUALS_DOUBLE(0.5, Table->GetMedianOfMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.333333333, Table->GetMedianOfMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.333333333, Table->GetMedianOfMultiplierOfRow(0, 3), 1E-6);
    }

    // 2    2    10    100    5
    virtual void Test_TCFbETableEx_GetMaxOfColumn() {
        Table->AddChildCache(new TCFbEColumnCachedTable(Table), "Max.column", true);
        TEST_ASSERT_EQUALS_DOUBLE(2.0, Table->GetMaxOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.0, Table->GetMaxOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(10.0, Table->GetMaxOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(100.0, Table->GetMaxOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.0, Table->GetMaxOfColumn(4), 1E-6);
    }

    // -5    2    3    1    5
    virtual void Test_TCFbETableEx_GetMinOfColumn() {
        Table->AddChildCache(new TCFbEColumnCachedTable(Table), "Min.column", true);
        TEST_ASSERT_EQUALS_DOUBLE(-5.0, Table->GetMinOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.0, Table->GetMinOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0, Table->GetMinOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, Table->GetMinOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.0, Table->GetMinOfColumn(4), 1E-6);
    }

    // -0.666666667    2    5    35    5
    virtual void Test_TCFbETableEx_GetAverageOfColumn() {
        Table->AddChildCache(new TCFbEColumnCachedTable(Table), "Average.column", true);
        TEST_ASSERT_EQUALS_DOUBLE(-0.666666667, Table->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.0, Table->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.0, Table->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(35.0, Table->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.0, Table->GetAverageOfColumn(4), 1E-6);
    }

    // 1    2    3.5    4    5
    virtual void Test_TCFbETableEx_GetMedianOfColumn() {
        Table->AddChildCache(new TCFbEColumnCachedTable(Table), "Median.column", true);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, Table->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.0, Table->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5, Table->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0, Table->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.0, Table->GetMedianOfColumn(4), 1E-6);
    }

    // 3.091206165    0    2.915475947    45.97825573    0
    virtual void Test_TCFbETableEx_GetStdevOfColumn() {
        Table->AddChildCache(new TCFbEColumnCachedTable(Table), "Average.column", true);
        Table->AddChildCache(new TCFbEColumnCachedTable(Table), "Stdev.column", true);
        TEST_ASSERT_EQUALS_DOUBLE(3.091206165, Table->GetStdevOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, Table->GetStdevOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.915475947, Table->GetStdevOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(45.97825573, Table->GetStdevOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, Table->GetStdevOfColumn(4), 1E-6);
    }

    // 2.5    0.705555556    1.086666667    1
    virtual void Test_TCFbETableEx_GetAveragedMultiplierOfColumn() {
        TEST_ASSERT_EQUALS_DOUBLE(2.5, Table->GetAveragedMultiplierOfColumn(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.705555556, Table->GetAveragedMultiplierOfColumn(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.086666667, Table->GetAveragedMultiplierOfColumn(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, Table->GetAveragedMultiplierOfColumn(0, 4), 1E-6);
    }

    // 2.5    0.25    1.25    1
    virtual void Test_TCFbETableEx_GetMedianOfMultiplierOfColumn() {
        TEST_ASSERT_EQUALS_DOUBLE(2.5, Table->GetMedianOfMultiplierOfColumn(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.25, Table->GetMedianOfMultiplierOfColumn(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.25, Table->GetMedianOfMultiplierOfColumn(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, Table->GetMedianOfMultiplierOfColumn(0, 4), 1E-6);
    }

    virtual void Test_TCFbETableEx() {
        /*
                    column_0    column_1    column_2    column_3
            row_0    1                                    4
            row_1                2            3
            row_2                                        5
        */
        TCFbETableEx* Table = new TCFbETableEx();
        TEST_ASSERT_EQUALS(0, Table->AddRow("row_0"));
        TEST_ASSERT_EQUALS(0, Table->AddColumn("column_0"));
        TEST_ASSERT_EQUALS(1, Table->AddColumn("column_1"));
        TEST_ASSERT_EQUALS(1, Table->AddRow("row_1"));
        TEST_ASSERT_EQUALS(2, Table->AddRow("row_2"));
        TEST_ASSERT_EQUALS(2, Table->AddColumn("column_2"));
        TEST_ASSERT_EQUALS(3, Table->AddColumn("column_3"));

        Table->SetValue("row_0", "column_0", 1.0);
        Table->SetValue("row_1", "column_1", 2.0);
        Table->SetValue("row_1", "column_2", 3.0);

        Table->SetValue("row_2", "column_3", 5.0);
        Table->SetValue("row_0", "column_3", 4.0);

        TEST_ASSERT_EQUALS(3, Table->GetNumberOfRows());
        TEST_ASSERT_EQUALS(4, Table->GetNumberOfColumns());

        TEST_ASSERT_EQUALS((int)true, Table->GetEnabled("row_0", "column_0"));
        TEST_ASSERT_EQUALS((int)false, Table->GetEnabled("row_0", "column_1"));
        TEST_ASSERT_EQUALS((int)false, Table->GetEnabled("row_0", "column_2"));
        TEST_ASSERT_EQUALS((int)true, Table->GetEnabled("row_0", "column_3"));

        TEST_ASSERT_EQUALS_DOUBLE(1.0, Table->GetValue("row_0", "column_0"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0, Table->GetValue("row_0", "column_3"), 1E-6);

        TEST_ASSERT_EQUALS((int)false, Table->GetEnabled("row_1", "column_0"));
        TEST_ASSERT_EQUALS((int)true, Table->GetEnabled("row_1", "column_1"));
        TEST_ASSERT_EQUALS((int)true, Table->GetEnabled("row_1", "column_2"));
        TEST_ASSERT_EQUALS((int)false, Table->GetEnabled("row_1", "column_3"));

        TEST_ASSERT_EQUALS_DOUBLE(2.0, Table->GetValue("row_1", "column_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0, Table->GetValue("row_1", "column_2"), 1E-6);

        TEST_ASSERT_EQUALS((int)false, Table->GetEnabled("row_2", "column_0"));
        TEST_ASSERT_EQUALS((int)false, Table->GetEnabled("row_2", "column_1"));
        TEST_ASSERT_EQUALS((int)false, Table->GetEnabled("row_2", "column_2"));
        TEST_ASSERT_EQUALS((int)true, Table->GetEnabled("row_2", "column_3"));

        TEST_ASSERT_EQUALS_DOUBLE(5.0, Table->GetValue("row_2", "column_3"), 1E-6);

        /*
                    column_0    column_1    column_3
            row_0    1                        4
            row_2                            5
        */
        Table->DeleteRow("row_1");
        Table->DeleteColumn("column_2");

        TEST_ASSERT_EQUALS(2, Table->GetNumberOfRows());
        TEST_ASSERT_EQUALS(3, Table->GetNumberOfColumns());

        TEST_ASSERT_EQUALS((int)true, Table->GetEnabled("row_0", "column_0"));
        TEST_ASSERT_EQUALS((int)false, Table->GetEnabled("row_0", "column_1"));
        TEST_ASSERT_EQUALS((int)true, Table->GetEnabled("row_0", "column_3"));

        TEST_ASSERT_EQUALS_DOUBLE(1.0, Table->GetValue("row_0", "column_0"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0, Table->GetValue("row_0", "column_3"), 1E-6);

        TEST_ASSERT_EQUALS((int)false, Table->GetEnabled("row_2", "column_0"));
        TEST_ASSERT_EQUALS((int)false, Table->GetEnabled("row_2", "column_1"));
        TEST_ASSERT_EQUALS((int)true, Table->GetEnabled("row_2", "column_3"));

        TEST_ASSERT_EQUALS_DOUBLE(5.0, Table->GetValue("row_2", "column_3"), 1E-6);

        /*
                    column_0    column_1    column_3    column_4
            row_0    1                        4            100
            row_2    2                        10            1
        */
        Table->SetValue("row_2", "column_0", 2.0);
        Table->SetValue("row_2", "column_3", 10.0);

        Table->AddColumn("column_4");
        Table->SetValue("row_0", "column_4", 100.0);
        Table->SetValue("row_2", "column_4", 1.0);

        TEST_ASSERT_EQUALS(2, Table->GetNumberOfRows());
        TEST_ASSERT_EQUALS(4, Table->GetNumberOfColumns());

        TEST_ASSERT_EQUALS((int)true, Table->GetEnabled("row_0", "column_0"));
        TEST_ASSERT_EQUALS((int)false, Table->GetEnabled("row_0", "column_1"));
        TEST_ASSERT_EQUALS((int)true, Table->GetEnabled("row_0", "column_3"));
        TEST_ASSERT_EQUALS((int)true, Table->GetEnabled("row_0", "column_4"));

        TEST_ASSERT_EQUALS_DOUBLE(1.0, Table->GetValue("row_0", "column_0"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0, Table->GetValue("row_0", "column_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(100.0, Table->GetValue("row_0", "column_4"), 1E-6);

        TEST_ASSERT_EQUALS((int)true, Table->GetEnabled("row_2", "column_0"));
        TEST_ASSERT_EQUALS((int)false, Table->GetEnabled("row_2", "column_1"));
        TEST_ASSERT_EQUALS((int)true, Table->GetEnabled("row_2", "column_3"));
        TEST_ASSERT_EQUALS((int)true, Table->GetEnabled("row_2", "column_4"));

        TEST_ASSERT_EQUALS_DOUBLE(2.0, Table->GetValue("row_2", "column_0"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(10.0, Table->GetValue("row_2", "column_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, Table->GetValue("row_2", "column_4"), 1E-6);


        /*
                    column_0    column_1    column_3    column_4
            row_0    1+4=5                    4            100
            row_2    2+10+2=14    +4=4        10-3=7        1
        */
        Table->SetValue("row_2", "column_1", 4.0);
        Table->SetValue("row_2", "column_3", Table->GetValue("row_2", "column_3") - 3.0);
        Table->SetValue("row_2", "column_0", Table->GetValue("row_2", "column_0") + 10.0);

        Table->SetValue("row_2", "column_0", Table->GetValue("row_2", "column_0") + 2.0);
        Table->SetValue("row_0", "column_0", Table->GetValue("row_0", "column_0") + 4.0);

        TEST_ASSERT_EQUALS(2, Table->GetNumberOfRows());
        TEST_ASSERT_EQUALS(4, Table->GetNumberOfColumns());

        TEST_ASSERT_EQUALS((int)true, Table->GetEnabled("row_0", "column_0"));
        TEST_ASSERT_EQUALS((int)false, Table->GetEnabled("row_0", "column_1"));
        TEST_ASSERT_EQUALS((int)true, Table->GetEnabled("row_0", "column_3"));
        TEST_ASSERT_EQUALS((int)true, Table->GetEnabled("row_0", "column_4"));

        TEST_ASSERT_EQUALS_DOUBLE(5.0, Table->GetValue("row_0", "column_0"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0, Table->GetValue("row_0", "column_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(100.0, Table->GetValue("row_0", "column_4"), 1E-6);

        TEST_ASSERT_EQUALS((int)true, Table->GetEnabled("row_2", "column_0"));
        TEST_ASSERT_EQUALS((int)true, Table->GetEnabled("row_2", "column_1"));
        TEST_ASSERT_EQUALS((int)true, Table->GetEnabled("row_2", "column_3"));
        TEST_ASSERT_EQUALS((int)true, Table->GetEnabled("row_2", "column_4"));

        TEST_ASSERT_EQUALS_DOUBLE(14.0, Table->GetValue("row_2", "column_0"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0, Table->GetValue("row_2", "column_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(7.0, Table->GetValue("row_2", "column_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, Table->GetValue("row_2", "column_4"), 1E-6);

        delete Table;
    }

    virtual void Test_DB() {
//        TCFbEDataAccessor* DataAccessor = new TCFbEDataAccessor("TestDB");
//        DataAccessor->CreateTable();
//        DataAccessor->GetCell("module1", "LOC", 100.0);
//        delete DataAccessor;
    }

protected:

};

//---------------------------------------------------------------------------
#endif
