using System.Collections;
using System.Collections.Generic;

namespace NDac.Datas
{
	/// <summary>
	/// データアダプタホルダーのコレクションを表します。
	/// </summary>
	class DataAdapterHolderCollection : Dictionary< string, DataAdapterHolder >
	{
		/// <summary>
		/// インデクサ
		/// </summary>
		/// <param name="tableName">テーブル名</param>
		/// <returns>データアダプタホルダー</returns>
		public new DataAdapterHolder this[ string tableName ]
		{
			get
			{
				return( base[ tableName ] );
			}
			set
			{
				base[ tableName ] = value;
			}
		}

		/// <summary>
		/// データアダプタホルダーを追加します。
		/// </summary>
		/// <param name="tableName">テーブル名</param>
		/// <param name="adapterHolder">データアダプタホルダー</param>
		public new void Add( string tableName, DataAdapterHolder adapterHolder )
		{
			base.Add( tableName, adapterHolder );
		}

		/// <summary>
		/// 内部に格納しているテーブル名（キー）のコレクションを表します。
		/// </summary>
		public KeyCollection TableNames
		{
			get
			{
				return( base.Keys );
			}
		}

		/// <summary>
		/// 内部に格納しているデータアダプタホルダー（値）のコレクションを表します。
		/// </summary>
		public ValueCollection DataAdapterHolders
		{
			get
			{
				return( base.Values );
			}
		}

		/// <summary>
		/// デッドロック回避用にテーブル名順にソート済みのデータアダプタホルダーのリストを表します。
		/// </summary>
		public List< DataAdapterHolder > DeadlockAvoidanceDataAdapterHolders
		{
			get
			{
				List< DataAdapterHolder > adapterHolders = new List< DataAdapterHolder >();

				foreach( DataAdapterHolder adapterHolder in this.DataAdapterHolders )
				{
					adapterHolders.Add( adapterHolder );
				}

				adapterHolders.Sort( ( x, y ) => x.TableName.CompareTo( y.TableName ) );

				return( adapterHolders );
			}
		}
	}
}
