using System;
using System.Text;
using System.Data;

namespace NDac.Datas.QueryGenerators
{
	/// <summary>
	/// INSERTクエリ生成器を表します。
	/// </summary>
	class InsertQueryGenerator : IQueryGenerator
	{
		#region IQueryGenerator メンバ

		/// <summary>
		/// クエリを生成します。
		/// </summary>
		/// <param name="row">データ行</param>
		/// <param name="schemaTable">テーブルのスキーマ情報</param>
		/// <returns>クエリ</returns>
		public string Generate( DataRow row, DataTable schemaTable )
		{
			StringBuilder columnsBuilder	= new StringBuilder();

			StringBuilder valuesBuilder		= new StringBuilder();

			bool mustJoint = false;

			foreach( DataColumn column in schemaTable.Columns )
			{
				if( row[ column.ColumnName ] != DBNull.Value )
				{
					if( mustJoint )
					{
						columnsBuilder.Append( ", " );

						valuesBuilder.Append( ", " );
					}

					columnsBuilder.Append( string.Format( "{0}", column.ColumnName ) );

					valuesBuilder.Append( QueryGenerateHelper.ToInsertValueString( column, row ) );

					mustJoint = true;
				}
			}

			return( string.Format( "INSERT INTO {0} ( {1} ) VALUES ( {2} ) ", schemaTable.TableName, columnsBuilder.ToString(), valuesBuilder.ToString() ) );
		}

		#endregion
	}
}
