using System;
using System.Collections.Generic;
using System.Data;

namespace NDac.Datas.QueryGenerators
{
	/// <summary>
	/// クエリ生成器ヘルパーを表します。
	/// </summary>
	class QueryGenerateHelper
	{
		private static Dictionary< Type, bool > _isSingleQuotation = null;

		/// <summary>
		/// INSERT文のデータ文字列に変換します。
		/// </summary>
		/// <param name="column">データ列</param>
		/// <param name="row">データ行</param>
		/// <returns>INSERT文のデータ文字列</returns>
		public static string ToInsertValueString( DataColumn column, DataRow row )
		{
			if( row[ column.ColumnName ] == DBNull.Value )
			{
				return( string.Format( "{0}", "NULL" ) );
			}
			else if( IsSingleQuotation( column.DataType ) )
			{
				return( string.Format( "'{0}'", row[ column.ColumnName ] ) );
			}
			else if( column.DataType == typeof( bool ) )
			{
				return( string.Format( "{0}", ( bool )row[ column.ColumnName ] ? 1 : 0 ) );
			}
			else
			{
				return( string.Format( "{0}", row[ column.ColumnName ] ) );
			}
		}

		/// <summary>
		/// UPDATE文のデータセット文字列に変換します。
		/// </summary>
		/// <param name="column">データ列</param>
		/// <param name="row">データ行</param>
		/// <returns>UPDATE文のデータセット文字列</returns>
		public static string ToUpdateSetDataString( DataColumn column, DataRow row )
		{
			if( row[ column.ColumnName ] == DBNull.Value )
			{
				return( string.Format( "{0} = {1}", column.ColumnName, "NULL" ) );
			}
			else if( IsSingleQuotation( column.DataType ) )
			{
				return( string.Format( "{0} = '{1}'", column.ColumnName, row[ column.ColumnName ] ) );
			}
			else if( column.DataType == typeof( bool ) )
			{
				return( string.Format( "{0} = {1}", column.ColumnName, ( bool )row[ column.ColumnName ] ? 1 : 0 ) );
			}
			else
			{
				return( string.Format( "{0} = {1}", column.ColumnName, row[ column.ColumnName ] ) );
			}
		}

		/// <summary>
		/// WHERE条件の文字列に変換します。
		/// </summary>
		/// <param name="column">データ列</param>
		/// <param name="row">データ行</param>
		/// <returns>WHERE条件の文字列</returns>
		public static string ToWhereConditionString( DataColumn column, DataRow row )
		{
			if( row[ column.ColumnName ] == DBNull.Value )
			{
				return( string.Format( "( {0} = {1} )", column.ColumnName, "NULL" ) );
			}
			else if( IsSingleQuotation( column.DataType ) )
			{
				return( string.Format( "( {0} = '{1}' )", column.ColumnName, row[ column.ColumnName ] ) );
			}
			else if( column.DataType == typeof( bool ) )
			{
				return( string.Format( "( {0} = {1} )", column.ColumnName, ( bool )row[ column.ColumnName ] ? 1 : 0 ) );
			}
			else
			{
				return( string.Format( "( {0} = {1} )", column.ColumnName, row[ column.ColumnName ] ) );
			}
		}

		/// <summary>
		/// シングルクォーテーションが必要かを判断します。
		/// </summary>
		/// <param name="dataType">カラムのデータ型</param>
		/// <returns>シングルクォーテーションが必要の場合trueが返ります。</returns>
		public static bool IsSingleQuotation( Type dataType )
		{
			if( _isSingleQuotation == null )
			{
				_isSingleQuotation = new Dictionary< Type, bool >();

				_isSingleQuotation.Add( typeof( System.Boolean ),	false );
				_isSingleQuotation.Add( typeof( System.Int16 ),		false );
				_isSingleQuotation.Add( typeof( System.Int32 ),		false );
				_isSingleQuotation.Add( typeof( System.Int64 ),		false );
				_isSingleQuotation.Add( typeof( System.UInt16 ),	false );
				_isSingleQuotation.Add( typeof( System.UInt32 ),	false );
				_isSingleQuotation.Add( typeof( System.UInt64 ),	false );
				_isSingleQuotation.Add( typeof( System.Single ),	false );
				_isSingleQuotation.Add( typeof( System.Double ),	false );
				_isSingleQuotation.Add( typeof( System.Byte ),		false );
				_isSingleQuotation.Add( typeof( System.SByte ),		false );
				_isSingleQuotation.Add( typeof( System.Char ),		true );
				_isSingleQuotation.Add( typeof( System.String ),	true );
				_isSingleQuotation.Add( typeof( System.Decimal ),	false );
				_isSingleQuotation.Add( typeof( System.DateTime ),	true );
				_isSingleQuotation.Add( typeof( System.Object ),	false );
				_isSingleQuotation.Add( typeof( System.Guid ),		false );
				_isSingleQuotation.Add( typeof( System.Boolean[] ),	false );
				_isSingleQuotation.Add( typeof( System.Int16[] ),	false );
				_isSingleQuotation.Add( typeof( System.Int32[] ),	false );
				_isSingleQuotation.Add( typeof( System.Int64[] ),	false );
				_isSingleQuotation.Add( typeof( System.UInt16[] ),	false );
				_isSingleQuotation.Add( typeof( System.UInt32[] ),	false );
				_isSingleQuotation.Add( typeof( System.UInt64[] ),	false );
				_isSingleQuotation.Add( typeof( System.Single[] ),	false );
				_isSingleQuotation.Add( typeof( System.Double[] ),	false );
				_isSingleQuotation.Add( typeof( System.Byte[] ),	false );
				_isSingleQuotation.Add( typeof( System.SByte[] ),	false );
				_isSingleQuotation.Add( typeof( System.Char[] ),	true );
				_isSingleQuotation.Add( typeof( System.String[] ),	true );
				_isSingleQuotation.Add( typeof( System.Decimal[] ),	false );
				_isSingleQuotation.Add( typeof( System.DateTime[] ),true );
				_isSingleQuotation.Add( typeof( System.Object[] ),	false );
				_isSingleQuotation.Add( typeof( System.Guid[] ),	false );
			}

			if( _isSingleQuotation.ContainsKey( dataType ) )
			{
				return( _isSingleQuotation[ dataType ] );
			}
			else
			{
				return( false );
			}
		}
	}
}
