using System;
using System.Data;
using System.Data.SqlClient;
using NDac.Datas;
using NDac.Keys;

namespace NDac.Gateways
{
	/// <summary>
	/// Bookテーブルのゲートウェイを表します。
	/// </summary>
	public partial class BookGateway : TableDataGateway< BookKey >
	{
		private const string TABLE_NAME = "Book";

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="connectionString">接続文字列</param>
		public BookGateway( string connectionString )
			: base( TABLE_NAME, connectionString )
		{
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="holder">データセットホルダー</param>
		public BookGateway( DataSetHolder holder )
			: base( TABLE_NAME, holder )
		{
		}

		/// <summary>
		/// アクセスするテーブル名を表します。
		/// </summary>
		public static string AccessTableName
		{
			get
			{
				return( TABLE_NAME );
			}
		}

		/// <summary>
		/// キー情報に一致したレコードが存在するかを判定します。
		/// </summary>
		/// <param name="id">Id</param>
		/// <returns>キー情報に一致したレコードが存在する場合trueを返します。</returns>
		public bool HasValue( long id )
		{
			return( this.HasValue( new BookKey( id ) ) );
		}

		/// <summary>
		/// キー情報に一致したレコードが存在するかを判定します。
		/// </summary>
		/// <param name="primaryKey">プライマリキー</param>
		/// <returns>キー情報に一致したレコードが存在する場合trueを返します。</returns>
		public override bool HasValue( BookKey primaryKey )
		{
			string sql = string.Format( "SELECT TOP 1 * FROM {0} WHERE ( Id = @Id )", this.TableName );	//HasValueは"SELECT TOP 1"で統一

			SqlCommand selectCommand = new SqlCommand( sql );

			selectCommand.Parameters.Add( new SqlParameter( "@Id", primaryKey.Id ) );

			return( this.Holder.HasRecord( selectCommand ) );
		}

		/// <summary>
		/// キー情報に一致したデータを充填します。
		/// </summary>
		/// <param name="id">Id</param>
		public void LoadBy( long id )
		{
			this.LoadBy( new BookKey( id ) );
		}

		/// <summary>
		/// キー情報に一致したデータを充填します。
		/// </summary>
		/// <param name="primaryKey">プライマリキー</param>
		public override void LoadBy( BookKey primaryKey )
		{
			string sql = string.Format( "SELECT * FROM {0} WHERE ( Id = @Id )", this.TableName );

			SqlCommand selectCommand = new SqlCommand( sql );

			selectCommand.Parameters.Add( new SqlParameter( "@Id", primaryKey.Id ) );

			this.Holder.FillData( this.TableName, selectCommand );
		}

		/// <summary>
		/// キー情報に一致したデータを追加充填します。
		/// </summary>
		/// <param name="id">Id</param>
		public void MoreLoadBy( long id )
		{
			this.MoreLoadBy( new BookKey( id ) );
		}

		/// <summary>
		/// キー情報に一致したデータを追加充填します。
		/// </summary>
		/// <param name="primaryKey">プライマリキー</param>
		public override void MoreLoadBy( BookKey primaryKey )
		{
			string sql = string.Format( "SELECT * FROM {0} WHERE ( Id = @Id )", this.TableName );

			SqlCommand selectCommand = new SqlCommand( sql );

			selectCommand.Parameters.Add( new SqlParameter( "@Id", primaryKey.Id ) );

			this.Holder.MoreFillData( this.TableName, selectCommand );
		}
	}
}
