using System;
using NDac.Keys;
using NDac.Modules.Entities;
using NDac.RemoteFacades;

namespace NDac.IdentityMappings
{
	/// <summary>
	/// IdNumberingテーブルのファインダを表します。
	/// </summary>
	public partial class IdNumberingFinder
	{
		private static IdNumberingFinder _instance;
		private IdentityMap< IdNumberingKey, IdNumberingEntity > _identityMap = new IdentityMap< IdNumberingKey, IdNumberingEntity >();

		/// <summary>
		/// コンストラクタ
		/// </summary>
		private IdNumberingFinder()
		{
			this.Constructed();
		}

		/// <summary>
		/// インスタンスを表します。
		/// </summary>
		public static IdNumberingFinder Instance
		{
			get
			{
				if( _instance == null )
				{
					_instance = new IdNumberingFinder();
				}

				return( _instance );
			}
		}

		/// <summary>
		/// キー情報に一致するIdNumberingテーブルのエンティティを取得します。
		/// <para>まず一意マッピングを検索し、一意マッピングに存在する値を返します。</para>
		/// <para>一意マッピングに存在しない場合はFurnaceModelテーブルを検索し、IdNumberingテーブルに存在する値を返します。</para>
		/// <para>一意マッピング，IdNumberingテーブルのいずれにも存在しない場合はnullを返します。</para>
		/// </summary>
		/// <param name="tableName">TableName</param>
		/// <returns>IdNumberingテーブルのエンティティ</returns>
		public IdNumberingEntity Find( string tableName )
		{
			return( this.Find( new IdNumberingKey( tableName ) ) );
		}

		/// <summary>
		/// キー情報に一致するIdNumberingテーブルのエンティティを取得します。
		/// <para>まず一意マッピングを検索し、一意マッピングに存在する値を返します。</para>
		/// <para>一意マッピングに存在しない場合はIdNumberingテーブルを検索し、IdNumberingテーブルに存在する値を返します。</para>
		/// <para>一意マッピング，IdNumberingテーブルのいずれにも存在しない場合はnullを返します。</para>
		/// </summary>
		/// <param name="primaryKey">プライマリキー</param>
		/// <returns>IdNumberingテーブルのエンティティ</returns>
		public IdNumberingEntity Find( IdNumberingKey primaryKey )
		{
			if( !this._identityMap.ContainsKey( primaryKey ) )
			{
				IdNumberingFacade facade = new IdNumberingFacade();

				facade.LoadBy( primaryKey );

				if( 0 < facade.Count )
				{
					this._identityMap.Add( primaryKey, facade[ primaryKey ] );
				}
				else
				{
					this._identityMap.Add( primaryKey, null );
				}
			}

			this.Finded( primaryKey, this._identityMap[ primaryKey ] );

			return( this._identityMap[ primaryKey ] );
		}

		/// <summary>
		/// テーブルより全データを充填し、一意マッピングに登録します。
		/// </summary>
		public void LoadAll()
		{
			IdNumberingFacade facade = new IdNumberingFacade();

			facade.LoadAll();

			if( this._identityMap.Count != facade.Count )
			{
				foreach( IdNumberingEntity entity in facade )
				{
					if( !this._identityMap.ContainsKey( entity.GetPrimaryKey() ) )
					{
						this._identityMap.Add( entity.GetPrimaryKey(), entity );
					}
				}
			}
		}

		/// <summary>
		/// 一意マッピングに存在する全ての値をクリアします。
		/// </summary>
		public void Clear()
		{
			this._identityMap.Clear();
		}

		/// <summary>
		/// コンストラクタが呼び出された後にコールされます。
		/// </summary>
		partial void Constructed();

		/// <summary>
		/// Find終了処理を実行します。
		/// </summary>
		/// <param name="key">キー</param>
		/// <param name="entity">Find処理結果のエンティティ</param>
		partial void Finded( IdNumberingKey key, IdNumberingEntity entity );
	}
}
