using System;
using System.Data;
using NDac.Datas;
using NDac.Modules.Entities;

namespace NDac.Modules
{
	/// <summary>
	/// テーブルモジュールの抽象クラスを表します。
	/// </summary>
	/// <typeparam name="TKey">キーの型</typeparam>
	/// <typeparam name="TEntity">エンティティの型</typeparam>
	public abstract partial class TableModule : ITableModule
	{
		/// <summary>
		/// データセットホルダーを取得します。
		/// </summary>
		/// <returns>データセットホルダー</returns>
		public DataSetHolder GetHolder()
		{
			try
			{
				return( this._table.DataSet.GetHolder() );
			}
			catch
			{
				return( null );
			}
		}

		/// <summary>
		/// データセットを取得します。
		/// </summary>
		/// <returns>データセット</returns>
		public DataSet GetDataSet()
		{
			try
			{
				return( this._table.DataSet );
			}
			catch
			{
				return( null );
			}
		}
	}
}
