using System;
using NDac.Datas;
using NDac.Gateways;
using NDac.Keys;
using NDac.Modules;
using NDac.Modules.DataTransferObjects;
using NDac.Modules.Entities;

namespace NDac.RemoteFacades
{
	/// <summary>
	/// Bookテーブルのリモートファサードを表します。
	/// </summary>
	public class BookFacade : RemoteFacade< BookKey, BookGateway, BookEntity, BookDTO, BookModule >
	{
		/// <summary>
		/// コンストラクタ
		/// </summary>
		public BookFacade() : base( new DataSetHolder() )
		{
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="connectionString">接続文字列</param>
		public BookFacade( string connectionString ) : base( new DataSetHolder( connectionString ) )
		{
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="holder">データセットホルダー</param>
		public BookFacade( DataSetHolder holder ) : base( holder )
		{
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="loadKey">充填するキー</param>
		public BookFacade( IKey loadKey ) : base( new DataSetHolder(), loadKey )
		{
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="connectionString">接続文字列</param>
		/// <param name="loadKey">充填するキー</param>
		public BookFacade( string connectionString, IKey loadKey ) : base( new DataSetHolder( connectionString ), loadKey )
		{
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="holder">データセットホルダー</param>
		/// <param name="loadKey">充填するキー</param>
		public BookFacade( DataSetHolder holder, IKey loadKey ) : base( holder, loadKey )
		{
		}

		/// <summary>
		/// インデクサ
		/// </summary>
		/// <param name="id">Id</param>
		/// <returns>エンティティ</returns>
		public BookEntity this[ long id ]
		{
			get
			{
				return( this[ new BookKey( id ) ] );
			}
		}

		/// <summary>
		/// アクセスするテーブル名を表します。
		/// </summary>
		public static string AccessTableName
		{
			get
			{
				return( BookGateway.AccessTableName );
			}
		}

		/// <summary>
		/// 新しいテーブルデータゲートウェイを作成します。
		/// </summary>
		/// <param name="holder">データセットホルダー</param>
		/// <returns>テーブルデータゲートウェイ</returns>
		protected override BookGateway NewGateway( DataSetHolder holder )
		{
			return( new BookGateway( holder ) );
		}

		/// <summary>
		/// 新しいテーブルモジュールを作成します。
		/// </summary>
		/// <param name="holder">データセットホルダー</param>
		/// <returns>テーブルモジュール</returns>
		protected override BookModule NewModule( DataSetHolder holder )
		{
			return( new BookModule( holder ) );
		}
	}
}
