using System;
using System.Reflection;

namespace NDac
{
	/// <summary>
	/// 値検証者を表します。
	/// </summary>
	static class ValueVerifier
	{
		/// <summary>
		/// ハッシュコードを取得します。
		/// </summary>
		/// <param name="obj">オブジェクト</param>
		/// <returns>ハッシュコード</returns>
		public static int GetHashCode( object obj )
		{
			int hashCode = 0;

			int i = 0;

			foreach( PropertyInfo pi in obj.GetType().GetProperties() )
			{
				object value = pi.GetValue( obj, null );

				i++;

				if( value == null )
				{
					hashCode ^= ( 0 + i.GetHashCode() );
				}
				else
				{
					hashCode ^= ( value.GetHashCode() + i.GetHashCode() );
				}
			}

			return( hashCode );
		}

		/// <summary>
		/// オブジェクト１とオブジェクト２の値が等しいかを判定します。
		/// </summary>
		/// <param name="obj1">オブジェクト１</param>
		/// <param name="obj2">オブジェクト２</param>
		/// <returns>オブジェクト１とオブジェクト２の値が等しい場合trueを返します。</returns>
		public static bool IsEquals( object obj1, object obj2 )
		{
			if( HasNullValue( obj1, obj2 ) )
			{
				return( IsNullValueAll( obj1, obj2 ) );
			}
			else
			{
				if( obj1.GetType() != obj2.GetType() )
				{
					return( false );
				}
				else
				{
					return( IsEqualPropertyValues( obj1, obj2 ) );
				}
			}
		}

		/// <summary>
		/// オブジェクト１,オブジェクト２の何れかがnull値を持っているかを判定します。
		/// </summary>
		/// <param name="obj1">オブジェクト１</param>
		/// <param name="obj2">オブジェクト２</param>
		/// <returns>オブジェクト１,オブジェクト２の何れかがnull値を持っている場合trueを返します。</returns>
		public static bool HasNullValue( object obj1, object obj2 )
		{
			return( ( obj1 == null ) || ( obj2 == null ) );
		}

		/// <summary>
		/// オブジェクト１,オブジェクト２共にnull値であるかを判定します。
		/// </summary>
		/// <param name="obj1">オブジェクト１</param>
		/// <param name="obj2">オブジェクト２</param>
		/// <returns>オブジェクト１,オブジェクト２共にnull値である場合trueを返します。</returns>
		public static bool IsNullValueAll( object obj1, object obj2 )
		{
			return( ( obj1 == null ) && ( obj2 == null ) );
		}

		/// <summary>
		/// オブジェクト１とオブジェクト２のプロパティ値が等しいかを判定します。
		/// </summary>
		/// <param name="obj1">オブジェクト１</param>
		/// <param name="obj2">オブジェクト２</param>
		/// <returns>オブジェクト１とオブジェクト２のプロパティ値が等しい場合trueを返します。</returns>
		private static bool IsEqualPropertyValues( object obj1, object obj2 )
		{
			foreach( PropertyInfo pi in obj1.GetType().GetProperties() )
			{
				object value1 = pi.GetValue( obj1, null );

				object value2 = pi.GetValue( obj2, null );

				if( !value1.Equals( value2 ) )
				{
					return( false );
				}
			}

			return( true );
		}
	}
}
