﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NDac.Keys
{
	/// <summary>
	/// 出版社名検索キーを表します。
	/// </summary>
	public class PublisherNameLikeSelectKey : Key
	{
		private string			_name;
		private MatchingType	_matching;

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="name">名称</param>
		public PublisherNameLikeSelectKey( string name ) : this( name, MatchingType.Prefix )
		{
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="name">名称</param>
		/// <param name="matching">キーワード検索の一致タイプ</param>
		public PublisherNameLikeSelectKey( string name, MatchingType matching )
		{
			this._name		= name;

			this._matching	= matching;
		}

		/// <summary>
		/// 名称を表します。
		/// </summary>
		public string Name
		{
			get
			{
				return( this._matching.ToKeyword( this._name ) );
			}
		}
	}
}
