# This program is distributed under the terms of the
# GNU General Public License, version 2.
#
# Nekorum is forum additional plugin for MTOS/MT4.1 later.
# Original Copyright (c) 2008 nekotama (http://nekotama.org/)
#
# $Id: TinyMCE.pm 91 2008-05-21 14:24:29Z nekotama $

package Nekorum::Tags::TinyMCE;
use strict;

use MT;

sub _print_script {
	my $app = MT->instance;
	my ($ctx, $args) = @_;
	
	my $blog = $ctx->stash('blog');
	my $sanitize_spec = $blog->sanitize_spec || MT->config->GlobalSanitizeSpec;
	my $static_path = $ctx->_hdlr_static_path($args);
	my @sanitize_array = split(/,/,$sanitize_spec);
	my $style = $args->{style} or undef;
	$style = "content_css : \"$style\"," if($style);
	my $base = $app->base;
	
	my %santize_list = (
		'a href' => 'link,unlink',
		'strong' => 'bold',
		'i' => 'italic',
		'p' => 'justifyleft,justifycenter,justifyright,justifyfull,|,outdent,indent',
		'ul' => 'bullist',
		'ol' => 'numlist',
		'blockquote' => 'blockquote',
		'span' => 'underline,strikethrough,|,forecolor,backcolor,|,fontselect,fontsizeselect,|,styleselect',
		'table' => 'tablecontrols',
		'img src' => 'emotions,image',
		'sup' => 'sup',
		'sub' => 'sub',
	);
	my $sanitize1 = '';
	my $sanitize2 = '';
	foreach $_ (@sanitize_array){
		if($_ eq 'span'){
			$sanitize2 = $santize_list{"$_"};
		} elsif(length($sanitize1)){
			$sanitize1 .= ',|,' . $santize_list{$_} if(length($santize_list{$_}));
		} else {
			$sanitize1 .= $santize_list{"$_"};
		}
	}
	
	my $out = <<HERE;
    <script type="text/javascript" src="${static_path}plugins/Nekorum/jscripts/tiny_mce/tiny_mce.js"></script>
<script language="javascript" type="text/javascript">
//<![CDATA[
tinyMCE.init({
    mode : "textareas",
    language: "ja",
    theme : "advanced",
    document_base_url : "$base",
    relative_urls : false,
    convert_newlines_to_brs : true,
    encoding : "xml",
    force_br_newlines : true,
    forced_root_block : 'p',
    fix_nesting : true,
    cleanup : true,
    $style
    plugins : "safari,spellchecker,style,layer,table,save,advhr,advimage,advlink,emotions,iespell,inlinepopups,insertdatetime,preview,media,searchreplace,print,contextmenu,paste,directionality,fullscreen,noneditable,visualchars,nonbreaking,xhtmlxtras,template,pagebreak",
    theme_advanced_buttons1: "preview,save,cancel,|,undo,redo,|,cut,copy,paste,pastetext,pasteword,|,search,replace,|,ltr,rtl,|,removeformat,charmap,|,cleanup,visualaid,fullscreen,code,help",
    theme_advanced_buttons2: "$sanitize1",
    theme_advanced_buttons3: "$sanitize2",
    theme_advanced_toolbar_location : "top",
    theme_advanced_toolbar_align : "left",
    theme_advanced_statusbar_location : "bottom",
    theme_advanced_resize_horizontal : false,
    theme_advanced_resizing : true,
    apply_source_formatting : true
});
//]]>
</script>
HERE
	return $out;
}

1;
