/*
 * Created on 2006/08/25
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.macaddress.gui;

import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeView;
import netjfwatcher.macaddress.preference.MacAddressConfig;
import netjfwatcher.macaddress.preference.MacAddressInfo;

import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

/**
 * MAChXEditor ViewNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class MacAddressSearchEditorView extends AbstractEditorNodeView {
	/* eLXg */
	private static final int VENDOR_SEARCH_TEXT_WIDTH = 150;

	private static final int OUI_SEARCH_TEXT_WIDTH = 100;

	/* MO */
	private static Logger logger;

	/* Interface MIBe[u JRatio */
	private static final float COLUMN0_NO_RATIO = 0.05f;

	private static final float COLUMN1_VENDOR_ID_RATIO = 0.1f;

	private static final float COLUMN2_VENDOR_INFO_RATIO = 0.6f;

	private static final String NO = "No.";

	private static final String VENDOR_ID = "Vendor ID";

	private static final String VENDOR_INFO = "Vendor Information";

	private static final int NO_POS = 0;

	private static final int VENDOR_ID_POS = 1;

	private static final int VENDOR_INFO_POS = 2;

	private static final int COLUMN_NO = 3;

	private Map macInfoHashMap;

	private Text vendorIDSearchText;

	private Text vendorInfoSearchText;

	private Button ouiSearchButton;

	private Button vedorSearchButton;

	private Button allViewButton;

	/* Interface MIB\ TableViewer */
	private TableViewer viewer;

	/* Text BackColor */
	private Color textBackColor;

	/**
	 * EditorEBhEɃuEU\邽߂̃CX^X 𐶐܂B
	 * 
	 */
	public MacAddressSearchEditorView() {
		logger = Logger.getLogger(this.getClass().getName());

		textBackColor = Display.getCurrent().getSystemColor(SWT.COLOR_WHITE);
	}

	/**
	 * EditorEBhE𐶐܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {
		GridLayout layout = new GridLayout(1, false);
		parent.setLayout(layout);

		GridData gridData = null;

		GridLayout gridLayout = new GridLayout(7, false);
		Composite composite = new Composite(parent, SWT.NULL);

		composite.setLayout(gridLayout);
		composite.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		gridData = new GridData();

		Label label = new Label(composite, SWT.NONE);
		label.setText("Vedor ID");
		label.setLayoutData(new GridData());
		vendorIDSearchText = new Text(composite, SWT.BORDER);
		vendorIDSearchText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = OUI_SEARCH_TEXT_WIDTH;
		vendorIDSearchText.setLayoutData(gridData);

		ouiSearchButton = new Button(composite, SWT.NONE);
		ouiSearchButton.setText("Search");
		ouiSearchButton.setLayoutData(new GridData());

		label = new Label(composite, SWT.NONE);
		label.setText("Vedor Info");
		label.setLayoutData(new GridData());
		vendorInfoSearchText = new Text(composite, SWT.BORDER);
		vendorInfoSearchText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = VENDOR_SEARCH_TEXT_WIDTH;
		vendorInfoSearchText.setLayoutData(gridData);

		vedorSearchButton = new Button(composite, SWT.NONE);
		vedorSearchButton.setText("Search");
		vedorSearchButton.setLayoutData(new GridData());

		allViewButton = new Button(composite, SWT.NONE);
		allViewButton.setText("All Show");
		allViewButton.setLayoutData(new GridData());

		macInfoHashMap = MacAddressConfig.getInstance().getResourceFileParse()
				.getMacInfoHashMap();

		SnmpInterfaceMibTable statisticsTable = new SnmpInterfaceMibTable();
		table = statisticsTable.createTable(parent);

		viewer = new TableViewer(table);
		viewer.setUseHashlookup(true);

		setMacAddressTable();

		ouiSearchButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				ouiSearchButton.setEnabled(false);
				searchVedorID();

				ouiSearchButton.setEnabled(true);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});
		vedorSearchButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				vedorSearchButton.setEnabled(false);

				searchVedorInfo();

				vedorSearchButton.setEnabled(true);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		allViewButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				allViewButton.setEnabled(false);
				setMacAddressTable();
				allViewButton.setEnabled(true);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});
	}

	private void searchVedorID() {
		String searchVendorID = vendorIDSearchText.getText();

		/* e[ȗSč폜ătbV */
		table.removeAll();
		viewer.refresh();

		long count = 0;
		macInfoHashMap = MacAddressConfig.getInstance().getResourceFileParse()
				.getMacInfoHashMap();

		for (Iterator it = macInfoHashMap.keySet().iterator(); it.hasNext();) {
			String[] macAddressTableCellArray = new String[COLUMN_NO];
			String key = (String) it.next();
			MacAddressInfo macInfo = (MacAddressInfo) macInfoHashMap.get(key);
			int hitCount = macInfo.getOui().indexOf(
					searchVendorID.toUpperCase());

			if (hitCount >= 0) {
				count++;
				macAddressTableCellArray[NO_POS] = Long.toString(count);
				macAddressTableCellArray[VENDOR_ID_POS] = macInfo.getOui();
				macAddressTableCellArray[VENDOR_INFO_POS] = macInfo
						.getVendorInfo();

				TableItem item = new TableItem(table, SWT.NULL);
				item.setText(macAddressTableCellArray);
				item.setData(macAddressTableCellArray);
			}
		}
	}

	private void searchVedorInfo() {
		String searchVendorInfo = vendorInfoSearchText.getText();

		/* e[ȗSč폜ătbV */
		table.removeAll();
		viewer.refresh();

		long count = 0;
		macInfoHashMap = MacAddressConfig.getInstance().getResourceFileParse()
				.getMacInfoHashMap();

		for (Iterator it = macInfoHashMap.keySet().iterator(); it.hasNext();) {
			String[] macAddressTableCellArray = new String[COLUMN_NO];
			String key = (String) it.next();
			MacAddressInfo macInfo = (MacAddressInfo) macInfoHashMap.get(key);
			int hitCount = macInfo.getVendorInfoUpperCase().indexOf(
					searchVendorInfo.toUpperCase());

			if (hitCount >= 0) {
				count++;
				macAddressTableCellArray[NO_POS] = Long.toString(count);
				macAddressTableCellArray[VENDOR_ID_POS] = macInfo.getOui();
				macAddressTableCellArray[VENDOR_INFO_POS] = macInfo
						.getVendorInfo();

				TableItem item = new TableItem(table, SWT.NULL);
				item.setText(macAddressTableCellArray);
				item.setData(macAddressTableCellArray);
			}
		}
	}

	private void setMacAddressTable() {
		/* e[ȗSč폜ătbV */
		table.removeAll();
		viewer.refresh();

		long count = 0;
		macInfoHashMap = MacAddressConfig.getInstance().getResourceFileParse()
				.getMacInfoHashMap();

		for (Iterator it = macInfoHashMap.keySet().iterator(); it.hasNext();) {
			String[] macAddressTableCellArray = new String[COLUMN_NO];
			String key = (String) it.next();
			MacAddressInfo macInfo = (MacAddressInfo) macInfoHashMap.get(key);
			count++;
			macAddressTableCellArray[NO_POS] = Long.toString(count);
			macAddressTableCellArray[VENDOR_ID_POS] = macInfo.getOui();
			macAddressTableCellArray[VENDOR_INFO_POS] = macInfo.getVendorInfo();

			TableItem item = new TableItem(table, SWT.NULL);
			item.setText(macAddressTableCellArray);
			item.setData(macAddressTableCellArray);
		}
	}

	/*
	 * J0iNo.j̕Ԃ܂B
	 * 
	 * @return J
	 */
	private int computeCol0Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN0_NO_RATIO);
	}

	/*
	 * J1iVendor IDj̕Ԃ܂B
	 * 
	 * @return J
	 */
	private int computeCol1Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN1_VENDOR_ID_RATIO);
	}

	/*
	 * J2iVendor Infoj̕Ԃ܂B
	 * 
	 * @return J
	 */
	private int computeCol2Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN2_VENDOR_INFO_RATIO);
	}

	/**
	 * Xe[^XC\Zbg܂B
	 * 
	 */
	protected void setStatusLine() {
		/* Xe[^XC\L */
		statusLineManager = (SubStatusLineManager) (getEditorSite()
				.getActionBars().getStatusLineManager());
		statusLineManager.setVisible(true);
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();

		/*
		 * InterfaceԂɍ킹ĕFZbgpColorIuWFNg CX^Xj
		 */
		if (textBackColor != null) {
			textBackColor.dispose();
		}

		if (table != null) {
			table.dispose();
		}
	}

	/**
	 * e[uColumn\[gNXpA\[g@\ MIBC^tF[X\e[u𐶐NX łB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	private final class SnmpInterfaceMibTable extends AbstractTableView {
		/* e[uColumn click\[gtO */
		private boolean isCol0Direction = false;

		private boolean isCol1Direction = false;

		private boolean isCol2Direction = false;

		private TableColumn col0;

		private TableColumn col1;

		private TableColumn col2;

		/*
		 * Interface MIB\e[u𐶐܂B
		 * 
		 */
		private Table createTable(Composite parent) {
			GridData data2 = new GridData();
			data2.horizontalAlignment = GridData.FILL;
			data2.verticalAlignment = GridData.FILL;
			data2.grabExcessHorizontalSpace = true;
			data2.grabExcessVerticalSpace = true;

			/* e[u */
			table = new Table(parent, SWT.H_SCROLL | SWT.V_SCROLL
					| SWT.FULL_SELECTION);
			table.setLinesVisible(true);
			table.setHeaderVisible(true);
			table.setLayoutData(data2);

			col0 = new TableColumn(table, SWT.CENTER);
			col0.setText(NO);
			col0.setWidth(computeCol0Width());

			col1 = new TableColumn(table, SWT.CENTER);
			col1.setText(VENDOR_ID);
			col1.setWidth(computeCol1Width());

			col2 = new TableColumn(table, SWT.CENTER);
			col2.setText(VENDOR_INFO);
			col2.setWidth(computeCol2Width());

			/*
			 * e[uړꍇ͂TCYꍇ̃Xi[łB
			 * 
			 */
			PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()
					.addControlListener(new ControlListener() {
						public void controlMoved(ControlEvent event) {
							// nothing
						}

						/*
						 * e[uTCYɃe[uJZbg܂B
						 */
						public void controlResized(ControlEvent event) {
							setResizedTableColumnWidth();
						}
					});

			col0.addListener(SWT.Selection, new Listener() {
				public void handleEvent(Event event) {
					/* J\[gA\[gێ */
					isCol0Direction = sortIntegerTable(table, 0,
							isCol0Direction);
				}
			});

			col1.addListener(SWT.Selection, new Listener() {
				public void handleEvent(Event event) {
					/* J\[gA\[gێ */
					isCol1Direction = sortTable(table, 1, isCol1Direction);
				}
			});
			col2.addListener(SWT.Selection, new Listener() {
				public void handleEvent(Event event) {
					/* J\[gA\[gێ */
					isCol2Direction = sortTable(table, 2, isCol2Direction);
				}
			});

			return table;
		}

		protected void setResizedTableColumnWidth() {
			/*
			 * e[u\Ԃł΃e[uJZbg
			 */
			if (getEditorSite().getPage().isPartVisible(
					getEditorSite().getPart())
					&& getEditorSite().getShell() != null) {
				if (getEditorSite().getShell().getSize() != null) {
					col0.setWidth(computeCol0Width());
					col1.setWidth(computeCol1Width());
					col2.setWidth(computeCol2Width());

				}
			}
		}

		/**
		 * X[p[NX̃e[uColumn Clickɂ\[g\bh
		 * I[o[ChāAe[uRowForegroundyBackground J[\[gɂĂێ܂B
		 * 
		 * @param table
		 *            Table
		 * @param item
		 *            TableItem
		 * @param strs
		 *            Table item
		 * @return TableItem
		 * @see netjfwatcher.common.view.AbstractTableView#setTableItem
		 *      (org.eclipse.swt.widgets.Table, org.eclipse.swt.widgets.
		 *      TableItem, java.lang.String[])
		 */
		protected TableItem setTableItem(Table table, TableItem item,
				String[] strs) {
			Object obj0 = item.getForeground();
			Object obj1 = item.getBackground();

			item.dispose();
			item = new TableItem(table, SWT.NONE);

			item.setText(strs);
			item.setData(strs);

			item.setForeground((Color) obj0);
			item.setBackground((Color) obj1);

			return item;
		}
	}
}
