/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.common.view;

import java.io.IOException;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public final class TableListViewColor {
    private static Logger logger;
    private Color alarmErrorLevelColor;
    private Color alarmWarningLevelColor;
    private Color alarmInfoLevelColor;
    private Color nodeListEvenForgroundColor;
    private Color nodeListEvenBackgroundColor;
    private Color nodeListOddForgroundColor;
    private Color nodeListOddBackgroundColor;
    private Color nodeListStatusForgroundColor;

    private TableListViewColor() {
        logger = Logger.getLogger(this.getClass().getName());
        this.updateAlarmListColor();
        this.updateNodeListColor();
    }

    public void updateAlarmListColor() {
        Color createColor;
        if (this.alarmErrorLevelColor != null) {
            this.alarmErrorLevelColor.dispose();
        }
        if (this.alarmWarningLevelColor != null) {
            this.alarmWarningLevelColor.dispose();
        }
        if (this.alarmInfoLevelColor != null) {
            this.alarmInfoLevelColor.dispose();
        }
        PreferenceStore colorPref = new PreferenceStore("view_color.pref");
        try {
            colorPref.load();
        }
        catch (IOException e1) {
            logger.warning(e1.getMessage());
        }
        String errorColorPref = colorPref.getString("alarm_error");
        String warningColorPref = colorPref.getString("alarm_warning");
        String infoColorPref = colorPref.getString("alarm_info");
        if (errorColorPref == null || errorColorPref.equals("")) {
            this.alarmErrorLevelColor = this.parseColor("255,0,0");
        } else {
            createColor = null;
            createColor = this.parseColor(errorColorPref);
            this.alarmErrorLevelColor = createColor == null ? Display.getCurrent().getSystemColor(3) : createColor;
        }
        if (warningColorPref == null || warningColorPref.equals("")) {
            this.alarmWarningLevelColor = this.parseColor("0,255,0");
        } else {
            createColor = null;
            createColor = this.parseColor(warningColorPref);
            this.alarmWarningLevelColor = createColor == null ? Display.getCurrent().getSystemColor(5) : createColor;
        }
        if (infoColorPref == null || infoColorPref.equals("")) {
            this.alarmInfoLevelColor = this.parseColor("0,0,0");
        } else {
            createColor = null;
            createColor = this.parseColor(infoColorPref);
            this.alarmInfoLevelColor = createColor == null ? Display.getCurrent().getSystemColor(2) : createColor;
        }
    }

    public void updateNodeListColor() {
        Color createColor;
        if (this.nodeListEvenForgroundColor != null) {
            this.nodeListEvenForgroundColor.dispose();
        }
        if (this.nodeListEvenBackgroundColor != null) {
            this.nodeListEvenBackgroundColor.dispose();
        }
        if (this.nodeListOddForgroundColor != null) {
            this.nodeListOddForgroundColor.dispose();
        }
        if (this.nodeListOddBackgroundColor != null) {
            this.nodeListOddBackgroundColor.dispose();
        }
        if (this.nodeListStatusForgroundColor != null) {
            this.nodeListStatusForgroundColor.dispose();
        }
        PreferenceStore colorPref = new PreferenceStore("view_color.pref");
        try {
            colorPref.load();
        }
        catch (IOException e1) {
            logger.warning(e1.getMessage());
        }
        String nodeListEvenForColorPref = colorPref.getString("node_list_even_number_foreground");
        String nodeListEvenBackColorPref = colorPref.getString("node_list_even_number_background");
        String nodeListOddForColorPref = colorPref.getString("node_list_odd_number_foreground");
        String nodeListOddBackColorPref = colorPref.getString("node_list_odd_number_background");
        String nodeListStatusForColorPref = colorPref.getString("node_list_status_forground");
        if (nodeListEvenForColorPref.equals("") || nodeListEvenForColorPref == null) {
            this.nodeListEvenForgroundColor = this.parseColor("0,0,0");
        } else {
            createColor = null;
            createColor = this.parseColor(nodeListEvenForColorPref);
            this.nodeListEvenForgroundColor = createColor == null ? Display.getCurrent().getSystemColor(2) : createColor;
        }
        if (nodeListEvenBackColorPref.equals("") || nodeListEvenBackColorPref == null) {
            this.nodeListEvenBackgroundColor = this.parseColor("128,255,255");
        } else {
            createColor = null;
            createColor = this.parseColor(nodeListEvenBackColorPref);
            this.nodeListEvenBackgroundColor = createColor == null ? Display.getCurrent().getSystemColor(1) : createColor;
        }
        if (nodeListOddForColorPref.equals("") || nodeListOddForColorPref == null) {
            this.nodeListOddForgroundColor = this.parseColor("0,0,0");
        } else {
            createColor = null;
            createColor = this.parseColor(nodeListOddForColorPref);
            this.nodeListOddForgroundColor = createColor == null ? Display.getCurrent().getSystemColor(2) : createColor;
        }
        if (nodeListOddBackColorPref.equals("") || nodeListOddBackColorPref == null) {
            this.nodeListOddBackgroundColor = this.parseColor("255,255,255");
        } else {
            createColor = null;
            createColor = this.parseColor(nodeListOddBackColorPref);
            this.nodeListOddBackgroundColor = createColor == null ? Display.getCurrent().getSystemColor(1) : createColor;
        }
        if (nodeListStatusForColorPref.equals("") || nodeListStatusForColorPref == null) {
            this.nodeListStatusForgroundColor = this.parseColor("255,128,64");
        } else {
            createColor = null;
            createColor = this.parseColor(nodeListStatusForColorPref);
            this.nodeListStatusForgroundColor = createColor == null ? Display.getCurrent().getSystemColor(3) : createColor;
        }
    }

    private Color parseColor(String str) {
        Color createColor = null;
        Pattern pattern = Pattern.compile(",");
        String[] itemRGB = pattern.split(str);
        if (itemRGB.length == 3) {
            try {
                int[] rgbData = new int[itemRGB.length];
                int j = 0;
                while (j < rgbData.length) {
                    rgbData[j] = Integer.parseInt(itemRGB[j]);
                    ++j;
                }
                createColor = new Color(null, rgbData[0], rgbData[1], rgbData[2]);
            }
            catch (NumberFormatException e) {
                logger.warning(String.valueOf(str) + " : " + e.getMessage());
            }
        } else {
            logger.warning("Illegal Color RGB Data : " + str);
        }
        return createColor;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.alarmErrorLevelColor != null) {
            this.alarmErrorLevelColor.dispose();
        }
        if (this.alarmWarningLevelColor != null) {
            this.alarmWarningLevelColor.dispose();
        }
        if (this.alarmInfoLevelColor != null) {
            this.alarmInfoLevelColor.dispose();
        }
        if (this.nodeListEvenForgroundColor != null) {
            this.nodeListEvenForgroundColor.dispose();
        }
        if (this.nodeListEvenBackgroundColor != null) {
            this.nodeListEvenBackgroundColor.dispose();
        }
        if (this.nodeListOddForgroundColor != null) {
            this.nodeListOddForgroundColor.dispose();
        }
        if (this.nodeListOddBackgroundColor != null) {
            this.nodeListOddBackgroundColor.dispose();
        }
        if (this.nodeListStatusForgroundColor != null) {
            this.nodeListStatusForgroundColor.dispose();
        }
    }

    public static TableListViewColor getInstance() {
        return SingletonResource.RESOURCE;
    }

    public Color getAlarmErrorLevelColor() {
        return this.alarmErrorLevelColor;
    }

    public Color getAlarmInfoLevelColor() {
        return this.alarmInfoLevelColor;
    }

    public Color getAlarmWarningLevelColor() {
        return this.alarmWarningLevelColor;
    }

    public Color getNodeListEvenBackgroundColor() {
        return this.nodeListEvenBackgroundColor;
    }

    public Color getNodeListEvenForgroundColor() {
        return this.nodeListEvenForgroundColor;
    }

    public Color getNodeListOddBackgroundColor() {
        return this.nodeListOddBackgroundColor;
    }

    public Color getNodeListOddForgroundColor() {
        return this.nodeListOddForgroundColor;
    }

    public Color getNodeListStatusForgroundColor() {
        return this.nodeListStatusForgroundColor;
    }

    /* synthetic */ TableListViewColor(TableListViewColor tableListViewColor) {
        this();
    }

    private static class SingletonResource {
        static final TableListViewColor RESOURCE = new TableListViewColor(null);

        private SingletonResource() {
        }
    }
}

