/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.database.access.control;

import java.sql.SQLException;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.database.access.control.DatabaseAccessPool;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.control.DatabaseConnectionPool;
import netjfwatcher.database.access.model.ApacheDerbyDatabaseInit;
import netjfwatcher.database.access.model.DBTableAlarm;
import netjfwatcher.database.access.model.DBTableAlarmFilter;
import netjfwatcher.database.access.model.DBTableDatabaseWatcher;
import netjfwatcher.database.access.model.DBTableGarbageCollection;
import netjfwatcher.database.access.model.DBTableManagement;
import netjfwatcher.database.access.model.DBTableMapLink;
import netjfwatcher.database.access.model.DBTableNetworkCamera;
import netjfwatcher.database.access.model.DBTableNodeRegister;
import netjfwatcher.database.access.model.DBTableTaskSchedule;
import netjfwatcher.database.access.model.MySQLDatabaseInit;
import netjfwatcher.database.access.model.PostgreSQLDatabaseInit;

public class ConstructDatabase {
    private static Logger logger = null;

    public ConstructDatabase() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public final void createPool() {
        DatabaseConnectionPool.getInstance().createConnectionPool();
        DatabaseAccessPool.getInstance().setDatabaseAccessQueueList();
    }

    public final void createTable() {
        try {
            DBTableGarbageCollection garbageCollection = DBTableGarbageCollection.getInstance();
            garbageCollection.createTable();
            DBTableNodeRegister noderegister = DBTableNodeRegister.getInstance();
            noderegister.createTable();
            DBTableAlarm alarmTable = DBTableAlarm.getInstance();
            alarmTable.createTable();
            DBTableAlarmFilter alarmFilterTable = new DBTableAlarmFilter();
            alarmFilterTable.createTable();
            alarmFilterTable.putAlarmFilter();
            DBTableTaskSchedule taskScheduleTable = DBTableTaskSchedule.getInstance();
            taskScheduleTable.createTable();
            DBTableMapLink mapLinkTable = new DBTableMapLink();
            mapLinkTable.createTable();
            DBTableManagement tableManagement = new DBTableManagement();
            tableManagement.createTable();
            DBTableDatabaseWatcher.getInstance().createTable();
            DBTableNetworkCamera.getInstance().createTable();
        }
        catch (DatabaseConnectionException e) {
            e.printStackTrace();
            logger.severe(e.getMessage());
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.severe(e.getMessage());
        }
    }

    public final void createDatabase() {
        try {
            if (DatabaseAccessControlKind.getInstance().getDatabaseName().equals("MySQL")) {
                MySQLDatabaseInit mysqlInit = new MySQLDatabaseInit();
                mysqlInit.createDatabase();
            } else if (DatabaseAccessControlKind.getInstance().getDatabaseName().equals("Postgresql")) {
                PostgreSQLDatabaseInit.getInstance().createDatabase();
            } else if (DatabaseAccessControlKind.getInstance().getDatabaseName().equals("Apache Derby") || DatabaseAccessControlKind.getInstance().getDatabaseName().equals("Embedded Derby")) {
                ApacheDerbyDatabaseInit apacheDerby = new ApacheDerbyDatabaseInit();
                apacheDerby.createDatabase();
            }
        }
        catch (SQLException e1) {
            logger.warning("SQLException " + e1.getMessage());
        }
        catch (Exception e1) {
            logger.warning("Exception " + e1.getMessage());
            e1.printStackTrace();
        }
    }
}

