/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.database.access.control;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.control.DatabaseConnectionPool;

public class DatabaseAccess {
    private static final int CONNECTION_TRY_COUNT = 30;

    protected DatabaseAccess() {
    }

    public synchronized void executeUpdate(String sqlString) throws DatabaseConnectionException, SQLException {
        Connection connection = null;
        Statement statement = null;
        try {
            try {
                connection = this.getConnection();
                statement = connection.createStatement();
                statement.execute(sqlString);
                if (DatabaseAccessControlKind.getInstance().getDatabaseName().equals("Apache Derby") || DatabaseAccessControlKind.getInstance().getDatabaseName().equals("Embedded Derby")) {
                    connection.commit();
                } else {
                    statement.execute("commit");
                }
            }
            catch (DatabaseConnectionException e1) {
                e1.printStackTrace();
                throw e1;
            }
            catch (SQLException e) {
                if (connection != null) {
                    this.releaseConnection(connection);
                    connection = null;
                }
                throw e;
            }
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                    throw e2;
                }
            }
            if (connection != null) {
                this.releaseConnection(connection);
                connection = null;
            }
        }
    }

    public synchronized Connection getConnection() throws DatabaseConnectionException {
        Connection connection = DatabaseConnectionPool.getInstance().getConnection(30);
        if (connection == null) {
            throw new DatabaseConnectionException("Can't get DB Connection");
        }
        return connection;
    }

    public synchronized void releaseConnection(Connection connection) {
        if (connection != null) {
            DatabaseConnectionPool.getInstance().releaseConnection(connection);
        }
    }
}

