/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.database.access.model;

import java.sql.SQLException;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.DatabaseAccess;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.database.access.control.DatabaseConnectionException;

public class DBTableBase {
    public static final String IP = "IP";
    private static Logger logger;

    public DBTableBase() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void dropSequence(DatabaseAccess databaseAccess, String tableSequence) throws DatabaseConnectionException {
        if (DatabaseAccessControlKind.getInstance().getDatabaseName().equals("Postgresql")) {
            try {
                databaseAccess.executeUpdate(tableSequence);
            }
            catch (SQLException e) {
                logger.info(String.valueOf(DatabaseAccessControlKind.getInstance().getDatabaseName()) + " : " + e.getMessage());
            }
        }
    }

    public void deleteTable(DatabaseAccess databaseAccess, String deleteTableName) throws DatabaseConnectionException, SQLException {
        if (DatabaseAccessControlKind.getInstance().getDatabaseName().equals("Postgresql")) {
            try {
                databaseAccess.executeUpdate("DROP TABLE " + deleteTableName);
            }
            catch (SQLException e) {
                logger.info(String.valueOf(DatabaseAccessControlKind.getInstance().getDatabaseName()) + " : " + e.getMessage());
            }
        } else if (DatabaseAccessControlKind.getInstance().getDatabaseName().equals("Apache Derby") || DatabaseAccessControlKind.getInstance().getDatabaseName().equals("Embedded Derby")) {
            try {
                databaseAccess.executeUpdate("DROP TABLE " + deleteTableName);
            }
            catch (SQLException e) {
                logger.info(String.valueOf(DatabaseAccessControlKind.getInstance().getDatabaseName()) + " : " + e.getMessage());
            }
        } else {
            databaseAccess.executeUpdate("DROP TABLE IF EXISTS " + deleteTableName);
        }
    }
}

