/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.database.access.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DatabaseAccess;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.database.access.control.DatabaseAccessPool;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableAlarm;
import netjfwatcher.database.access.model.DBTableBase;
import netjfwatcher.database.access.model.DBTableDatabaseWatcher;
import netjfwatcher.engine.socket.info.AlarmInformation;
import netjfwatcher.engine.socket.info.DatabaseWatcherInfo;
import netjfwatcher.engine.socket.info.NodeInformation;

public final class DBTableNodeRegister
extends DBTableBase {
    public static final String NODE_REGISTER_TABLE = "noderegister";
    public static final String NODENAME = "nodename";
    public static final String IPADDRESS = "ipaddress";
    public static final String NODEGROUP = "nodegroup";
    public static final String NODEX = "nodeX";
    public static final String NODEY = "nodeY";
    public static final String NODEKIND = "nodeKind";
    public static final String PING_PERIOD = "ping_period";
    public static final String PING_THRESHOLD = "ping_threshold";
    public static final String SNMP_VERSION = "snmpVersion";
    public static final String SNMP_PERIOD = "snmp_period";
    public static final String SNMPTIMEOUT = "snmp_timeout";
    public static final String SNMP_LEVEL = "snmp_level";
    public static final String SNMP_ROCOMMUNITY = "community";
    public static final String SNMP_RWCOMMUNITY = "RWCommunity";
    public static final String HTTP_URL = "http_url";
    public static final String HTTP_PERIOD = "http_period";
    public static final String HTTP_PORT = "http_port";
    public static final String HTTP_TIMEOUT = "http_timeout";
    public static final String POP3_PERIOD = "pop3_period";
    public static final String POP3_USER = "pop3_user";
    public static final String POP3_PASSWORD = "pop3_password";
    public static final String POP3_PORT = "pop3_port";
    public static final String POP3_TIMEOUT = "pop3_timeout";
    public static final String SMTP_PERIOD = "smtp_period";
    public static final String SMTP_PORT = "smtp_port";
    public static final String SMTP_TIMEOUT = "smtp_timeout";
    public static final String SMTP_TEST_ADDRESS = "smtp_test_address";
    public static final String SMTP_CHECK_POP_HOST = "smtp_check_pop_host";
    public static final String SMTP_CHECK_POP_USER = "smtp_check_pop_user";
    public static final String SMTP_CHECK_POP_PASSWORD = "smtp_check_pop_password";
    public static final String SMTP_CHECK_POP_PORT = "smtp_check_pop_port";
    public static final String SMTP_CHECK_POP_TIMEOUT = "smtp_check_pop_timeout";
    public static final String ENGINE_ADDRESS = "engine_Address";
    public static final String LAST_CHECK = "last_check";
    public static final String REGISTER_DATE = "register_date";
    private static Logger logger = null;
    private final DateFormat simpleDateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private DBTableNodeRegister() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public static DBTableNodeRegister getInstance() {
        return SingletonResource.RESOURCE;
    }

    public synchronized void createTable() throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            AbstractDataAccessObject dataaccessobject = DatabaseAccessControlKind.getInstance().getDataAccessObject();
            this.deleteTable(databaseAccess, NODE_REGISTER_TABLE);
            databaseAccess.executeUpdate(dataaccessobject.getCreateNoderegisterTable());
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    public synchronized void dropTable() throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            this.deleteTable(databaseAccess, NODE_REGISTER_TABLE);
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    public synchronized boolean registerNode(NodeInformation registerNodeInfo) throws SQLException, DatabaseConnectionException {
        NodeInformation nodeInfo = this.checkNodeInfo(registerNodeInfo);
        boolean isSuccess = false;
        DatabaseAccess dataaccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            Date date = Calendar.getInstance().getTime();
            String sql = "INSERT INTO noderegister( nodename, ipaddress, nodegroup, nodeX, nodeY, nodeKind, ping_period, ping_threshold, snmpVersion, snmp_period, snmp_level, community, RWCommunity, http_url, http_period, http_port, http_timeout, pop3_period, pop3_user, pop3_password, pop3_port, pop3_timeout, smtp_period, smtp_port, smtp_timeout, smtp_test_address, smtp_check_pop_host, smtp_check_pop_user, smtp_check_pop_password, smtp_check_pop_port, smtp_check_pop_timeout, engine_Address, register_date )VALUES ( '" + nodeInfo.getNodename() + "','" + nodeInfo.getIpaddress() + "','" + nodeInfo.getGroup() + "','" + nodeInfo.getNodeX() + "','" + nodeInfo.getNodeY() + "','" + nodeInfo.getNodeKind() + "','" + nodeInfo.getPingPeriod() + "','" + nodeInfo.getPingThreshold() + "','" + nodeInfo.getSnmpVersion() + "','" + nodeInfo.getSnmpPeriod() + "','" + nodeInfo.getSnmpLevel() + "','" + nodeInfo.getRoCommunity() + "','" + nodeInfo.getRwCommunity() + "','" + nodeInfo.getHttpUrl() + "','" + nodeInfo.getHttpPeriod() + "','" + nodeInfo.getHttpPort() + "','" + nodeInfo.getHttpTimeout() + "','" + nodeInfo.getPopPeriod() + "','" + nodeInfo.getPopUser() + "','" + nodeInfo.getPopPassword() + "','" + nodeInfo.getPopPort() + "','" + nodeInfo.getPopTimeout() + "','" + nodeInfo.getSmtpPeriod() + "','" + nodeInfo.getSmtpPort() + "','" + nodeInfo.getSmtpTimeout() + "','" + nodeInfo.getSmtpSendAddress() + "','" + nodeInfo.getSmtpCheckHost() + "','" + nodeInfo.getSmtpCheckUser() + "','" + nodeInfo.getSmtpCheckPassword() + "','" + nodeInfo.getSmtpCheckPort() + "','" + nodeInfo.getSmtpCheckTimeout() + "','" + nodeInfo.getEngineAddress() + "','" + this.simpleDateformat.format(date) + "' )";
            dataaccess.executeUpdate(sql);
            isSuccess = true;
        }
        finally {
            if (dataaccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
            }
        }
        return isSuccess;
    }

    public synchronized boolean updateNode(NodeInformation updateNodeInfo) throws SQLException, DatabaseConnectionException {
        NodeInformation nodeInfo = this.checkNodeInfo(updateNodeInfo);
        boolean isSuccess = false;
        DatabaseAccess dataaccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            Date date = Calendar.getInstance().getTime();
            String sql = "UPDATE noderegister set nodename='" + nodeInfo.getNodename() + "', " + IPADDRESS + "='" + nodeInfo.getIpaddress() + "', " + NODEGROUP + "='" + nodeInfo.getGroup() + "', " + NODEX + "= " + "'" + nodeInfo.getNodeX() + "', " + NODEY + "= " + "'" + nodeInfo.getNodeY() + "', " + NODEKIND + "='" + nodeInfo.getNodeKind() + "', " + PING_PERIOD + "='" + nodeInfo.getPingPeriod() + "', " + PING_THRESHOLD + "='" + nodeInfo.getPingThreshold() + "', " + SNMP_VERSION + "='" + nodeInfo.getSnmpVersion() + "', " + SNMP_PERIOD + "='" + nodeInfo.getSnmpPeriod() + "', " + SNMP_LEVEL + "='" + nodeInfo.getSnmpLevel() + "', " + SNMPTIMEOUT + "= " + "'" + nodeInfo.getSnmpTimeout() + "', " + SNMP_ROCOMMUNITY + "='" + nodeInfo.getRoCommunity() + "', " + SNMP_RWCOMMUNITY + "='" + nodeInfo.getRwCommunity() + "', " + HTTP_URL + "='" + nodeInfo.getHttpUrl() + "', " + HTTP_PERIOD + "='" + nodeInfo.getHttpPeriod() + "', " + HTTP_PORT + "= " + "'" + nodeInfo.getHttpPort() + "', " + HTTP_TIMEOUT + "= " + "'" + nodeInfo.getHttpTimeout() + "', " + POP3_PERIOD + "='" + nodeInfo.getPopPeriod() + "', " + POP3_USER + "='" + nodeInfo.getPopUser() + "', " + POP3_PASSWORD + "='" + nodeInfo.getPopPassword() + "', " + POP3_PORT + "='" + nodeInfo.getPopPort() + "', " + POP3_TIMEOUT + "='" + nodeInfo.getPopTimeout() + "', " + SMTP_PERIOD + "='" + nodeInfo.getSmtpPeriod() + "', " + SMTP_PORT + "='" + nodeInfo.getSmtpPort() + "', " + SMTP_TIMEOUT + "='" + nodeInfo.getSmtpTimeout() + "', " + SMTP_TEST_ADDRESS + "='" + nodeInfo.getSmtpSendAddress() + "', " + SMTP_CHECK_POP_HOST + "='" + nodeInfo.getSmtpCheckHost() + "', " + SMTP_CHECK_POP_USER + "='" + nodeInfo.getSmtpCheckUser() + "', " + SMTP_CHECK_POP_PASSWORD + "='" + nodeInfo.getSmtpCheckPassword() + "', " + SMTP_CHECK_POP_PORT + "='" + nodeInfo.getSmtpCheckPort() + "', " + SMTP_CHECK_POP_TIMEOUT + "='" + nodeInfo.getSmtpCheckTimeout() + "', " + ENGINE_ADDRESS + "= " + "'" + nodeInfo.getEngineAddress() + "', " + REGISTER_DATE + "='" + this.simpleDateformat.format(date) + "' " + " where " + IPADDRESS + "='" + nodeInfo.getIpaddress() + "'";
            dataaccess.executeUpdate(sql);
            isSuccess = true;
        }
        finally {
            if (dataaccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
            }
        }
        return isSuccess;
    }

    public synchronized NodeInformation checkNodeInfo(NodeInformation nodeInfo) {
        if (nodeInfo.getNodename() == null || nodeInfo.getNodename().equals("null")) {
            nodeInfo.setNodename("");
        }
        if (nodeInfo.getIpaddress() == null || nodeInfo.getIpaddress().equals("null")) {
            nodeInfo.setIpaddress("");
        }
        if (nodeInfo.getGroup() == null || nodeInfo.getGroup().equals("null")) {
            nodeInfo.setGroup("");
        }
        if (nodeInfo.getNodeX() == null || nodeInfo.getNodeX().equals("null")) {
            nodeInfo.setNodeX("");
        }
        if (nodeInfo.getNodeY() == null || nodeInfo.getNodeY().equals("null")) {
            nodeInfo.setNodeY("");
        }
        if (nodeInfo.getNodeKind() == null || nodeInfo.getNodeKind().equals("null")) {
            nodeInfo.setNodeKind("");
        }
        if (nodeInfo.getNodeKind() == null || nodeInfo.getNodeKind().equals("null")) {
            nodeInfo.setNodeKind("");
        }
        if (nodeInfo.getPingPeriod() == null || nodeInfo.getPingPeriod().equals("null")) {
            nodeInfo.setPingPeriod("0");
        }
        if (nodeInfo.getPingThreshold() == null || nodeInfo.getPingThreshold().equals("null")) {
            nodeInfo.setPingThreshold("0");
        }
        if (nodeInfo.getSnmpVersion() == null || nodeInfo.getSnmpVersion().equals("null")) {
            nodeInfo.setSnmpVersion("SNMPV1");
        }
        if (nodeInfo.getSnmpPeriod() == null || nodeInfo.getSnmpPeriod().equals("null")) {
            nodeInfo.setSnmpPeriod("0");
        }
        if (nodeInfo.getSnmpLevel() == null || nodeInfo.getSnmpLevel().equals("null")) {
            nodeInfo.setSnmpLevel("0");
        }
        if (nodeInfo.getSnmpTimeout() == null || nodeInfo.getSnmpTimeout().equals("null")) {
            nodeInfo.setSnmpTimeout("");
        }
        if (nodeInfo.getRoCommunity() == null || nodeInfo.getRoCommunity().equals("null")) {
            nodeInfo.setRoCommunity("");
        }
        if (nodeInfo.getRwCommunity() == null || nodeInfo.getRwCommunity().equals("null")) {
            nodeInfo.setRwCommunity("");
        }
        if (nodeInfo.getHttpUrl() == null || nodeInfo.getHttpUrl().equals("null")) {
            nodeInfo.setHttpUrl("");
        }
        if (nodeInfo.getHttpPeriod() == null || nodeInfo.getHttpPeriod().equals("null")) {
            nodeInfo.setHttpPeriod("0");
        }
        if (nodeInfo.getHttpTimeout() == null || nodeInfo.getHttpTimeout().equals("null")) {
            nodeInfo.setHttpTimeout("");
        }
        if (nodeInfo.getHttpPort() == null || nodeInfo.getHttpPort().equals("null")) {
            nodeInfo.setHttpPort("");
        }
        if (nodeInfo.getPopPeriod() == null || nodeInfo.getPopPeriod().equals("null")) {
            nodeInfo.setPopPeriod("0");
        }
        if (nodeInfo.getPopUser() == null || nodeInfo.getPopUser().equals("null")) {
            nodeInfo.setPopUser("");
        }
        if (nodeInfo.getPopPassword() == null || nodeInfo.getPopPassword().equals("null")) {
            nodeInfo.setPopPassword("");
        }
        if (nodeInfo.getPopPort() == null || nodeInfo.getPopPort().equals("null")) {
            nodeInfo.setPopPort("");
        }
        if (nodeInfo.getPopTimeout() == null || nodeInfo.getPopTimeout().equals("null")) {
            nodeInfo.setPopTimeout("");
        }
        if (nodeInfo.getSmtpPeriod() == null || nodeInfo.getSmtpPeriod().equals("null")) {
            nodeInfo.setSmtpPeriod("0");
        }
        if (nodeInfo.getSmtpPort() == null || nodeInfo.getSmtpPort().equals("null")) {
            nodeInfo.setSmtpPort("");
        }
        if (nodeInfo.getSmtpTimeout() == null || nodeInfo.getSmtpTimeout().equals("null")) {
            nodeInfo.setSmtpTimeout("");
        }
        if (nodeInfo.getSmtpSendAddress() == null || nodeInfo.getSmtpSendAddress().equals("null")) {
            nodeInfo.setSmtpSendAddress("");
        }
        if (nodeInfo.getSmtpCheckHost() == null || nodeInfo.getSmtpCheckHost().equals("null")) {
            nodeInfo.setSmtpCheckHost("");
        }
        if (nodeInfo.getSmtpCheckUser() == null || nodeInfo.getSmtpCheckUser().equals("null")) {
            nodeInfo.setSmtpCheckUser("");
        }
        if (nodeInfo.getSmtpCheckPassword() == null || nodeInfo.getSmtpCheckPassword().equals("null")) {
            nodeInfo.setSmtpCheckPassword("");
        }
        if (nodeInfo.getSmtpCheckPort() == null || nodeInfo.getSmtpCheckPort().equals("null")) {
            nodeInfo.setSmtpCheckPort("");
        }
        if (nodeInfo.getSmtpCheckTimeout() == null || nodeInfo.getSmtpCheckTimeout().equals("null")) {
            nodeInfo.setSmtpCheckTimeout("");
        }
        return nodeInfo;
    }

    public synchronized void upDateLastCheck(String ipaddress) throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        Date date = Calendar.getInstance().getTime();
        String sql = "UPDATE noderegister set last_check= '" + this.simpleDateformat.format(date) + "'" + " where " + IPADDRESS + "= " + "'" + ipaddress + "'";
        try {
            try {
                databaseAccess.executeUpdate(sql);
            }
            catch (DatabaseConnectionException e) {
                logger.warning(e.getMessage());
                throw e;
            }
            catch (SQLException e) {
                logger.warning(e.getMessage());
                throw e;
            }
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    public synchronized ArrayList getNodeInfoList(String sortColumn, String sortDirection) throws SQLException, DatabaseConnectionException {
        String sqlext = "";
        if (sortColumn != null && sortDirection != null) {
            sqlext = " order by " + sortColumn + " " + sortDirection;
        }
        ArrayList nodeList = null;
        nodeList = this.getNodeList(sqlext);
        return nodeList;
    }

    public synchronized ArrayList getNodeInfoList(String sortColumn, String sortDirection, String sortColumn2, String sortDirection2) throws SQLException, DatabaseConnectionException {
        String sqlext = "";
        if (sortColumn != null && sortColumn2 != null) {
            sqlext = " order by " + sortColumn + " " + sortDirection + " , " + sortColumn2 + " " + sortDirection2;
        }
        ArrayList nodeList = null;
        nodeList = this.getNodeList(sqlext);
        return nodeList;
    }

    private ArrayList getNodeList(String sqlext) throws SQLException, DatabaseConnectionException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<NodeInformation> nodeList = null;
        DatabaseAccess dataaccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        DBTableAlarm alarmDBTable = DBTableAlarm.getInstance();
        try {
            String sql = "SELECT * from noderegister" + sqlext;
            conn = dataaccess.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            nodeList = new ArrayList<NodeInformation>();
            int nodeCount = 0;
            while (rs.next()) {
                NodeInformation nodeInformation = new NodeInformation();
                if (nodeCount % 2 == 0) {
                    nodeInformation.setNumberEvenOdd("Even");
                } else {
                    nodeInformation.setNumberEvenOdd("Odd");
                }
                nodeInformation.setNodeNumber(Integer.toString(nodeCount));
                ++nodeCount;
                String ipAddress = rs.getObject(IPADDRESS).toString();
                nodeInformation.setNodename(rs.getObject(NODENAME).toString());
                nodeInformation.setIpaddress(ipAddress);
                nodeInformation.setGroup(rs.getObject(NODEGROUP).toString());
                String nodeX = (String)rs.getObject(NODEX);
                if (nodeX == null || nodeX.equals("null") || nodeX.equals("0") || nodeX.equals("")) {
                    nodeX = Integer.toString(50 + 60 * nodeCount);
                }
                nodeInformation.setNodeX(nodeX);
                String nodeY = (String)rs.getObject(NODEY);
                if (nodeY == null || nodeY.equals("null") || nodeY.equals("0") || nodeY.equals("")) {
                    nodeY = Integer.toString(50 + 40 * nodeCount);
                }
                nodeInformation.setNodeY(nodeY);
                String nodeKind = (String)rs.getObject(NODEKIND);
                if (nodeKind == null || nodeKind.equals("")) {
                    nodeKind = "unkonown";
                }
                nodeInformation.setNodeKind(nodeKind);
                nodeInformation.setPingThreshold(rs.getObject(PING_THRESHOLD).toString());
                nodeInformation.setSnmpVersion(rs.getObject(SNMP_VERSION).toString());
                nodeInformation.setSnmpLevel(rs.getObject(SNMP_LEVEL).toString());
                nodeInformation.setRoCommunity(rs.getObject(SNMP_ROCOMMUNITY).toString());
                nodeInformation.setRwCommunity(rs.getObject(SNMP_RWCOMMUNITY).toString());
                if (rs.getObject(REGISTER_DATE) == null) {
                    logger.warning("REGISTER_DATE null");
                } else {
                    String optimeString = this.convRegisterDate((Date)rs.getObject(REGISTER_DATE));
                    nodeInformation.setRegisterDate(String.valueOf(rs.getObject(REGISTER_DATE).toString()) + optimeString);
                }
                String pingPeriod = (String)rs.getObject(PING_PERIOD);
                if (pingPeriod == null || pingPeriod.equals("") || pingPeriod.equals("0")) {
                    pingPeriod = "--";
                }
                nodeInformation.setPingPeriod(pingPeriod);
                String snmpPeriod = (String)rs.getObject(SNMP_PERIOD);
                if (snmpPeriod == null || snmpPeriod.equals("") || snmpPeriod.equals("0")) {
                    snmpPeriod = "--";
                }
                nodeInformation.setSnmpPeriod(snmpPeriod);
                String httpPeriod = (String)rs.getObject(HTTP_PERIOD);
                if (httpPeriod == null || httpPeriod.equals("") || httpPeriod.equals("0")) {
                    httpPeriod = "--";
                }
                nodeInformation.setHttpPeriod(httpPeriod);
                String httpUrl = (String)rs.getObject(HTTP_URL);
                if (httpUrl == null || httpUrl.equals("")) {
                    httpUrl = "http://";
                }
                nodeInformation.setHttpUrl(httpUrl);
                String httpPort = (String)rs.getObject(HTTP_PORT);
                nodeInformation.setHttpPort(httpPort);
                String httpTimeout = (String)rs.getObject(HTTP_TIMEOUT);
                if (httpTimeout == null || httpTimeout.equals("")) {
                    httpTimeout = "0";
                }
                nodeInformation.setHttpTimeout(httpTimeout);
                String smtpPeriod = (String)rs.getObject(SMTP_PERIOD);
                if (smtpPeriod == null || smtpPeriod.equals("") || smtpPeriod.equals("0")) {
                    smtpPeriod = "--";
                }
                nodeInformation.setSmtpPeriod(smtpPeriod);
                String smtpPort = (String)rs.getObject(SMTP_PORT);
                if (smtpPort == null || smtpPort.equals("")) {
                    smtpPort = "0";
                }
                nodeInformation.setSmtpPort(smtpPort);
                String smtpTimeout = (String)rs.getObject(SMTP_TIMEOUT);
                if (smtpTimeout == null || smtpTimeout.equals("")) {
                    smtpTimeout = "0";
                }
                nodeInformation.setSmtpTimeout(smtpTimeout);
                String smtpTestAddress = (String)rs.getObject(SMTP_TEST_ADDRESS);
                if (smtpTestAddress == null) {
                    smtpTestAddress = "";
                }
                nodeInformation.setSmtpSendAddress(smtpTestAddress);
                String smtpHost = (String)rs.getObject(SMTP_CHECK_POP_HOST);
                if (smtpHost == null) {
                    smtpHost = "";
                }
                nodeInformation.setSmtpCheckHost(smtpHost);
                String smtpUser = (String)rs.getObject(SMTP_CHECK_POP_USER);
                if (smtpUser == null) {
                    smtpUser = "";
                }
                nodeInformation.setSmtpCheckUser(smtpUser);
                String smtpPassword = (String)rs.getObject(SMTP_CHECK_POP_PASSWORD);
                if (smtpPassword == null) {
                    smtpPassword = "";
                }
                nodeInformation.setSmtpCheckPassword(smtpPassword);
                String smtpPopPort = (String)rs.getObject(SMTP_CHECK_POP_PORT);
                if (smtpPopPort == null) {
                    smtpPopPort = "0";
                }
                nodeInformation.setSmtpCheckPort(smtpPopPort);
                String smtpPopTimeout = (String)rs.getObject(SMTP_CHECK_POP_TIMEOUT);
                if (smtpPopTimeout == null) {
                    smtpPopTimeout = "0";
                }
                nodeInformation.setSmtpCheckTimeout(smtpPopTimeout);
                String popPeriod = (String)rs.getObject(POP3_PERIOD);
                if (popPeriod == null || popPeriod.equals("") || popPeriod.equals("0")) {
                    popPeriod = "--";
                }
                nodeInformation.setPopPeriod(popPeriod);
                String popUser = (String)rs.getObject(POP3_USER);
                if (popUser == null) {
                    popUser = "";
                }
                nodeInformation.setPopUser(popUser);
                String popPassword = (String)rs.getObject(POP3_PASSWORD);
                if (popPassword == null) {
                    popPassword = "";
                }
                nodeInformation.setPopPassword(popPassword);
                String popPort = (String)rs.getObject(POP3_PORT);
                if (popPort == null || popPort.equals("")) {
                    popPort = "110";
                }
                nodeInformation.setPopPort(popPort);
                String popTimeout = (String)rs.getObject(POP3_TIMEOUT);
                if (popTimeout == null || popTimeout.equals("")) {
                    popTimeout = "0";
                }
                nodeInformation.setPopTimeout(popTimeout);
                if (rs.getObject(LAST_CHECK) != null) {
                    nodeInformation.setLastCheck(rs.getObject(LAST_CHECK).toString());
                }
                if (rs.getObject(ENGINE_ADDRESS) != null) {
                    nodeInformation.setEngineAddress(rs.getObject(ENGINE_ADDRESS).toString());
                } else {
                    nodeInformation.setEngineAddress("unknown");
                }
                nodeInformation.setConvIPAddress(ipAddress.replace('.', '_'));
                ArrayList alarmList = null;
                alarmList = alarmDBTable.getNodeAlarm(ipAddress);
                if (alarmList.size() > 0) {
                    AlarmInformation alarmInfo = (AlarmInformation)alarmList.get(0);
                    logger.info("Alarm message : " + alarmInfo.getAlarmMessage());
                    nodeInformation.setAlarmCode(alarmInfo.getAlarmCode());
                    nodeInformation.setAlarmMessage(alarmInfo.getAlarmMessage());
                    nodeInformation.setAlarmDate(alarmInfo.getAlarmDate());
                    nodeInformation.setAlarmLevel(alarmInfo.getAlarmLevel());
                }
                DatabaseWatcherInfo databaseInfo = DBTableDatabaseWatcher.getInstance().findDatabaseWatcher(ipAddress);
                nodeInformation.setDatabaseWatcherInfo(databaseInfo);
                nodeList.add(nodeInformation);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                stmt = null;
            }
            if (conn != null && dataaccess != null) {
                dataaccess.releaseConnection(conn);
                conn = null;
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
            }
            dataaccess = null;
            alarmDBTable = null;
        }
        return nodeList;
    }

    public synchronized ArrayList findTarget(String ipaddress) throws SQLException, DatabaseConnectionException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        DatabaseAccess dataaccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        DBTableAlarm alarmDBTable = DBTableAlarm.getInstance();
        ArrayList<NodeInformation> nodeList = null;
        try {
            String sql = "SELECT * from noderegister where ipaddress='" + ipaddress + "'";
            conn = dataaccess.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            nodeList = new ArrayList<NodeInformation>();
            while (rs.next()) {
                NodeInformation nodeInformation = new NodeInformation();
                if (rs.getObject(NODENAME) != null) {
                    nodeInformation.setNodename(rs.getObject(NODENAME).toString());
                }
                if (rs.getObject(IPADDRESS) != null) {
                    nodeInformation.setIpaddress(rs.getObject(IPADDRESS).toString());
                }
                if (rs.getObject(NODEGROUP) != null) {
                    nodeInformation.setGroup(rs.getObject(NODEGROUP).toString());
                }
                if (rs.getObject(NODEKIND) != null) {
                    nodeInformation.setNodeKind(rs.getObject(NODEKIND).toString());
                }
                if (rs.getObject(NODEX) != null) {
                    nodeInformation.setNodeX(rs.getObject(NODEX).toString());
                }
                if (rs.getObject(NODEY) != null) {
                    nodeInformation.setNodeY(rs.getObject(NODEY).toString());
                }
                if (rs.getObject(PING_PERIOD) != null) {
                    nodeInformation.setPingPeriod(rs.getObject(PING_PERIOD).toString());
                }
                if (rs.getObject(PING_THRESHOLD) != null) {
                    nodeInformation.setPingThreshold(rs.getObject(PING_THRESHOLD).toString());
                }
                if (rs.getObject(SNMP_VERSION) != null) {
                    nodeInformation.setSnmpVersion(rs.getObject(SNMP_VERSION).toString());
                }
                if (rs.getObject(SNMP_PERIOD) != null) {
                    nodeInformation.setSnmpPeriod(rs.getObject(SNMP_PERIOD).toString());
                }
                if (rs.getObject(SNMP_LEVEL) != null) {
                    nodeInformation.setSnmpLevel(rs.getObject(SNMP_LEVEL).toString());
                }
                if (rs.getObject(SNMP_ROCOMMUNITY) != null) {
                    nodeInformation.setRoCommunity(rs.getObject(SNMP_ROCOMMUNITY).toString());
                }
                if (rs.getObject(SNMP_RWCOMMUNITY) != null) {
                    nodeInformation.setRwCommunity(rs.getObject(SNMP_RWCOMMUNITY).toString());
                }
                if (rs.getObject(HTTP_URL) != null) {
                    nodeInformation.setHttpUrl(rs.getObject(HTTP_URL).toString());
                }
                if (rs.getObject(HTTP_PERIOD) != null) {
                    nodeInformation.setHttpPeriod(rs.getObject(HTTP_PERIOD).toString());
                }
                if (rs.getObject(HTTP_PORT) != null) {
                    nodeInformation.setHttpPort(rs.getObject(HTTP_PORT).toString());
                }
                if (rs.getObject(HTTP_TIMEOUT) != null) {
                    nodeInformation.setHttpTimeout(rs.getObject(HTTP_TIMEOUT).toString());
                }
                if (rs.getObject(POP3_PERIOD) != null) {
                    nodeInformation.setPopPeriod(rs.getObject(POP3_PERIOD).toString());
                }
                if (rs.getObject(POP3_USER) != null) {
                    nodeInformation.setPopUser(rs.getObject(POP3_USER).toString());
                }
                if (rs.getObject(POP3_PASSWORD) != null) {
                    nodeInformation.setPopPassword(rs.getObject(POP3_PASSWORD).toString());
                }
                if (rs.getObject(POP3_PORT) != null) {
                    nodeInformation.setPopPort(rs.getObject(POP3_PORT).toString());
                }
                if (rs.getObject(POP3_TIMEOUT) != null) {
                    nodeInformation.setPopTimeout(rs.getObject(POP3_TIMEOUT).toString());
                }
                if (rs.getObject(SMTP_PERIOD) != null) {
                    nodeInformation.setSmtpPeriod(rs.getObject(SMTP_PERIOD).toString());
                }
                if (rs.getObject(SMTP_PORT) != null) {
                    nodeInformation.setSmtpPort(rs.getObject(SMTP_PORT).toString());
                }
                if (rs.getObject(SMTP_TIMEOUT) != null) {
                    nodeInformation.setSmtpTimeout(rs.getObject(SMTP_TIMEOUT).toString());
                }
                if (rs.getObject(SMTP_TEST_ADDRESS) != null) {
                    nodeInformation.setSmtpSendAddress(rs.getObject(SMTP_TEST_ADDRESS).toString());
                }
                if (rs.getObject(SMTP_CHECK_POP_HOST) != null) {
                    nodeInformation.setSmtpCheckHost(rs.getObject(SMTP_CHECK_POP_HOST).toString());
                }
                if (rs.getObject(SMTP_CHECK_POP_USER) != null) {
                    nodeInformation.setSmtpCheckUser(rs.getObject(SMTP_CHECK_POP_USER).toString());
                }
                if (rs.getObject(SMTP_CHECK_POP_PASSWORD) != null) {
                    nodeInformation.setSmtpCheckPassword(rs.getObject(SMTP_CHECK_POP_PASSWORD).toString());
                }
                if (rs.getObject(SMTP_CHECK_POP_PORT) != null) {
                    nodeInformation.setSmtpCheckPort(rs.getObject(SMTP_CHECK_POP_PORT).toString());
                }
                if (rs.getObject(SMTP_CHECK_POP_TIMEOUT) != null) {
                    nodeInformation.setSmtpCheckTimeout(rs.getObject(SMTP_CHECK_POP_TIMEOUT).toString());
                }
                if (rs.getObject(ENGINE_ADDRESS) != null) {
                    nodeInformation.setEngineAddress(rs.getObject(ENGINE_ADDRESS).toString());
                } else {
                    nodeInformation.setEngineAddress("unknown");
                }
                if (rs.getObject(REGISTER_DATE) != null) {
                    nodeInformation.setRegisterDate(rs.getObject(REGISTER_DATE).toString());
                }
                if (rs.getObject(LAST_CHECK) == null) {
                    nodeInformation.setLastCheck("");
                } else {
                    nodeInformation.setLastCheck(rs.getObject(LAST_CHECK).toString());
                }
                if (rs.getObject(REGISTER_DATE) != null) {
                    String optimeString = this.convRegisterDate((Date)rs.getObject(REGISTER_DATE));
                    nodeInformation.setRegisterDate(String.valueOf(rs.getObject(REGISTER_DATE).toString()) + optimeString);
                }
                nodeInformation.setConvIPAddress(rs.getObject(IPADDRESS).toString().replace('.', '_'));
                ArrayList alarmList = null;
                alarmList = alarmDBTable.getNodeAlarm(ipaddress);
                if (alarmList.size() > 0) {
                    AlarmInformation alarmInfo = (AlarmInformation)alarmList.get(0);
                    logger.info("Alarm message : " + alarmInfo.getAlarmMessage());
                    nodeInformation.setAlarmCode(alarmInfo.getAlarmCode());
                    nodeInformation.setAlarmMessage(alarmInfo.getAlarmMessage());
                    nodeInformation.setAlarmDate(alarmInfo.getAlarmDate());
                }
                DatabaseWatcherInfo databaseInfo = DBTableDatabaseWatcher.getInstance().findDatabaseWatcher(ipaddress);
                nodeInformation.setDatabaseWatcherInfo(databaseInfo);
                nodeList.add(nodeInformation);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                stmt = null;
            }
            if (conn != null && dataaccess != null) {
                dataaccess.releaseConnection(conn);
                conn = null;
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
            }
            alarmDBTable = null;
        }
        return nodeList;
    }

    private String convRegisterDate(Date registerDate) {
        Date date = Calendar.getInstance().getTime();
        long opTime = date.getTime() - registerDate.getTime();
        String optimeString = "";
        if (opTime != 0L) {
            int day = (int)opTime / 86400000;
            int hour = (int)(opTime - (long)(day * 1000 * 60 * 60 * 24)) / 3600000;
            int min = (int)(opTime - (long)(day * 1000 * 60 * 60 * 24) - (long)(hour * 1000 * 60 * 60)) / 60000;
            int sec = (int)(opTime - (long)(day * 1000 * 60 * 60 * 24) - (long)(hour * 1000 * 60 * 60) - (long)(min * 1000 * 60)) / 1000;
            String dayString = day == 0 ? "" : String.valueOf(day) + "day ";
            String hourString = hour == 0 ? "" : String.valueOf(hour) + "hour";
            String minString = min == 0 ? "" : String.valueOf(min) + "min";
            optimeString = " (" + dayString + hourString + minString + sec + "sec)";
        }
        return optimeString;
    }

    public synchronized void deleteNode(String nodeAddress) throws SQLException, DatabaseConnectionException {
        DatabaseAccess dataaccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            String sql = "delete from noderegister where ipaddress='" + nodeAddress + "'";
            dataaccess.executeUpdate(sql);
        }
        finally {
            if (dataaccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
            }
        }
    }

    /* synthetic */ DBTableNodeRegister(DBTableNodeRegister dBTableNodeRegister) {
        this();
    }

    private static class SingletonResource {
        static final DBTableNodeRegister RESOURCE = new DBTableNodeRegister(null);

        private SingletonResource() {
        }
    }
}

