/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.preferance;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.common.view.CalendarComposite;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableAlarmFilter;
import netjfwatcher.engine.model.action.DatabaseControl;
import netjfwatcher.engine.preferance.AbstractEnginePreferancePage;
import netjfwatcher.engine.socket.info.AlarmViewFilter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class AlarmFilterPreferencePage
extends AbstractEnginePreferancePage
implements IWorkbenchPreferencePage {
    private static final int TEXT_WIDTH = 120;
    private static final String WILD = "*";
    public static final String ALARM_LEVEL_ERROR = "ERROR";
    public static final String ALARM_LEVEL_WARNING = "WARNING";
    public static final String ALARM_LEVEL_INFO = "INFO";
    private static Logger logger;
    private Text nodeNameText;
    private Text nodeIPAddressText;
    private Combo alarmLevelCombo;
    private Text alarmStartYearText;
    private Text alarmStartMonthText;
    private Text alarmStartDateText;
    private Text alarmEndYearText;
    private Text alarmEndMonthText;
    private Text alarmEndDateText;
    private Combo confirmCombo;
    private Combo startHourCombo;
    private Combo startMinuteCombo;
    private Combo endHourCombo;
    private Combo endMinuteCombo;
    private CalendarComposite calendarComposite;

    public void init(IWorkbench workbench) {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.setPreferenceStore(NetJFWatcherPlugin.getInstance().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        GridData gridData = null;
        GridLayout gridLayout0 = new GridLayout(1, false);
        Composite composite0 = new Composite(parent, 16384);
        composite0.setLayout((Layout)gridLayout0);
        composite0.setLayoutData((Object)new GridData());
        GridLayout gridLayout = new GridLayout(4, false);
        Composite composite1 = new Composite(composite0, 16384);
        composite1.setLayout((Layout)gridLayout);
        composite1.setLayoutData((Object)new GridData());
        gridData = new GridData();
        Label label = new Label(composite1, 0);
        label.setText("Node Name");
        label.setLayoutData((Object)new GridData());
        this.nodeNameText = new Text(composite1, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.nodeNameText.setLayoutData((Object)gridData);
        label = new Label(composite1, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite1, 0);
        label.setText("Node IP Address");
        label.setLayoutData((Object)new GridData());
        this.nodeIPAddressText = new Text(composite1, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.nodeIPAddressText.setLayoutData((Object)gridData);
        label = new Label(composite1, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite1, 0);
        label.setText("Confirm/Unconfirm");
        label.setLayoutData((Object)new GridData());
        this.confirmCombo = new Combo(composite1, 8);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.confirmCombo.setLayoutData((Object)gridData);
        this.confirmCombo.add(WILD);
        this.confirmCombo.add("Unconfirm");
        this.confirmCombo.add("Confirm");
        this.confirmCombo.select(0);
        label = new Label(composite1, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite1, 0);
        label.setText("Alarm Level");
        label.setLayoutData((Object)new GridData());
        this.alarmLevelCombo = new Combo(composite1, 2056);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.alarmLevelCombo.setLayoutData((Object)gridData);
        this.alarmLevelCombo.add(WILD);
        this.alarmLevelCombo.add(ALARM_LEVEL_ERROR);
        this.alarmLevelCombo.add(ALARM_LEVEL_WARNING);
        this.alarmLevelCombo.add(ALARM_LEVEL_INFO);
        this.alarmLevelCombo.select(0);
        label = new Label(composite1, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        GridLayout gridLayout3 = new GridLayout(10, false);
        Composite composite3 = new Composite(composite0, 0);
        composite3.setLayoutData((Object)new GridData(256));
        composite3.setLayout((Layout)gridLayout3);
        Button startDateRadio = new Button(composite3, 16);
        startDateRadio.setText("Start date");
        startDateRadio.setSelection(true);
        startDateRadio.setLayoutData((Object)new GridData());
        this.alarmStartYearText = new Text(composite3, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 40;
        this.alarmStartYearText.setLayoutData((Object)gridData);
        label = new Label(composite3, 0);
        label.setText(" ");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.alarmStartMonthText = new Text(composite3, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 20;
        this.alarmStartMonthText.setLayoutData((Object)gridData);
        label = new Label(composite3, 0);
        label.setText("/");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.alarmStartDateText = new Text(composite3, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 20;
        this.alarmStartDateText.setLayoutData((Object)gridData);
        label = new Label(composite3, 0);
        label.setText(" ");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.startHourCombo = new Combo(composite3, 8);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.startHourCombo.setLayoutData((Object)gridData);
        this.setHourCombo(this.startHourCombo);
        this.startHourCombo.select(0);
        label = new Label(composite3, 0);
        label.setText(":");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.startMinuteCombo = new Combo(composite3, 8);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 20;
        this.setMinuteCombo(this.startMinuteCombo);
        this.startMinuteCombo.select(0);
        Button endDateRadio = new Button(composite3, 16);
        endDateRadio.setText("End date");
        endDateRadio.setSelection(false);
        endDateRadio.setLayoutData((Object)new GridData());
        this.alarmEndYearText = new Text(composite3, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 40;
        this.alarmEndYearText.setLayoutData((Object)gridData);
        label = new Label(composite3, 0);
        label.setText(" ");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.alarmEndMonthText = new Text(composite3, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 20;
        this.alarmEndMonthText.setLayoutData((Object)gridData);
        label = new Label(composite3, 0);
        label.setText("/");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.alarmEndDateText = new Text(composite3, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 20;
        this.alarmEndDateText.setLayoutData((Object)gridData);
        label = new Label(composite3, 0);
        label.setText(" ");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.endHourCombo = new Combo(composite3, 8);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.endHourCombo.setLayoutData((Object)gridData);
        this.setHourCombo(this.endHourCombo);
        this.endHourCombo.select(0);
        label = new Label(composite3, 0);
        label.setText(":");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.endMinuteCombo = new Combo(composite3, 8);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.endMinuteCombo.setLayoutData((Object)gridData);
        this.setMinuteCombo(this.endMinuteCombo);
        this.endMinuteCombo.select(0);
        GridLayout gridLayout2 = new GridLayout(1, false);
        Composite composite2 = new Composite(composite0, 0);
        composite2.setLayoutData((Object)new GridData(256));
        composite2.setLayout((Layout)gridLayout2);
        this.calendarComposite = new CalendarComposite();
        this.calendarComposite.setYearText(this.alarmStartYearText);
        this.calendarComposite.setMonthText(this.alarmStartMonthText);
        this.calendarComposite.setDateText(this.alarmStartDateText);
        this.calendarComposite.createCalendarView(composite2);
        try {
            this.setShowAlarmFilterInfo();
        }
        catch (DatabaseConnectionException e1) {
            logger.warning(e1.getMessage());
        }
        catch (SQLException e1) {
            logger.warning(e1.getMessage());
        }
        startDateRadio.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                AlarmFilterPreferencePage.this.calendarComposite.setYearText(AlarmFilterPreferencePage.this.alarmStartYearText);
                AlarmFilterPreferencePage.this.calendarComposite.setMonthText(AlarmFilterPreferencePage.this.alarmStartMonthText);
                AlarmFilterPreferencePage.this.calendarComposite.setDateText(AlarmFilterPreferencePage.this.alarmStartDateText);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        endDateRadio.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                AlarmFilterPreferencePage.this.calendarComposite.setYearText(AlarmFilterPreferencePage.this.alarmEndYearText);
                AlarmFilterPreferencePage.this.calendarComposite.setMonthText(AlarmFilterPreferencePage.this.alarmEndMonthText);
                AlarmFilterPreferencePage.this.calendarComposite.setDateText(AlarmFilterPreferencePage.this.alarmEndDateText);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        return parent;
    }

    private void setHourCombo(Combo combo) {
        int i = 0;
        while (i < 24) {
            String work = Integer.toString(i);
            if (work.length() == 1) {
                work = "0" + work;
            }
            combo.add(work);
            ++i;
        }
    }

    private void setMinuteCombo(Combo combo) {
        int i = 0;
        while (i < 60) {
            String work = Integer.toString(i);
            if (work.length() == 1) {
                work = "0" + work;
            }
            combo.add(work);
            ++i;
        }
    }

    private void setShowAlarmFilterInfo() throws DatabaseConnectionException, SQLException {
        if (!DatabaseControl.getInstance().isDatabaseStart()) {
            logger.warning("Not running Database.");
            return;
        }
        AlarmViewFilter alarmViewFilter = null;
        alarmViewFilter = this.getAlarmFilterFromDatabase();
        if (alarmViewFilter == null) {
            return;
        }
        this.nodeNameText.setText(alarmViewFilter.getNodename());
        this.nodeIPAddressText.setText(alarmViewFilter.getIpaddress());
        this.alarmLevelCombo.setText(alarmViewFilter.getAlarmLevel());
        this.confirmCombo.setText(alarmViewFilter.getAlarmConfirm());
        String startDateString = "";
        String endDateString = "";
        startDateString = alarmViewFilter.getAlarmStartDate();
        endDateString = alarmViewFilter.getAlarmEndDate();
        if (!startDateString.equals(WILD)) {
            try {
                long startDateLong = Long.parseLong(startDateString);
                Date startDate = new Date(startDateLong);
                Calendar cal = Calendar.getInstance();
                cal.setTime(startDate);
                this.alarmStartYearText.setText(Integer.toString(cal.get(1)));
                this.alarmStartMonthText.setText(Integer.toString(cal.get(2) + 1));
                this.alarmStartDateText.setText(Integer.toString(cal.get(5)));
                String work = Integer.toString(cal.get(11));
                if (work.length() == 1) {
                    work = "0" + work;
                }
                this.startHourCombo.setText(work);
                work = Integer.toString(cal.get(12));
                if (work.length() == 1) {
                    work = "0" + work;
                }
                this.startMinuteCombo.setText(work);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            this.startHourCombo.select(0);
            this.startMinuteCombo.select(0);
        }
        if (!endDateString.equals(WILD)) {
            try {
                Date endDate = new Date(Long.parseLong(endDateString));
                Calendar cal = Calendar.getInstance();
                cal.setTime(endDate);
                this.alarmEndYearText.setText(Integer.toString(cal.get(1)));
                this.alarmEndMonthText.setText(Integer.toString(cal.get(2) + 1));
                this.alarmEndDateText.setText(Integer.toString(cal.get(5)));
                String work = Integer.toString(cal.get(11));
                if (work.length() == 1) {
                    work = "0" + work;
                }
                this.endHourCombo.setText(work);
                work = Integer.toString(cal.get(12));
                if (work.length() == 1) {
                    work = "0" + work;
                }
                this.endMinuteCombo.setText(work);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private AlarmViewFilter getAlarmFilterFromDatabase() throws DatabaseConnectionException, SQLException {
        AlarmViewFilter alarmViewFilter = null;
        DBTableAlarmFilter alarmFilterDBTable = new DBTableAlarmFilter();
        ArrayList alarmFilterList = null;
        alarmFilterList = alarmFilterDBTable.findAll();
        int i = 0;
        while (i < alarmFilterList.size()) {
            alarmViewFilter = (AlarmViewFilter)alarmFilterList.get(i);
            ++i;
        }
        return alarmViewFilter;
    }

    protected void performDefaults() {
        try {
            this.setShowAlarmFilterInfo();
        }
        catch (DatabaseConnectionException e1) {
            logger.warning(e1.getMessage());
        }
        catch (SQLException e1) {
            logger.warning(e1.getMessage());
        }
        this.nodeNameText.setText(WILD);
        this.nodeIPAddressText.setText(WILD);
        this.alarmLevelCombo.select(0);
        this.alarmStartYearText.setText("");
        this.alarmStartMonthText.setText("");
        this.alarmStartDateText.setText("");
        this.alarmEndYearText.setText("");
        this.alarmEndMonthText.setText("");
        this.alarmEndDateText.setText("");
        this.confirmCombo.select(0);
        this.startHourCombo.select(0);
        this.startMinuteCombo.select(0);
        this.endHourCombo.select(0);
        this.endMinuteCombo.select(0);
    }

    public boolean performOk() {
        if (!DatabaseControl.getInstance().isDatabaseStart()) {
            logger.warning("Not running Database.");
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Not running Database.");
            return false;
        }
        try {
            AlarmViewFilter alarmFilterInfo = null;
            alarmFilterInfo = this.getAlarmFilterFromDatabase();
            alarmFilterInfo = this.createAlarmFilterDate(alarmFilterInfo);
            String nodeName = this.nodeNameText.getText();
            String ipAddress = this.nodeIPAddressText.getText();
            String alarmLevel = this.alarmLevelCombo.getText();
            String alarmConfirm = this.confirmCombo.getText();
            alarmFilterInfo.setNodename(nodeName);
            alarmFilterInfo.setIpaddress(ipAddress);
            alarmFilterInfo.setAlarmConfirm(alarmConfirm);
            alarmFilterInfo.setAlarmLevel(alarmLevel);
            DBTableAlarmFilter alarmFilterDBTable = new DBTableAlarmFilter();
            alarmFilterDBTable.updateAlarmFilter(alarmFilterInfo);
        }
        catch (DatabaseConnectionException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)e.getMessage());
        }
        catch (SQLException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)e.getMessage());
        }
        return super.performOk();
    }

    private AlarmViewFilter createAlarmFilterDate(AlarmViewFilter alarmFilterInfo) {
        Calendar cal;
        int year = 0;
        int month = 0;
        int date = 0;
        int hour = 0;
        int minute = 0;
        if (this.alarmStartYearText.getText() != null && !this.alarmStartYearText.getText().equals("")) {
            String startYearString = this.alarmStartYearText.getText();
            String startMonthString = this.alarmStartMonthText.getText();
            String startDateString = this.alarmStartDateText.getText();
            String startHourString = this.startHourCombo.getText();
            String startMinuteString = this.startMinuteCombo.getText();
            try {
                year = Integer.parseInt(startYearString);
                month = Integer.parseInt(startMonthString);
                date = Integer.parseInt(startDateString);
                hour = Integer.parseInt(startHourString);
                minute = Integer.parseInt(startMinuteString);
                cal = Calendar.getInstance();
                cal.set(year, month - 1, date, hour, minute);
                String startDate = Long.toString(cal.getTimeInMillis());
                alarmFilterInfo.setAlarmStartDate(startDate);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        } else {
            alarmFilterInfo.setAlarmStartDate(WILD);
        }
        if (this.alarmEndYearText.getText() != null && !this.alarmEndYearText.getText().equals("")) {
            String endYearString = this.alarmEndYearText.getText();
            String endMonthString = this.alarmEndMonthText.getText();
            String endDateString = this.alarmEndDateText.getText();
            String endHourString = this.endHourCombo.getText();
            String endMinuteString = this.endMinuteCombo.getText();
            try {
                year = Integer.parseInt(endYearString);
                month = Integer.parseInt(endMonthString);
                date = Integer.parseInt(endDateString);
                hour = Integer.parseInt(endHourString);
                minute = Integer.parseInt(endMinuteString);
                cal = Calendar.getInstance();
                cal.set(year, month - 1, date, hour, minute);
                String endDate = Long.toString(cal.getTimeInMillis());
                alarmFilterInfo.setAlarmEndDate(endDate);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        } else {
            alarmFilterInfo.setAlarmEndDate(WILD);
        }
        return alarmFilterInfo;
    }
}

