/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.preferance;

import netjfwatcher.application.NetJFWatcherPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class EngineWorkbenchPreference
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IPreferenceStore prefStore;
    private Button exitWithoutPromptCheckButton;
    private Button workbenchConfigurerCheckButton;
    private boolean isWorkbechConfigSet;
    private boolean isPromptOnExit;

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(NetJFWatcherPlugin.getInstance().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        this.prefStore = NetJFWatcherPlugin.getDefault().getPreferenceStore();
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout((Layout)layout);
        GridLayout gridLayout = new GridLayout(1, false);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(256));
        this.workbenchConfigurerCheckButton = new Button(composite, 32);
        this.workbenchConfigurerCheckButton.setText("Workbench Configurer Set SaveAndRestore");
        this.workbenchConfigurerCheckButton.setBounds(10, 10, 120, 24);
        boolean workBenchConfigSet = this.prefStore.getBoolean("WorkbenchConfigurer");
        this.workbenchConfigurerCheckButton.setSelection(workBenchConfigSet);
        this.isWorkbechConfigSet = workBenchConfigSet;
        this.exitWithoutPromptCheckButton = new Button(composite, 32);
        this.exitWithoutPromptCheckButton.setText("Always exit without prompt");
        this.exitWithoutPromptCheckButton.setBounds(10, 10, 120, 24);
        boolean promptOnExit = this.prefStore.getBoolean("net.sourceforge.eclipsetrader.promptOnExit");
        this.exitWithoutPromptCheckButton.setSelection(promptOnExit);
        this.isPromptOnExit = promptOnExit;
        this.workbenchConfigurerCheckButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Button bChk = (Button)e.widget;
                if (bChk.getSelection()) {
                    EngineWorkbenchPreference.this.isWorkbechConfigSet = true;
                } else {
                    EngineWorkbenchPreference.this.isWorkbechConfigSet = false;
                }
            }
        });
        this.exitWithoutPromptCheckButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                Button bChk = (Button)event.widget;
                if (bChk.getSelection()) {
                    EngineWorkbenchPreference.this.isPromptOnExit = true;
                } else {
                    EngineWorkbenchPreference.this.isPromptOnExit = false;
                }
            }
        });
        return composite;
    }

    protected void performDefaults() {
        this.prefStore = NetJFWatcherPlugin.getDefault().getPreferenceStore();
        boolean workBenchConfigSet = this.prefStore.getBoolean("WorkbenchConfigurer");
        this.workbenchConfigurerCheckButton.setSelection(workBenchConfigSet);
        this.isWorkbechConfigSet = workBenchConfigSet;
        boolean promptOnExit = this.prefStore.getBoolean("net.sourceforge.eclipsetrader.promptOnExit");
        this.exitWithoutPromptCheckButton.setSelection(promptOnExit);
        this.isPromptOnExit = promptOnExit;
    }

    public boolean performOk() {
        if (this.isWorkbechConfigSet) {
            this.prefStore.setValue("WorkbenchConfigurer", true);
            NetJFWatcherPlugin.getDefault().savePluginPreferences();
        } else {
            this.prefStore.setValue("WorkbenchConfigurer", false);
            NetJFWatcherPlugin.getDefault().savePluginPreferences();
        }
        if (this.isPromptOnExit) {
            this.prefStore.setValue("net.sourceforge.eclipsetrader.promptOnExit", false);
            NetJFWatcherPlugin.getDefault().savePluginPreferences();
        } else {
            this.prefStore.setValue("net.sourceforge.eclipsetrader.promptOnExit", true);
            NetJFWatcherPlugin.getDefault().savePluginPreferences();
        }
        return super.performOk();
    }
}

