/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.resource;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.socket.info.MailProperty;
import netjfwatcher.engine.socket.info.ResourceInfo;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.osgi.framework.Bundle;

public class SystemResourceFileParse {
    public static final String XML_FILE_VALUE = "value";
    public static final String CONF = "conf";
    public static final String ENGINE = "engine";
    public static final String ENGINE_PORT = "port";
    public static final String ENGINE_ALLOW_HOST = "allow-host";
    public static final String DATABASE = "database";
    public static final String DATABASE_NAME = "database_name";
    public static final String DATABASE_DRIVER = "driver";
    public static final String DATABASE_URL = "url";
    public static final String DATABASE_USER = "user";
    public static final String DATABASE_PASSWORD = "password";
    public static final String SNMP = "snmp";
    public static final String SNMP_PORT = "port";
    public static final String SNMP_TRAP_PORT = "trapPort";
    public static final String SNMPV1_TIMEOUT = "snmpV1Timeout";
    public static final String SNMPV2_TIMEOUT = "snmpV2Timeout";
    public static final String SNMPV3_TIMEOUT = "snmpV3Timeout";
    public static final String SNMPV1_RETRY = "snmpV1Retry";
    public static final String SNMPV2_RETRY = "snmpV2Retry";
    public static final String SNMPV3_RETRY = "snmpV3Retry";
    public static final String PING = "ping";
    public static final String PING_TIMEOUT = "timeout";
    public static final String PING_COUNT = "count";
    public static final String XML_SOCKET = "xmlsocket";
    public static final String ALERT_SOUND = "alert_sound";
    public static final String ALLOW_HOST = "allow-host";
    public static final String XML_SOCKET_PORT = "port";
    public static final String XML_SOCKET_MAXCONNECT = "maxconnect";
    public static final String REFRESH_TIME = "refresh_time";
    public static final String MAIL_FILTER = "mail_filter";
    public static final String MAIL_FILTER_ERROR_LEVEL = "error_level";
    public static final String MAIL_FILTER_FLAG = "message_filter_flag";
    public static final String MAIL_FILTER_STRING = "message_filter_string";
    public static final String UNREGISTRATION_NODE = "UnregistrationNode";
    public static final String UNREGISTRATION_NODE_ALARM = "alarm";
    public static final String GUARD = "guard";
    public static final String MAIL = "mail";
    public static final String MAIL_GUARD_TIME = "mail_guard_time";
    public static final String MAIL_SEND = "send";
    public static final String MAIL_SMTP_HOST = "smtp.host";
    public static final String MAIL_FROM = "from";
    public static final String MAIL_TO_LIST = "mail_to";
    public static final String MAIL_TO = "to";
    public static final String ALARM = "alarm";
    public static final String ALARM_HOLD_PERIOD = "hold_period_day";
    public static final String ALARM_MAX_LINE = "max_line";
    public static final String STATISTICS = "statistics";
    public static final String STATISTICS_HOLD_PERIOD = "hold_period_day";
    public static final String STATISTICS_MAX_LINE = "max_line";
    private static Logger logger = null;
    private String enginePort;
    private String engineAllowHost;
    private String databaseName;
    private String databaseDriver;
    private String databaseUrl;
    private String databaseUser;
    private String databasePassword;
    private String snmpV1Timeout;
    private String snmpV2Timeout;
    private String snmpV3Timeout;
    private String snmpV1Retry;
    private String snmpV2Retry;
    private String snmpV3Retry;
    private String pingTimeout;
    private String pingRetry;
    private String xmlsocketPort;
    private String alertSound;
    private String xmlsocketAllowHost;
    private String xmlsocketMaxconnect;
    private String refreshTime;
    private String mailGuardTime;
    private String alarmHoldPeriodDay;
    private String alarmMax;
    private String statisticsHoldPeriodDay;
    private String statisticsMax;
    private ResourceInfo resourceInfo;

    public SystemResourceFileParse() throws Exception {
        logger = Logger.getLogger(this.getClass().getName());
        logger.info("Resource File Parse : resources/system_resource.xml");
        Document doc = null;
        doc = this.getResourceFileDocumentPath("resources/system_resource.xml");
        if (doc == null) {
            logger.severe("Resource File Doc null ");
            return;
        }
        this.resourceInfo = new ResourceInfo();
        try {
            Element root = doc.getRootElement();
            Element engineEl = root.getChild(ENGINE);
            Element databaseEl = root.getChild(DATABASE);
            Element snmpEl = root.getChild(SNMP);
            Element pingEl = root.getChild(PING);
            Element xmlsocketEl = root.getChild(XML_SOCKET);
            Element guardEl = root.getChild(GUARD);
            Element alarmEl = root.getChild("alarm");
            Element statisticsEl = root.getChild(STATISTICS);
            Element mailFilterEl = root.getChild(MAIL_FILTER);
            Element unregistrationNodeEl = root.getChild(UNREGISTRATION_NODE);
            if (engineEl.getChild("port") != null) {
                this.enginePort = engineEl.getChild("port").getAttributeValue(XML_FILE_VALUE);
                this.engineAllowHost = engineEl.getChild("allow-host").getAttributeValue(XML_FILE_VALUE);
                this.resourceInfo.setEnginePort(engineEl.getChild("port").getAttributeValue(XML_FILE_VALUE));
                this.resourceInfo.setEngineAllowHost(engineEl.getChild("allow-host").getAttributeValue(XML_FILE_VALUE));
            } else {
                logger.warning("Engine port not found");
            }
            if (databaseEl.getChild(DATABASE_NAME) != null) {
                this.databaseName = databaseEl.getChild(DATABASE_NAME).getAttributeValue(XML_FILE_VALUE);
                this.resourceInfo.setDatabaseName(databaseEl.getChild(DATABASE_NAME).getAttributeValue(XML_FILE_VALUE));
            } else {
                logger.warning("database_name not found");
            }
            if (databaseEl.getChild(DATABASE_DRIVER) != null) {
                this.databaseDriver = databaseEl.getChild(DATABASE_DRIVER).getAttributeValue(XML_FILE_VALUE);
                this.resourceInfo.setDatabaseDriver(databaseEl.getChild(DATABASE_DRIVER).getAttributeValue(XML_FILE_VALUE));
            } else {
                logger.warning("Database driver not found");
            }
            if (databaseEl.getChild(DATABASE_URL) != null) {
                this.databaseUrl = databaseEl.getChild(DATABASE_URL).getAttributeValue(XML_FILE_VALUE);
                this.resourceInfo.setDatabaseUrl(databaseEl.getChild(DATABASE_URL).getAttributeValue(XML_FILE_VALUE));
            } else {
                logger.warning("Database url not found");
            }
            if (databaseEl.getChild(DATABASE_USER) != null) {
                this.databaseUser = databaseEl.getChild(DATABASE_USER).getAttributeValue(XML_FILE_VALUE);
                this.resourceInfo.setDatabaseUser(databaseEl.getChild(DATABASE_USER).getAttributeValue(XML_FILE_VALUE));
            } else {
                logger.warning("Database user not found");
            }
            if (databaseEl.getChild(DATABASE_PASSWORD) != null) {
                this.databasePassword = databaseEl.getChild(DATABASE_PASSWORD).getAttributeValue(XML_FILE_VALUE);
                this.resourceInfo.setDatabasePassword(databaseEl.getChild(DATABASE_PASSWORD).getAttributeValue(XML_FILE_VALUE));
            } else {
                logger.warning("Database password not found");
            }
            if (snmpEl.getChild("port") != null) {
                this.resourceInfo.setSnmpPort(Integer.parseInt(snmpEl.getChild("port").getAttributeValue(XML_FILE_VALUE)));
            } else {
                logger.warning("snmpEl.getChild(SNMP_PORT) null");
                try {
                    this.resourceInfo.setSnmpPort(Integer.parseInt(Integer.toString(161)));
                }
                catch (NumberFormatException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
                logger.warning("snmp Port not found");
            }
            if (snmpEl.getChild(SNMP_TRAP_PORT) != null) {
                this.resourceInfo.setSnmpTrapPort(Integer.parseInt(snmpEl.getChild(SNMP_TRAP_PORT).getAttributeValue(XML_FILE_VALUE)));
            } else {
                try {
                    this.resourceInfo.setSnmpTrapPort(Integer.parseInt(Integer.toString(162)));
                }
                catch (NumberFormatException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
                logger.warning("snmp Trap Port not found");
            }
            if (snmpEl.getChild(SNMPV1_TIMEOUT) != null) {
                this.snmpV1Timeout = snmpEl.getChild(SNMPV1_TIMEOUT).getAttributeValue(XML_FILE_VALUE);
                this.resourceInfo.setSnmpV1Timeout(snmpEl.getChild(SNMPV1_TIMEOUT).getAttributeValue(XML_FILE_VALUE));
            } else {
                logger.warning("snmpV1Timeout not found");
            }
            if (snmpEl.getChild(SNMPV2_TIMEOUT) != null) {
                this.snmpV2Timeout = snmpEl.getChild(SNMPV2_TIMEOUT).getAttributeValue(XML_FILE_VALUE);
                this.resourceInfo.setSnmpV2Timeout(snmpEl.getChild(SNMPV2_TIMEOUT).getAttributeValue(XML_FILE_VALUE));
            } else {
                logger.warning("snmpV2Timeout not found");
            }
            if (snmpEl.getChild(SNMPV3_TIMEOUT) != null) {
                this.snmpV3Timeout = snmpEl.getChild(SNMPV3_TIMEOUT).getAttributeValue(XML_FILE_VALUE);
                this.resourceInfo.setSnmpV3Timeout(snmpEl.getChild(SNMPV3_TIMEOUT).getAttributeValue(XML_FILE_VALUE));
            } else {
                logger.warning("snmpV3Timeout not found");
            }
            if (snmpEl.getChild(SNMPV1_RETRY) != null) {
                this.snmpV1Retry = snmpEl.getChild(SNMPV1_RETRY).getAttributeValue(XML_FILE_VALUE);
                this.resourceInfo.setSnmpV1Retry(snmpEl.getChild(SNMPV1_RETRY).getAttributeValue(XML_FILE_VALUE));
            } else {
                logger.warning("snmpV1Retry not found");
            }
            if (snmpEl.getChild(SNMPV2_RETRY) != null) {
                this.snmpV2Retry = snmpEl.getChild(SNMPV2_RETRY).getAttributeValue(XML_FILE_VALUE);
                this.resourceInfo.setSnmpV2Retry(snmpEl.getChild(SNMPV2_RETRY).getAttributeValue(XML_FILE_VALUE));
            } else {
                logger.warning("snmpV2Retry not found");
            }
            if (snmpEl.getChild(SNMPV3_RETRY) != null) {
                this.snmpV3Retry = snmpEl.getChild(SNMPV3_RETRY).getAttributeValue(XML_FILE_VALUE);
                this.resourceInfo.setSnmpV3Retry(snmpEl.getChild(SNMPV3_RETRY).getAttributeValue(XML_FILE_VALUE));
            } else {
                logger.warning("snmpV3Retry not found");
            }
            if (pingEl.getChild(PING_TIMEOUT) != null) {
                this.pingTimeout = pingEl.getChild(PING_TIMEOUT).getAttributeValue(XML_FILE_VALUE);
                this.resourceInfo.setPingTimeout(pingEl.getChild(PING_TIMEOUT).getAttributeValue(XML_FILE_VALUE));
            } else {
                logger.warning("Ping timeout not found");
            }
            if (pingEl.getChild(PING_COUNT) != null) {
                this.pingRetry = pingEl.getChild(PING_COUNT).getAttributeValue(XML_FILE_VALUE);
                this.resourceInfo.setPingRetry(pingEl.getChild(PING_COUNT).getAttributeValue(XML_FILE_VALUE));
            } else {
                logger.warning("Ping retry notfound");
            }
            if (xmlsocketEl.getChild(ALERT_SOUND) != null) {
                this.alertSound = xmlsocketEl.getChild(ALERT_SOUND).getAttributeValue(XML_FILE_VALUE);
                this.resourceInfo.setAlertSound(xmlsocketEl.getChild(ALERT_SOUND).getAttributeValue(XML_FILE_VALUE));
            } else {
                logger.warning("Alert sound notfound");
            }
            if (xmlsocketEl.getChild("allow-host") != null) {
                this.xmlsocketAllowHost = xmlsocketEl.getChild("allow-host").getAttributeValue(XML_FILE_VALUE);
                this.resourceInfo.setXmlsocketAllowHost(xmlsocketEl.getChild("allow-host").getAttributeValue(XML_FILE_VALUE));
            } else {
                logger.warning("xmlsocket allow host notfound");
            }
            if (xmlsocketEl.getChild("port") != null) {
                this.xmlsocketPort = xmlsocketEl.getChild("port").getAttributeValue(XML_FILE_VALUE);
                this.resourceInfo.setXmlSocketPort(xmlsocketEl.getChild("port").getAttributeValue(XML_FILE_VALUE));
            } else {
                logger.warning("xmlsocket port notfound");
            }
            if (xmlsocketEl.getChild(XML_SOCKET_MAXCONNECT) != null) {
                this.xmlsocketMaxconnect = xmlsocketEl.getChild(XML_SOCKET_MAXCONNECT).getAttributeValue(XML_FILE_VALUE);
                this.resourceInfo.setXmlSocketMaxConnect(xmlsocketEl.getChild(XML_SOCKET_MAXCONNECT).getAttributeValue(XML_FILE_VALUE));
            } else {
                logger.warning("maxconnect notfound");
            }
            if (xmlsocketEl.getChild(REFRESH_TIME) != null) {
                this.refreshTime = xmlsocketEl.getChild(REFRESH_TIME).getAttributeValue(XML_FILE_VALUE);
                this.resourceInfo.setRefreshTime(xmlsocketEl.getChild(REFRESH_TIME).getAttributeValue(XML_FILE_VALUE));
            } else {
                logger.warning("refresh_time notfound");
            }
            if (mailFilterEl != null) {
                if (mailFilterEl.getChild(MAIL_FILTER_ERROR_LEVEL) != null) {
                    this.resourceInfo.setMailFilterErrorLevel(mailFilterEl.getChild(MAIL_FILTER_ERROR_LEVEL).getAttributeValue(XML_FILE_VALUE));
                }
                if (mailFilterEl.getChild(MAIL_FILTER_FLAG) != null) {
                    if (mailFilterEl.getChild(MAIL_FILTER_FLAG).getAttributeValue(XML_FILE_VALUE).equals("on")) {
                        this.resourceInfo.setMailFilterStringFlag(true);
                    } else {
                        this.resourceInfo.setMailFilterStringFlag(false);
                    }
                }
                if (mailFilterEl.getChild(MAIL_FILTER_STRING) != null) {
                    this.resourceInfo.setMailFilterString(mailFilterEl.getChild(MAIL_FILTER_STRING).getAttributeValue(XML_FILE_VALUE));
                }
            }
            if (unregistrationNodeEl != null && unregistrationNodeEl.getChild("alarm") != null) {
                this.resourceInfo.setUnregistrationNodeAlarm(unregistrationNodeEl.getChild("alarm").getAttributeValue(XML_FILE_VALUE));
            }
            this.mailGuardTime = guardEl.getChild(MAIL_GUARD_TIME).getAttributeValue(XML_FILE_VALUE);
            this.resourceInfo.setMailGuardTime(guardEl.getChild(MAIL_GUARD_TIME).getAttributeValue(XML_FILE_VALUE));
            this.alarmHoldPeriodDay = alarmEl.getChild("hold_period_day").getAttributeValue(XML_FILE_VALUE);
            this.resourceInfo.setAlarmHoldPeriodDay(alarmEl.getChild("hold_period_day").getAttributeValue(XML_FILE_VALUE));
            this.alarmMax = alarmEl.getChild("max_line").getAttributeValue(XML_FILE_VALUE);
            this.resourceInfo.setAlarmMax(alarmEl.getChild("max_line").getAttributeValue(XML_FILE_VALUE));
            this.statisticsHoldPeriodDay = statisticsEl.getChild("hold_period_day").getAttributeValue(XML_FILE_VALUE);
            this.resourceInfo.setStatisticsHoldPeriodDay(statisticsEl.getChild("hold_period_day").getAttributeValue(XML_FILE_VALUE));
            this.statisticsMax = statisticsEl.getChild("max_line").getAttributeValue(XML_FILE_VALUE);
            this.resourceInfo.setStatisticsMax(statisticsEl.getChild("max_line").getAttributeValue(XML_FILE_VALUE));
            List mailList = root.getChildren(MAIL);
            Iterator iterator = mailList.iterator();
            while (iterator.hasNext()) {
                MailProperty mailProperty = new MailProperty();
                Element mailListEl = (Element)iterator.next();
                mailProperty.setMailSendFlag(mailListEl.getChild(MAIL_SEND).getAttributeValue(XML_FILE_VALUE));
                mailProperty.setSmtpHost(mailListEl.getChild(MAIL_SMTP_HOST).getAttributeValue(XML_FILE_VALUE));
                mailProperty.setFrom(mailListEl.getChild(MAIL_FROM).getAttributeValue(XML_FILE_VALUE));
                List toList = mailListEl.getChildren(MAIL_TO_LIST);
                for (Element mailToEl : toList) {
                    mailProperty.setTo(mailToEl.getChild(MAIL_TO).getAttributeValue(XML_FILE_VALUE));
                }
                this.resourceInfo.setMailPropertyList(mailProperty);
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    public ResourceInfo getResourceInfo() {
        return this.resourceInfo;
    }

    public BufferedWriter getResourceFileWriter() {
        File f = new File("resources/system_resource.xml");
        if (f == null) {
            return null;
        }
        BufferedWriter bufferedWriter = null;
        try {
            FileWriter fi = new FileWriter("resources/system_resource.xml");
            bufferedWriter = new BufferedWriter(fi);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return null;
        }
        return bufferedWriter;
    }

    public Document getResourceFileDocumentPath(String file) {
        Document doc = null;
        File f = new File(file);
        if (f == null) {
            logger.warning("Abort create File : " + f.getAbsolutePath());
            return null;
        }
        BufferedReader d = null;
        try {
            FileReader fi = new FileReader(file);
            d = new BufferedReader(fi);
        }
        catch (FileNotFoundException e1) {
            logger.warning("FileNotFoundException : " + f.getPath() + " : " + e1.getMessage());
            logger.warning("FileNotFoundException : " + f.getAbsolutePath() + " : " + e1.getMessage());
            e1.printStackTrace();
            return null;
        }
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build((Reader)d);
        }
        catch (JDOMException e) {
            logger.warning("JDOMException : " + e.getMessage());
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            logger.warning("NullPointerException : " + e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.warning("IOException : " + e.getMessage());
            e.printStackTrace();
        }
        return doc;
    }

    protected Document getDocument(String file) {
        URL url;
        Document doc;
        block5: {
            doc = null;
            url = null;
            logger.severe("Parse start : " + file);
            Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
            url = bundle.getEntry(file);
            if (url != null) break block5;
            logger.severe("Resource XML file url : " + url);
            return null;
        }
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(url.openStream());
        }
        catch (JDOMException e) {
            logger.severe("Alert/Confirm Dialog Window Message XML file url : " + url);
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            logger.severe("Alert/Confirm Dialog Window Message XML file url : " + url);
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.severe("Alert/Confirm Dialog Window Message XML file url : " + url);
            e.printStackTrace();
        }
        return doc;
    }

    public Document updateDocument(ResourceInfo updateResourceInfo) {
        logger = Logger.getLogger(this.getClass().getName());
        Element confElement = new Element(CONF);
        Document doc = new Document(confElement);
        Element engine = new Element(ENGINE);
        Element port = new Element("port");
        Element allowHost = new Element("allow-host");
        Element database = new Element(DATABASE);
        Element databaseName = new Element(DATABASE_NAME);
        Element driver = new Element(DATABASE_DRIVER);
        Element url = new Element(DATABASE_URL);
        Element user = new Element(DATABASE_USER);
        Element password = new Element(DATABASE_PASSWORD);
        Element snmp = new Element(SNMP);
        Element snmpPort = new Element("port");
        Element snmpTrapPort = new Element(SNMP_TRAP_PORT);
        Element snmpV1Timeout = new Element(SNMPV1_TIMEOUT);
        Element snmpV1Retry = new Element(SNMPV1_RETRY);
        Element snmpV2Timeout = new Element(SNMPV2_TIMEOUT);
        Element snmpV2Retry = new Element(SNMPV2_RETRY);
        Element snmpV3Timeout = new Element(SNMPV3_TIMEOUT);
        Element snmpV3Retry = new Element(SNMPV3_RETRY);
        Element ping = new Element(PING);
        Element pingTimeout = new Element(PING_TIMEOUT);
        Element pingRetry = new Element(PING_COUNT);
        Element xmlsocket = new Element(XML_SOCKET);
        Element alertSound = new Element(ALERT_SOUND);
        Element xmlsocketAllowHost = new Element("allow-host");
        Element xmlsocketPort = new Element("port");
        Element xmlsocketMaxconnect = new Element(XML_SOCKET_MAXCONNECT);
        Element refreshTime = new Element(REFRESH_TIME);
        Element mailFilterEl = new Element(MAIL_FILTER);
        Element mailFilterErrorLevel = new Element(MAIL_FILTER_ERROR_LEVEL);
        Element mailFilterFlag = new Element(MAIL_FILTER_FLAG);
        Element mailFilterString = new Element(MAIL_FILTER_STRING);
        Element unregistrationNodeEl = new Element(UNREGISTRATION_NODE);
        Element unregistrationNodeAlarm = new Element("alarm");
        Element guard = new Element(GUARD);
        Element mailGuardTime = new Element(MAIL_GUARD_TIME);
        Element alarm = new Element("alarm");
        Element alarmMaxLine = new Element("max_line");
        Element alarmHoldPeriod = new Element("hold_period_day");
        Element statistics = new Element(STATISTICS);
        Element statisticsMaxLine = new Element("max_line");
        Element statisticsHoldPeriod = new Element("hold_period_day");
        confElement.addContent((Content)engine);
        engine.addContent((Content)port);
        if (updateResourceInfo.getEnginePort() != null) {
            port.setAttribute(new Attribute(XML_FILE_VALUE, updateResourceInfo.getEnginePort()));
        } else {
            port.setAttribute(new Attribute(XML_FILE_VALUE, this.enginePort));
        }
        engine.addContent((Content)allowHost);
        if (updateResourceInfo.getEngineAllowHost() != null) {
            allowHost.setAttribute(new Attribute(XML_FILE_VALUE, updateResourceInfo.getEngineAllowHost()));
        } else {
            allowHost.setAttribute(new Attribute(XML_FILE_VALUE, this.engineAllowHost));
        }
        confElement.addContent((Content)database);
        database.addContent((Content)databaseName);
        database.addContent((Content)driver);
        database.addContent((Content)url);
        database.addContent((Content)user);
        database.addContent((Content)password);
        databaseName.setAttribute(new Attribute(XML_FILE_VALUE, updateResourceInfo.getDatabaseName()));
        driver.setAttribute(new Attribute(XML_FILE_VALUE, updateResourceInfo.getDatabaseDriver()));
        url.setAttribute(new Attribute(XML_FILE_VALUE, updateResourceInfo.getDatabaseUrl()));
        user.setAttribute(new Attribute(XML_FILE_VALUE, updateResourceInfo.getDatabaseUser()));
        password.setAttribute(new Attribute(XML_FILE_VALUE, updateResourceInfo.getDatabasePassword()));
        confElement.addContent((Content)snmp);
        String snmpPortString = "";
        String snmpTrapPortString = "";
        try {
            snmpPortString = Integer.toString(updateResourceInfo.getSnmpPort());
            snmpTrapPortString = Integer.toString(updateResourceInfo.getSnmpTrapPort());
        }
        catch (NumberFormatException numberFormatException) {
            snmpPortString = Integer.toString(161);
            snmpTrapPortString = Integer.toString(162);
        }
        snmp.addContent((Content)snmpPort);
        snmp.addContent((Content)snmpTrapPort);
        snmpPort.setAttribute(new Attribute(XML_FILE_VALUE, snmpPortString));
        snmpTrapPort.setAttribute(new Attribute(XML_FILE_VALUE, snmpTrapPortString));
        snmp.addContent((Content)snmpV1Timeout);
        snmp.addContent((Content)snmpV1Retry);
        snmpV1Timeout.setAttribute(new Attribute(XML_FILE_VALUE, updateResourceInfo.getSnmpV1Timeout()));
        snmpV1Retry.setAttribute(new Attribute(XML_FILE_VALUE, updateResourceInfo.getSnmpV1Retry()));
        snmp.addContent((Content)snmpV2Timeout);
        snmp.addContent((Content)snmpV2Retry);
        snmpV2Timeout.setAttribute(new Attribute(XML_FILE_VALUE, updateResourceInfo.getSnmpV2Timeout()));
        snmpV2Retry.setAttribute(new Attribute(XML_FILE_VALUE, updateResourceInfo.getSnmpV2Retry()));
        snmp.addContent((Content)snmpV3Timeout);
        snmp.addContent((Content)snmpV3Retry);
        snmpV3Timeout.setAttribute(new Attribute(XML_FILE_VALUE, updateResourceInfo.getSnmpV3Timeout()));
        snmpV3Retry.setAttribute(new Attribute(XML_FILE_VALUE, updateResourceInfo.getSnmpV3Retry()));
        confElement.addContent((Content)ping);
        ping.addContent((Content)pingTimeout);
        ping.addContent((Content)pingRetry);
        pingTimeout.setAttribute(new Attribute(XML_FILE_VALUE, updateResourceInfo.getPingTimeout()));
        pingRetry.setAttribute(new Attribute(XML_FILE_VALUE, updateResourceInfo.getPingRetry()));
        confElement.addContent((Content)xmlsocket);
        xmlsocket.addContent((Content)alertSound);
        xmlsocket.addContent((Content)refreshTime);
        xmlsocket.addContent((Content)xmlsocketAllowHost);
        xmlsocket.addContent((Content)xmlsocketPort);
        xmlsocket.addContent((Content)xmlsocketMaxconnect);
        alertSound.setAttribute(new Attribute(XML_FILE_VALUE, updateResourceInfo.getAlertSound()));
        refreshTime.setAttribute(new Attribute(XML_FILE_VALUE, updateResourceInfo.getRefreshTime()));
        xmlsocketAllowHost.setAttribute(new Attribute(XML_FILE_VALUE, updateResourceInfo.getXmlsocketAllowHost()));
        xmlsocketPort.setAttribute(new Attribute(XML_FILE_VALUE, updateResourceInfo.getXmlSocketPort()));
        xmlsocketMaxconnect.setAttribute(new Attribute(XML_FILE_VALUE, updateResourceInfo.getXmlSocketMaxConnect()));
        confElement.addContent((Content)mailFilterEl);
        mailFilterEl.addContent((Content)mailFilterErrorLevel);
        mailFilterEl.addContent((Content)mailFilterFlag);
        mailFilterEl.addContent((Content)mailFilterString);
        if (updateResourceInfo.getMailFilterErrorLevel() != null) {
            mailFilterErrorLevel.setAttribute(new Attribute(XML_FILE_VALUE, updateResourceInfo.getMailFilterErrorLevel()));
        } else {
            mailFilterErrorLevel.setAttribute(new Attribute(XML_FILE_VALUE, this.resourceInfo.getMailFilterErrorLevel()));
        }
        if (updateResourceInfo.getMailFilterErrorLevel() != null) {
            if (updateResourceInfo.isMailFilterStringFlag()) {
                mailFilterFlag.setAttribute(new Attribute(XML_FILE_VALUE, "on"));
            } else {
                mailFilterFlag.setAttribute(new Attribute(XML_FILE_VALUE, "off"));
            }
        } else if (this.resourceInfo.isMailFilterStringFlag()) {
            mailFilterFlag.setAttribute(new Attribute(XML_FILE_VALUE, "on"));
        } else {
            mailFilterFlag.setAttribute(new Attribute(XML_FILE_VALUE, "off"));
        }
        if (updateResourceInfo.getMailFilterString() != null) {
            mailFilterString.setAttribute(new Attribute(XML_FILE_VALUE, updateResourceInfo.getMailFilterString()));
        } else {
            mailFilterString.setAttribute(new Attribute(XML_FILE_VALUE, this.resourceInfo.getMailFilterString()));
        }
        confElement.addContent((Content)unregistrationNodeEl);
        unregistrationNodeEl.addContent((Content)unregistrationNodeAlarm);
        if (updateResourceInfo.getUnregistrationNodeAlarm() != null) {
            unregistrationNodeAlarm.setAttribute(new Attribute(XML_FILE_VALUE, updateResourceInfo.getUnregistrationNodeAlarm()));
        } else {
            unregistrationNodeAlarm.setAttribute(new Attribute(XML_FILE_VALUE, this.resourceInfo.getUnregistrationNodeAlarm()));
        }
        confElement.addContent((Content)guard);
        guard.addContent((Content)mailGuardTime);
        mailGuardTime.setAttribute(new Attribute(XML_FILE_VALUE, updateResourceInfo.getMailGuardTime()));
        confElement.addContent((Content)alarm);
        alarm.addContent((Content)alarmHoldPeriod);
        alarm.addContent((Content)alarmMaxLine);
        alarmHoldPeriod.setAttribute(new Attribute(XML_FILE_VALUE, updateResourceInfo.getAlarmHoldPeriodDay()));
        alarmMaxLine.setAttribute(new Attribute(XML_FILE_VALUE, updateResourceInfo.getAlarmMax()));
        confElement.addContent((Content)statistics);
        statistics.addContent((Content)statisticsHoldPeriod);
        statistics.addContent((Content)statisticsMaxLine);
        statisticsHoldPeriod.setAttribute(new Attribute(XML_FILE_VALUE, updateResourceInfo.getStatisticsHoldPeriodDay()));
        statisticsMaxLine.setAttribute(new Attribute(XML_FILE_VALUE, updateResourceInfo.getStatisticsMax()));
        MailProperty[] mailProp = updateResourceInfo.getMailPropertyList();
        Element[] mail = new Element[mailProp.length];
        Element[] mailSend = new Element[mailProp.length];
        Element[] smtpHost = new Element[mailProp.length];
        Element[] mailFrom = new Element[mailProp.length];
        int i = 0;
        while (i < mailProp.length) {
            mail[i] = new Element(MAIL);
            mailSend[i] = new Element(MAIL_SEND);
            smtpHost[i] = new Element(MAIL_SMTP_HOST);
            mailFrom[i] = new Element(MAIL_FROM);
            confElement.addContent((Content)mail[i]);
            mail[i].addContent((Content)smtpHost[i]);
            mail[i].addContent((Content)mailSend[i]);
            mail[i].addContent((Content)mailFrom[i]);
            smtpHost[i].setAttribute(new Attribute(XML_FILE_VALUE, mailProp[i].getSmtpHost()));
            mailSend[i].setAttribute(new Attribute(XML_FILE_VALUE, mailProp[i].getMailSendFlag()));
            mailFrom[i].setAttribute(new Attribute(XML_FILE_VALUE, mailProp[i].getFrom()));
            String[] toArray = mailProp[i].getTo();
            Element[] mailTo = new Element[toArray.length];
            Element[] to = new Element[toArray.length];
            int j = 0;
            while (j < toArray.length) {
                mailTo[j] = new Element(MAIL_TO_LIST);
                mail[i].addContent((Content)mailTo[j]);
                to[j] = new Element(MAIL_TO);
                mailTo[j].addContent((Content)to[j]);
                to[j].setAttribute(new Attribute(XML_FILE_VALUE, toArray[j]));
                ++j;
            }
            ++i;
        }
        return doc;
    }
}

