/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.server.protocol.smtp;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Properties;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.LastCheckTimeUpDate;
import netjfwatcher.engine.alarm.AlarmMessageMake;
import netjfwatcher.engine.alarm.AlarmRecovery;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;

public class ExecuteSMTPCheck {
    private static final boolean IS_SHOW_MESSAGE = false;
    public static final String MAIL_ENCODING = "iso-2022-jp";
    public static final String SMTP_TEST_MAIL_FROM = "netjfwatcher";
    public static final String SMTP_TEST_MAIL_TITLE = "SMTP Test mail";
    private static Logger logger = null;

    public ExecuteSMTPCheck() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void checkSmtp(NodeWatchInfo nodeInfo) {
        String smtpHost = nodeInfo.getIpaddress();
        String sendAddress = nodeInfo.getSmtpTestAddress();
        String smtpPort = "25";
        String smtpTimeout = nodeInfo.getSmtpTimeout();
        try {
            Properties props = System.getProperties();
            int port = 0;
            try {
                port = Integer.parseInt(nodeInfo.getSmtpPort());
                smtpPort = nodeInfo.getSmtpPort();
                props.put("mail.smtp.port", smtpPort);
            }
            catch (NumberFormatException numberFormatException) {
                logger.warning("Illegal SMTP Port = " + port + " , param = " + nodeInfo.getSmtpPort());
            }
            try {
                int timeout = Integer.parseInt(smtpTimeout);
                if (timeout > 0) {
                    props.put("mail.smtp.connectiontimeout", smtpTimeout);
                    props.put("mail.smtp.timeout", smtpTimeout);
                }
            }
            catch (NumberFormatException numberFormatException) {
                logger.warning("Illegal SMTP Timeout = " + smtpTimeout);
            }
            props.put("mail.smtp.host", smtpHost);
            Session session = Session.getDefaultInstance((Properties)props, null);
            MimeMessage mimeMessage = new MimeMessage(session);
            mimeMessage.setFrom((Address)new InternetAddress("NetWatch@" + smtpHost, SMTP_TEST_MAIL_FROM, MAIL_ENCODING));
            mimeMessage.setRecipients(Message.RecipientType.TO, sendAddress);
            mimeMessage.setSubject(SMTP_TEST_MAIL_TITLE, MAIL_ENCODING);
            mimeMessage.setText("<h1>Hello World JavaMail</h1>", MAIL_ENCODING);
            mimeMessage.setHeader("Content-Type", "text/html");
            mimeMessage.setSentDate(Calendar.getInstance().getTime());
            Transport.send((Message)mimeMessage);
            this.checkPop(nodeInfo);
            if (AlarmRecovery.getInstance().isOccurredAlarmId(nodeInfo.getIpaddress(), "21")) {
                AlarmMessageMake message = AlarmMessageMake.getInstance();
                message.setRecoverySmtpError(nodeInfo.getIpaddress(), "SMTP server = " + smtpHost);
            }
        }
        catch (IllegalStateException e) {
            logger.warning(e.getMessage());
            AlarmMessageMake makeAlarm = AlarmMessageMake.getInstance();
            makeAlarm.setSmtpError(nodeInfo.getIpaddress(), "IllegalStateException : " + e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            logger.warning(e.getMessage());
            AlarmMessageMake makeAlarm = AlarmMessageMake.getInstance();
            makeAlarm.setSmtpError(nodeInfo.getIpaddress(), "UnsupportedEncodingException : " + e.getMessage());
        }
        catch (MessagingException e) {
            logger.warning(e.getMessage());
            AlarmMessageMake makeAlarm = AlarmMessageMake.getInstance();
            makeAlarm.setSmtpError(nodeInfo.getIpaddress(), "MessagingException : " + e.getMessage());
        }
        catch (IOException e) {
            logger.warning(e.getMessage());
            AlarmMessageMake makeAlarm = AlarmMessageMake.getInstance();
            makeAlarm.setSmtpError(nodeInfo.getIpaddress(), "IOException : " + e.getMessage());
        }
        try {
            LastCheckTimeUpDate updateLastCheckTime = LastCheckTimeUpDate.getInstance();
            updateLastCheckTime.updateCheckTime(nodeInfo.getIpaddress());
        }
        catch (DatabaseConnectionException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
        catch (SQLException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
    }

    private void checkPop(NodeWatchInfo nodeInfo) throws UnsupportedEncodingException, MessagingException, IOException {
        String pop3Host = nodeInfo.getSmtpCheckPop3Host();
        String pop3User = nodeInfo.getSmtpCheckPop3User();
        String pop3Password = nodeInfo.getSmtpCheckPop3Password();
        String pop3Port = nodeInfo.getSmtpCheckPop3Port();
        String pop3Timeout = nodeInfo.getSmtpCheckPop3Timeout();
        if (pop3Host == null || pop3Host.equals("") || pop3User == null || pop3User.equals("") || pop3Password == null || pop3Password.equals("")) {
            return;
        }
        int popPort = -1;
        try {
            popPort = Integer.parseInt(pop3Port);
        }
        catch (NumberFormatException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        }
        Properties props = System.getProperties();
        try {
            int timeout = Integer.parseInt(pop3Timeout);
            if (timeout > 0) {
                props.put("mail.pop3.connectiontimeout", pop3Timeout);
                props.put("mail.pop3.timeout", pop3Timeout);
            }
        }
        catch (NumberFormatException e2) {
            logger.warning(e2.getMessage());
            e2.printStackTrace();
        }
        Store store = null;
        Folder folder = null;
        try {
            Session session = Session.getDefaultInstance((Properties)props, null);
            store = session.getStore("pop3");
            store.connect(pop3Host, popPort, pop3User, pop3Password);
            folder = store.getFolder("INBOX");
            folder.open(2);
            int totalMessages = folder.getMessageCount();
            if (totalMessages == 0) {
                return;
            }
            Message[] messages = folder.getMessages();
            int i = 0;
            while (i < messages.length) {
                this.checkReceiveMessage(messages[i]);
                ++i;
            }
        }
        finally {
            if (folder != null && folder.isOpen()) {
                try {
                    folder.close(true);
                }
                catch (MessagingException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }
            if (store != null && store.isConnected()) {
                try {
                    store.close();
                }
                catch (MessagingException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }
        }
    }

    private void checkReceiveMessage(Message msg) throws MessagingException, UnsupportedEncodingException {
        String checkSubject;
        String checkFrom = "";
        int isMuchFrom = -1;
        Address[] addr = msg.getFrom();
        if (addr != null) {
            checkFrom = MimeUtility.decodeText((String)addr[0].toString());
            isMuchFrom = checkFrom.indexOf(SMTP_TEST_MAIL_FROM);
        }
        if ((checkSubject = msg.getSubject()).equals(SMTP_TEST_MAIL_TITLE) && isMuchFrom >= 0) {
            msg.setFlag(Flags.Flag.DELETED, true);
        }
    }

    private void showMessage(NodeWatchInfo nodeInfo, Message msg) throws UnsupportedEncodingException, MessagingException, IOException {
        int j;
        Address[] addr = msg.getFrom();
        if (addr != null) {
            j = 0;
            while (j < addr.length) {
                logger.info("From : " + MimeUtility.decodeText((String)addr[j].toString()));
                ++j;
            }
        }
        if ((addr = msg.getRecipients(Message.RecipientType.TO)) != null) {
            j = 0;
            while (j < addr.length) {
                logger.info("To : " + MimeUtility.decodeText((String)addr[j].toString()));
                ++j;
            }
        }
        logger.info("Subject : " + msg.getSubject());
        logger.info("Size : " + msg.getSize());
        logger.info("Contents\uff1a\n" + msg.getContent());
    }
}

