/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.socket;

import java.io.IOException;
import java.util.logging.Logger;
import netjfwatcher.engine.socket.AbstractConnectionEngine;
import netjfwatcher.engine.socket.CommandInfo;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.GarbageCollectionControl;

public class ConnectionGarbageCollection
extends AbstractConnectionEngine {
    public static final String SUB_COMMAND_ID_GARBAGECOLLECTION_START = "Start";
    public static final String SUB_COMMAND_ID_GARBAGECOLLECTION_STOP = "Stop";
    public static final String SUB_COMMAND_ID_GARBAGECOLLECTION_GET = "Get";
    public static final String SUB_COMMAND_ID_GARBAGECOLLECTION_CHECK = "Check";
    private static Logger logger = null;
    private GarbageCollectionControl controlInfo = new GarbageCollectionControl();
    private GarbageCollectionControl responseControlInfo;

    public ConnectionGarbageCollection(String engineAddress) {
        super(engineAddress);
        logger = Logger.getLogger(this.getClass().getName());
    }

    public GarbageCollectionControl startGarbageCollection(String interval) throws EngineConnectException, IOException {
        CommandInfo commnadInfo = new CommandInfo();
        long threadInterval = 5L;
        try {
            threadInterval = Long.parseLong(interval);
        }
        catch (NumberFormatException e) {
            logger.warning("GarbageCollection thread interval NumberFormatException");
            e.printStackTrace();
        }
        this.controlInfo.setIntervalTime(threadInterval * 1000L);
        this.controlInfo.setCommand(SUB_COMMAND_ID_GARBAGECOLLECTION_START);
        commnadInfo.setGarbageCollectionControlInfo(this.controlInfo);
        commnadInfo.setCode("GarbageCollection start");
        this.responseControlInfo = (GarbageCollectionControl)this.communicationToEngine(commnadInfo);
        return this.responseControlInfo;
    }

    public GarbageCollectionControl stopGarbageCollection() throws EngineConnectException, IOException {
        CommandInfo commnadInfo = new CommandInfo();
        this.controlInfo.setCommand(SUB_COMMAND_ID_GARBAGECOLLECTION_STOP);
        commnadInfo.setGarbageCollectionControlInfo(this.controlInfo);
        commnadInfo.setCode("GarbageCollection start");
        this.responseControlInfo = (GarbageCollectionControl)this.communicationToEngine(commnadInfo);
        return this.responseControlInfo;
    }

    public GarbageCollectionControl getGarbageCollectionInfo(String startTime, String endTime) throws EngineConnectException, IOException {
        CommandInfo commnadInfo = new CommandInfo();
        this.controlInfo.setCommand(SUB_COMMAND_ID_GARBAGECOLLECTION_GET);
        this.controlInfo.setStartTime(startTime);
        this.controlInfo.setEndTime(endTime);
        commnadInfo.setGarbageCollectionControlInfo(this.controlInfo);
        commnadInfo.setCode("GarbageCollection start");
        this.responseControlInfo = (GarbageCollectionControl)this.communicationToEngine(commnadInfo);
        return this.responseControlInfo;
    }
}

