/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.view.editorpart.alarm;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;
import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.common.view.TableListViewColor;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableAlarm;
import netjfwatcher.engine.model.action.ActionBuilderAlarmList;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.socket.info.AlarmInformation;
import netjfwatcher.engine.view.editorpart.alarm.AlarmListTableViewContentProvider;
import netjfwatcher.engine.view.editorpart.alarm.AlarmListTableViewLabelProvider;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class AlarmListTableView
extends AbstractTableView {
    private static final int COUNT_TEXT_WIDTH = 100;
    private static boolean isCol0Direction = false;
    private static boolean isCol1Direction = true;
    private static boolean isCol2Direction = true;
    private static boolean isCol3Direction = true;
    private static boolean isCol4Direction = true;
    private static final int[] IMAGE_COLUMN = new int[]{4};
    private static Logger logger = null;
    private static Table table;
    private static Text alarmCountText;
    private static Button refreshButton;
    private static TableViewer viewer;
    private static SubStatusLineManager statusLineManager;
    private static final float COLUMN0NO = 0.03f;
    private static final float COLUMN1NAME = 0.1f;
    private static final float COLUMN2ADDRESS = 0.1f;
    private static final float COLUMN3REGDATE = 0.1f;
    private static final float COLUMN4MESSAGE = 0.15f;
    private AlarmAction alarmAction = new AlarmAction();

    public AlarmListTableView() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    public void setFocus() {
    }

    public TableViewer getViewer() {
        return viewer;
    }

    public void createPartControl(Composite parent) {
        this.createTable(parent);
        viewer = new TableViewer(table);
        viewer.setUseHashlookup(true);
        viewer.setContentProvider((IContentProvider)new AlarmListTableViewContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new AlarmListTableViewLabelProvider());
        this.createContextMenu();
        this.initActions();
        this.setAlarmListTableView();
    }

    private int computeCol0Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.03f);
    }

    private int computeCol1Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    private int computeCol2Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    private int computeCol3Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    private int computeCol4Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.15f);
    }

    private void createTable(Composite parent) {
        statusLineManager = (SubStatusLineManager)this.getViewSite().getActionBars().getStatusLineManager();
        statusLineManager.setVisible(true);
        int snmpPort = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo().getSnmpPort();
        statusLineManager.setMessage("Snmp Port=" + snmpPort);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        parent.setLayout((Layout)gridLayout);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new RowLayout(256));
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        Label labelAddress = new Label(composite, 0);
        labelAddress.setText("Alarm count");
        alarmCountText = new Text(composite, 133120);
        alarmCountText.setLayoutData((Object)new RowData(100, -1));
        refreshButton = new Button(composite, 0);
        refreshButton.setText("Refresh");
        GridData data2 = new GridData();
        data2.horizontalAlignment = 4;
        data2.verticalAlignment = 4;
        data2.grabExcessHorizontalSpace = true;
        data2.grabExcessVerticalSpace = true;
        table = new Table(parent, 66304);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)data2);
        refreshButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                refreshButton.setEnabled(false);
                AlarmListTableView.this.setAlarmListTableView();
                refreshButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        TableColumn col0 = new TableColumn(table, 0x1000000);
        col0.setText(AlarmListTableViewLabelProvider.ALARM_LIST_TABLE_COLUMNS[0]);
        col0.setWidth(this.computeCol0Width());
        TableColumn col1 = new TableColumn(table, 0x1000000);
        col1.setText(AlarmListTableViewLabelProvider.ALARM_LIST_TABLE_COLUMNS[1]);
        col1.setWidth(this.computeCol1Width());
        TableColumn col2 = new TableColumn(table, 0x1000000);
        col2.setText(AlarmListTableViewLabelProvider.ALARM_LIST_TABLE_COLUMNS[2]);
        col2.setWidth(this.computeCol2Width());
        TableColumn col3 = new TableColumn(table, 0x1000000);
        col3.setText(AlarmListTableViewLabelProvider.ALARM_LIST_TABLE_COLUMNS[4]);
        col3.setWidth(this.computeCol3Width());
        TableColumn col4 = new TableColumn(table, 0x1000000);
        col4.setText(AlarmListTableViewLabelProvider.ALARM_LIST_TABLE_COLUMNS[5]);
        col4.setWidth(this.computeCol4Width());
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
            }
        });
        col0.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                isCol0Direction = AlarmListTableView.this.sortIntegerTable(table, 0, isCol0Direction, IMAGE_COLUMN);
            }
        });
        col1.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                isCol1Direction = AlarmListTableView.this.sortTable(table, 1, isCol1Direction, IMAGE_COLUMN);
            }
        });
        col2.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                isCol2Direction = AlarmListTableView.this.sortTable(table, 2, isCol2Direction, IMAGE_COLUMN);
            }
        });
        col3.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                isCol3Direction = AlarmListTableView.this.sortTable(table, 3, isCol3Direction, IMAGE_COLUMN);
            }
        });
        col4.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                isCol4Direction = AlarmListTableView.this.sortTable(table, 4, isCol4Direction, IMAGE_COLUMN);
            }
        });
    }

    protected TableItem setTableItem(Table paraTable, TableItem item, String[] strs) {
        Color obj = item.getForeground();
        item.dispose();
        item = new TableItem(paraTable, 0);
        item.setText(strs);
        item.setData((Object)strs);
        item.setForeground(obj);
        return item;
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add(this.alarmAction.getActionShowAllNodeAlarmListTable());
        if (table.getSelectionIndex() >= 0 && table.getSelection() != null) {
            TableItem[] item = table.getSelection();
            String[] alarmInfo = (String[])item[0].getData();
            ((ActionBuilderAlarmList.ActionConfirmAlarm)this.alarmAction.getActionConfirmAlarm()).setConfirmAlarm(alarmInfo[0], alarmInfo[4]);
            manager.add(this.alarmAction.getActionConfirmAlarm());
        }
        ((ActionBuilderAlarmList.ActionConfirmAllAlarm)this.alarmAction.getActionConfirmAllAlarm()).setAlarmIPAddress("all");
        manager.add(this.alarmAction.getActionConfirmAllAlarm());
    }

    private void createContextMenu() {
        MenuManager mm = new MenuManager();
        mm.setRemoveAllWhenShown(true);
        mm.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AlarmListTableView.this.fillContextMenu(manager);
            }
        });
        Menu menu = mm.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(mm, (ISelectionProvider)viewer);
    }

    private void initActions() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add(this.alarmAction.getActionShowAllNodeAlarmListTable());
    }

    public void setAlarmListTableView() {
        table.removeAll();
        viewer.refresh();
        ArrayList alarmInfoList = this.getAlarmList();
        if (alarmInfoList == null) {
            return;
        }
        alarmCountText.setText(Integer.toString(alarmInfoList.size()));
        int i = 0;
        while (i < alarmInfoList.size()) {
            String[] alarmCellArray = new String[AlarmListTableViewLabelProvider.ALARM_LIST_TABLE_COLUMNS.length];
            AlarmInformation alarmInfo = (AlarmInformation)alarmInfoList.get(i);
            alarmCellArray[0] = alarmInfo.getAlarmID();
            alarmCellArray[1] = alarmInfo.getAlarmDate();
            alarmCellArray[2] = alarmInfo.getNodename();
            alarmCellArray[4] = alarmInfo.getIpaddress();
            alarmCellArray[5] = alarmInfo.getAlarmMessage();
            TableItem item = new TableItem(table, 0);
            item.setText(alarmCellArray);
            item.setData((Object)alarmCellArray);
            if (alarmInfo.getAlarmLevel().equals("ERROR")) {
                item.setForeground(TableListViewColor.getInstance().getAlarmErrorLevelColor());
            } else if (alarmInfo.getAlarmLevel().equals("WARNING")) {
                item.setForeground(TableListViewColor.getInstance().getAlarmWarningLevelColor());
            } else if (alarmInfo.getAlarmLevel().equals("INFO")) {
                item.setForeground(TableListViewColor.getInstance().getAlarmInfoLevelColor());
            } else {
                logger.warning("Unknown alarm level : " + alarmInfo.getAlarmLevel());
            }
            ++i;
        }
    }

    public ArrayList getAlarmList() {
        ArrayList alarmInfoList = null;
        DBTableAlarm alarmDBTable = DBTableAlarm.getInstance();
        try {
            alarmInfoList = alarmDBTable.findAllAlarm(0, "all", null, null);
        }
        catch (SQLException e) {
            Shell shell = new Shell();
            MessageDialog.openError((Shell)shell, (String)"Alarm List import error", (String)e.getMessage());
            logger.warning("Alarm List import error " + e.getMessage());
            shell.dispose();
            return alarmInfoList;
        }
        catch (DatabaseConnectionException e) {
            Shell shell = new Shell();
            MessageDialog.openError((Shell)shell, (String)"Alarm List import error", (String)e.getMessage());
            logger.warning("Alarm List import error " + e.getMessage());
            shell.dispose();
            return alarmInfoList;
        }
        return alarmInfoList;
    }

    protected void setResizedTableColumnWidth() {
    }

    private final class AlarmAction
    extends ActionBuilderAlarmList {
        private AlarmAction() {
        }

        public void refreshNodeAlarmTable() {
            AlarmListTableView.this.setAlarmListTableView();
        }
    }
}

