/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmp.mibtree;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.snmp.mibtree.MibInfo;
import org.osgi.framework.Bundle;

public abstract class AbstractMibTree {
    public static final String INTEGER = "INTEGER";
    public static final String COUNTER32 = "Counter32";
    public static final String COUNTER64 = "Counter64";
    public static final String GAUGE32 = "Gauge32";
    public static final String OCTETSTRING = "OctetString";
    public static final String IPADDRESS = "IpAddress";
    public static final String OBJECTID = "ObjectID";
    public static final String TIMETICKS = "TimeTicks";
    public static final String UINTEGER32 = "Uinteger32";
    public static final String BITS = "Bits";
    public static final String OPAQUE = "Opaque";
    public static final String DISPLAYSTRING = "DisplayString";
    private static Logger logger;
    public ArrayList<MibInfo> oidList = new ArrayList();
    public HashMap<String, MibInfo> oidHashMap = new HashMap();
    public HashMap<String, MibInfo> mibDescripHashMap = new HashMap();
    public DefaultMutableTreeNode rootTreeNode;

    public AbstractMibTree() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void reloadOidTree(String fileName) {
        this.oidList.clear();
        this.oidHashMap.clear();
        this.mibDescripHashMap.clear();
        this.rootTreeNode = null;
        this.parseCSVFile(fileName);
    }

    public void parseCSVFile(String fileName) {
        this.oidList = new ArrayList();
        int cnt = 0;
        logger.info("Mib table create start ..." + fileName);
        InputStream instream = null;
        InputStreamReader instreamReader = null;
        BufferedReader bufReader = null;
        try {
            try {
                String lineString;
                URL url = this.getDocumentURL(fileName);
                instream = url.openStream();
                instreamReader = new InputStreamReader(instream);
                bufReader = new BufferedReader(instreamReader);
                while ((lineString = bufReader.readLine()) != null) {
                    if (lineString.indexOf("#") >= 0) continue;
                    Pattern pattern = Pattern.compile(",");
                    String[] mibLineItemArray = pattern.split(lineString);
                    try {
                        if (mibLineItemArray.length != 4) {
                            logger.info(lineString);
                        } else {
                            this.oidList.add(new MibInfo(mibLineItemArray));
                        }
                    }
                    catch (Exception e1) {
                        logger.warning(lineString);
                        e1.printStackTrace();
                    }
                    ++cnt;
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                logger.severe(e.getMessage());
                e.printStackTrace();
            }
        }
        finally {
            if (bufReader != null) {
                try {
                    bufReader.close();
                }
                catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }
            if (instreamReader != null) {
                try {
                    instreamReader.close();
                }
                catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }
            if (instream != null) {
                try {
                    instream.close();
                }
                catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }
        }
        this.rootTreeNode = this.oidList.get(0).getTreeNode();
        this.setupTreeNode(this.rootTreeNode, this.oidList.get(1).getTreeNode());
        this.oidList.get(1).setParentOid(this.oidList.get(0).getOid());
        int muchParenNodeCnt = 0;
        int parentOidIndexCnt = -1;
        int childNodeCnt = 0;
        while (childNodeCnt < cnt) {
            boolean found = false;
            int parentNodeCnt = 1;
            while (parentNodeCnt < childNodeCnt + 1 && parentNodeCnt + 1 < cnt) {
                String[] item2;
                Pattern pattern;
                String[] item;
                parentOidIndexCnt = this.oidList.get(childNodeCnt).getOid().indexOf(this.oidList.get(parentNodeCnt).getOid());
                if (parentOidIndexCnt == 0 && ((parentOidIndexCnt = this.oidList.get(childNodeCnt).getOid().indexOf(this.oidList.get(parentNodeCnt + 1).getOid())) != 0 || parentNodeCnt + 1 == childNodeCnt || parentOidIndexCnt == 0 && this.oidList.get(childNodeCnt).getLayer() == this.oidList.get(parentNodeCnt + 1).getLayer()) && (item = (pattern = Pattern.compile("[.]")).split(this.oidList.get(parentNodeCnt).getOid()))[item.length - 1].equals((item2 = pattern.split(this.oidList.get(childNodeCnt).getOid()))[item.length - 1]) && parentNodeCnt != childNodeCnt && this.oidList.get(childNodeCnt).getLayer() != this.oidList.get(parentNodeCnt).getLayer()) {
                    muchParenNodeCnt = parentNodeCnt;
                    found = true;
                }
                ++parentNodeCnt;
            }
            if (found) {
                this.setupTreeNode(this.oidList.get(muchParenNodeCnt).getTreeNode(), this.oidList.get(childNodeCnt).getTreeNode());
                this.oidList.get(childNodeCnt).setParentOid(this.oidList.get(muchParenNodeCnt).getOid());
            }
            ++childNodeCnt;
        }
        Enumeration<TreeNode> enumNodeTree = this.oidList.get(0).getTreeNode().preorderEnumeration();
        int oidListCnt = 0;
        while (enumNodeTree.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumNodeTree.nextElement();
            if (this.oidList.get(oidListCnt).getTreeNode().equals(node)) {
                MibInfo miboid = this.oidList.get(oidListCnt);
                if (this.oidList.size() > oidListCnt + 1) {
                    MibInfo nextMibOid = this.oidList.get(oidListCnt + 1);
                    miboid.setNextMibOid(nextMibOid.getOid());
                } else {
                    miboid.setNextMibOid("1.4");
                }
            } else {
                logger.warning("unmuch :tree: " + node + " :array:" + this.oidList.get(oidListCnt).getTreeNode());
                break;
            }
            this.oidHashMap.put(this.oidList.get(oidListCnt).getOid(), this.oidList.get(oidListCnt));
            this.mibDescripHashMap.put(this.oidList.get(oidListCnt).getDescrip(), this.oidList.get(oidListCnt));
            ++oidListCnt;
        }
    }

    public URL getDocumentURL(String fileName) {
        Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
        URL url = null;
        url = bundle.getEntry(fileName);
        if (url == null) {
            logger.severe("MIB defined CSV file : " + fileName);
        }
        return url;
    }

    private void setupTreeNode(Object parentNode, Object childNode) {
        DefaultMutableTreeNode leaf = (DefaultMutableTreeNode)childNode;
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)parentNode;
        parent.add(leaf);
    }

    public HashMap getOidHashMap() {
        return this.oidHashMap;
    }

    public ArrayList getOidList() {
        return this.oidList;
    }

    public HashMap getMibDescripHashMap() {
        return this.mibDescripHashMap;
    }

    public void setOidHashMap(HashMap map) {
        this.oidHashMap = map;
    }

    public void setOidList(ArrayList list) {
        this.oidList = list;
    }
}

