/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmp.snmpobject.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Logger;
import netjfwatcher.snmp.messageformat.SNMPTLV;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;

public abstract class AbstractSnmpObject {
    private static boolean isZeroPadding = false;
    protected String tagDescription;
    protected byte tag;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public abstract Object getValue();

    public abstract void setValue(Object var1) throws SnmpBadValueException;

    public abstract String toString();

    public abstract byte[] getBEREncoding();

    public SNMPTLV extractNextTLV(byte[] enc, int position) {
        int dataLength;
        SNMPTLV nextTLV = new SNMPTLV();
        int currentPos = position;
        if ((enc[currentPos] & 0x1F) == 31) {
            return null;
        }
        if (isZeroPadding ? enc[currentPos] == 0 || enc[currentPos] == 5 : enc[currentPos] == 0) {
            return null;
        }
        nextTLV.setTag(enc[currentPos]);
        int unsignedValue = enc[++currentPos];
        if (unsignedValue < 0) {
            unsignedValue += 256;
        }
        if (unsignedValue / 128 < 1) {
            dataLength = unsignedValue;
        } else {
            int numBytes = unsignedValue % 128;
            dataLength = 0;
            int i = 0;
            while (i < numBytes) {
                if ((unsignedValue = enc[++currentPos]) < 0) {
                    unsignedValue += 256;
                }
                dataLength = dataLength * 256 + unsignedValue;
                ++i;
            }
        }
        nextTLV.setTotalLength(++currentPos - position + dataLength);
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
        try {
            if (enc.length >= currentPos + dataLength) {
                outBytes.write(enc, currentPos, dataLength);
                nextTLV.setValue(outBytes.toByteArray());
                SNMPTLV sNMPTLV = nextTLV;
                return sNMPTLV;
            }
            SNMPTLV sNMPTLV = nextTLV;
            return sNMPTLV;
        }
        finally {
            try {
                outBytes.close();
            }
            catch (IOException e) {
                this.logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public byte[] encodeLength(int length) {
        byte[] outBytesArray = null;
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
        try {
            if (length <= 127) {
                byte[] len = new byte[]{(byte)length};
                outBytes.write(len, 0, 1);
            } else {
                int numBytes = 0;
                int temp = length;
                while (temp > 0) {
                    ++numBytes;
                    temp = (int)Math.floor(temp / 256);
                }
                byte num = (byte)numBytes;
                num = (byte)(num + 128);
                if (isZeroPadding) {
                    outBytes.write(num + 1);
                    outBytes.write(0);
                } else {
                    outBytes.write(num);
                }
                byte[] lenDataByte = new byte[numBytes];
                int workLength = length;
                int i = numBytes - 1;
                while (i >= 0) {
                    lenDataByte[i] = (byte)(workLength % 256);
                    workLength = (int)Math.floor(workLength / 256);
                    --i;
                }
                outBytes.write(lenDataByte, 0, numBytes);
            }
            outBytesArray = outBytes.toByteArray();
        }
        finally {
            try {
                outBytes.close();
            }
            catch (IOException e) {
                this.logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
        return outBytesArray;
    }

    protected String hexByte(byte byteData) {
        int pos = byteData;
        if (pos < 0) {
            pos += 256;
        }
        String returnString = "";
        returnString = String.valueOf(returnString) + Integer.toHexString(pos / 16);
        returnString = String.valueOf(returnString) + Integer.toHexString(pos % 16);
        return returnString;
    }

    public String getTagDescription() {
        return this.tagDescription;
    }

    public String getTagCode() {
        String returnString = String.valueOf(this.tagDescription) + "(" + this.hexByte(this.tag) + ")";
        return returnString;
    }

    public static void setZeroPadding(boolean padFlg) {
        isZeroPadding = padFlg;
    }
}

