/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpagent.model;

import java.util.HashMap;
import java.util.logging.Logger;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.mibtree.AgentMibTree;
import netjfwatcher.snmp.mibtree.MibInfo;
import netjfwatcher.snmp.snmpobject.integer.SnmpCounter32;
import netjfwatcher.snmp.snmpobject.integer.SnmpCounter64;
import netjfwatcher.snmp.snmpobject.integer.SnmpGauge32;
import netjfwatcher.snmp.snmpobject.integer.SnmpInteger;
import netjfwatcher.snmp.snmpobject.integer.SnmpTimeTicks;
import netjfwatcher.snmp.snmpobject.integer.SnmpUInteger32;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.message.SnmpObjectIdentifier;
import netjfwatcher.snmp.snmpobject.octetstring.SnmpOctetString;
import netjfwatcher.snmpagent.model.AgentInstanceDataMap;
import netjfwatcher.snmpagent.model.AgentInstanceDataRefreshQueue;
import netjfwatcher.snmpagent.process.ThreadAgent;

public class AgentMIBCountUpThread
implements Runnable {
    private static final int WAIT_SLEEP_TIME = 1000;
    private static Logger logger;
    private int period;
    private int incrementData;
    private MibInfo oidInfo;

    public AgentMIBCountUpThread(String targetOid, int period, int incrementData) {
        this.period = period;
        this.incrementData = incrementData;
        logger = Logger.getLogger(this.getClass().getName());
        this.oidInfo = AgentInstanceDataMap.getInstance().getAgentInstanceDataInfo(targetOid);
    }

    public void run() {
        while (!Thread.interrupted()) {
            try {
                int value = Integer.parseInt(this.oidInfo.getValue());
                int newData = value + this.incrementData;
                this.oidInfo.setValue(Integer.toString(newData));
                logger.info("new Value : " + this.oidInfo.getValue());
                logger.info("period : " + this.period);
                AgentInstanceDataMap.getInstance().setAgentInstanceDataMap(this.oidInfo.getOid(), this.oidInfo);
                AgentMibTree agentMibTree = AgentMibTree.getInstance();
                HashMap agentOidHashMap = agentMibTree.getOidHashMap();
                MibInfo agentInstanceDataOidInfo = (MibInfo)agentOidHashMap.get(this.oidInfo.getOid());
                AbstractSnmpObject newSnmpObject = this.createSnmpObject(this.oidInfo.getOid(), this.oidInfo.getValue(), this.oidInfo.getSyntax());
                if (newSnmpObject != null) {
                    agentInstanceDataOidInfo.setAgentMibValue(newSnmpObject);
                    agentOidHashMap.put(this.oidInfo.getOid(), agentInstanceDataOidInfo);
                    agentMibTree.setOidHashMap(agentOidHashMap);
                    AgentInstanceDataRefreshQueue.getInstance().pushQueue(this.oidInfo);
                }
                Thread.sleep(this.period * 1000);
            }
            catch (InterruptedException e) {
                logger.info(e.getMessage());
                break;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AbstractSnmpObject createSnmpObject(String oid, String value, String oidType) {
        AbstractSnmpObject newSnmpObject = null;
        if (oidType.equals("INTEGER")) {
            newSnmpObject = new SnmpInteger();
            try {
                newSnmpObject.setValue(value);
                return newSnmpObject;
            }
            catch (SnmpBadValueException snmpBadValueException) {
                return null;
            }
        }
        if (oidType.equals("Counter32")) {
            newSnmpObject = new SnmpCounter32();
            try {
                newSnmpObject.setValue(value);
                return newSnmpObject;
            }
            catch (SnmpBadValueException snmpBadValueException) {
                return null;
            }
        }
        if (oidType.equals("Counter64")) {
            newSnmpObject = new SnmpCounter64();
            try {
                newSnmpObject.setValue(value);
                return newSnmpObject;
            }
            catch (SnmpBadValueException snmpBadValueException) {
                return null;
            }
        }
        if (oidType.equals("Gauge32")) {
            newSnmpObject = new SnmpGauge32();
            try {
                newSnmpObject.setValue(value);
                return newSnmpObject;
            }
            catch (SnmpBadValueException snmpBadValueException) {
                return null;
            }
        }
        if (oidType.equals("Uinteger32")) {
            newSnmpObject = new SnmpUInteger32();
            try {
                newSnmpObject.setValue(value);
                return newSnmpObject;
            }
            catch (SnmpBadValueException snmpBadValueException) {
                return null;
            }
        }
        if (oidType.equals("ObjectID")) {
            newSnmpObject = new SnmpObjectIdentifier();
            try {
                newSnmpObject.setValue(value);
                return newSnmpObject;
            }
            catch (SnmpBadValueException snmpBadValueException) {
                return null;
            }
        }
        if (oidType.equals("TimeTicks")) {
            newSnmpObject = new SnmpTimeTicks();
            try {
                newSnmpObject.setValue(value);
                if (!oid.equals("1.3.6.1.2.1.1.3.0")) return newSnmpObject;
                long sysupTimeMills = System.currentTimeMillis() - Long.parseLong(value) * 1000L;
                ThreadAgent.getInstance().setStartSnmpAgentEngineTime(sysupTimeMills);
                return newSnmpObject;
            }
            catch (SnmpBadValueException snmpBadValueException) {
                return null;
            }
        }
        if (!oidType.equals("OctetString")) return newSnmpObject;
        newSnmpObject = new SnmpOctetString();
        try {
            newSnmpObject.setValue(value);
            return newSnmpObject;
        }
        catch (SnmpBadValueException snmpBadValueException) {
            return null;
        }
    }

    public MibInfo getOidInfo() {
        return this.oidInfo;
    }

    public int getIncrementData() {
        return this.incrementData;
    }

    public int getPeriod() {
        return this.period;
    }
}

