/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpagent.preferences;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherApplication;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.resource.SnmpAgentConfigInfo;
import netjfwatcher.engine.resource.SnmpV3AgentConfig;
import netjfwatcher.engine.resource.SnmpV3AgentConfigInfo;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jdom.Document;

public class SnmpAgentPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final int TEXT_WIDTH = 120;
    private static Logger logger;
    private Text allowHostText;
    private Text roCommunityText;
    private Text rwCommunityText;

    public void init(IWorkbench workbench) {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.setPreferenceStore(NetJFWatcherPlugin.getInstance().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        SnmpAgentConfigInfo snmpAgentInfo = SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo().getSnmpAgentResourceInfo();
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout((Layout)layout);
        GridData gridData = null;
        GridLayout gridLayout = new GridLayout(2, false);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(256));
        gridData = new GridData();
        Label label = new Label(composite, 0);
        label.setText("Allow-Host");
        label.setLayoutData((Object)new GridData());
        this.allowHostText = new Text(composite, 2048);
        this.allowHostText.setText(snmpAgentInfo.getAllowHost());
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.allowHostText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Read Community");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.roCommunityText = new Text(composite, 2048);
        this.roCommunityText.setText(snmpAgentInfo.getReadCommunity());
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.roCommunityText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Write Community");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.rwCommunityText = new Text(composite, 2048);
        this.rwCommunityText.setText(snmpAgentInfo.getWriteCommunity());
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.rwCommunityText.setLayoutData((Object)gridData);
        return composite;
    }

    protected void performDefaults() {
        SnmpAgentConfigInfo info = SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo().getSnmpAgentResourceInfo();
        this.allowHostText.setText(info.getAllowHost());
        this.roCommunityText.setText(info.getReadCommunity());
        this.rwCommunityText.setText(info.getWriteCommunity());
    }

    public boolean performOk() {
        SnmpAgentConfigInfo info = SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo().getSnmpAgentResourceInfo();
        SnmpV3AgentConfigInfo snmpV3Info = SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo().getSnmpV3AgentResourceInfo();
        info.setAllowHost(this.allowHostText.getText());
        info.setReadCommunity(this.roCommunityText.getText());
        info.setWriteCommunity(this.rwCommunityText.getText());
        Document dom = SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo().updateDocument(info, snmpV3Info);
        BufferedWriter bufWriter = null;
        bufWriter = SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo().getResourceFileWriter();
        SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo().outputXMLFile(bufWriter, dom);
        if (bufWriter != null) {
            try {
                bufWriter.close();
            }
            catch (IOException e) {
                logger.warning("Abort close BufferedWriter for snmp V3 agent resource : " + e.getMessage());
                e.printStackTrace();
            }
        }
        if (NetJFWatcherApplication.getAgentOperationView() != null) {
            NetJFWatcherApplication.getAgentOperationView().updateSnmpAgentInfo();
        }
        return super.performOk();
    }
}

