/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpagent.preferences;

import java.io.BufferedWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherApplication;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.resource.SnmpAgentConfigInfo;
import netjfwatcher.engine.resource.SnmpV3AgentConfig;
import netjfwatcher.engine.resource.SnmpV3AgentConfigInfo;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jdom.Document;

public class SnmpV3AgentEnginePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final int ENGINEID_FORMAT_IPV4_ADR_TYPE_SELECT_NO = 0;
    private static final int ENGINEID_FORMAT_IPV6_ADR_TYPE_SELECT_NO = 1;
    private static final int ENGINEID_FORMAT_MAC_ADR_TYPE_SELECT_NO = 2;
    private static final int ENGINEID_FORMAT_TEXT_TYPE_SELECT_NO = 3;
    private static final int ENGINEID_FORMAT_OCTETS_TYPE_SELECT_NO = 4;
    private static final int ENGINEID_TEXT_WIDTH = 250;
    private static final int ENGINE_FORMAT_TEXT_WIDTH = 200;
    private static final int TEXT_WIDTH = 120;
    private static final int MAXIMUM_LENGTH = 27;
    private static Logger logger;
    private static final String[] ENGINE_ID_FORMAT;
    private String enterpriseID;
    private String engineIDFormatIndex;
    private String engineIDFormat;
    private Text engineIDText;
    private Text enterpriseIDText;
    private Combo engineIDFormatCombo;
    private Text engineIDFormatText;
    private Button hashCodeSetButton;
    private Text hashCodeText;

    static {
        ENGINE_ID_FORMAT = new String[]{"IPv4 address (1)", "IPv6 address (2)", "MAC address (3)", "admin text (4)", "admin hex values (5)"};
    }

    public void init(IWorkbench workbench) {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.setPreferenceStore(NetJFWatcherPlugin.getInstance().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        SnmpV3AgentConfigInfo snmpV3AgentInfo = SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo().getSnmpV3AgentResourceInfo();
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout((Layout)layout);
        GridData gridData = null;
        GridLayout gridLayout = new GridLayout(2, false);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(256));
        gridData = new GridData();
        Label label = new Label(composite, 0);
        label.setText("Engine ID");
        label.setLayoutData((Object)new GridData());
        this.engineIDText = new Text(composite, 2048);
        this.engineIDText.setText(snmpV3AgentInfo.getSnmpEngineID());
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 250;
        this.engineIDText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Enterprise ID");
        label.setLayoutData((Object)new GridData());
        this.enterpriseIDText = new Text(composite, 2048);
        this.enterpriseIDText.setText(snmpV3AgentInfo.getSnmpEngineID());
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.enterpriseIDText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Engine ID Format");
        label.setLayoutData((Object)new GridData());
        this.engineIDFormatCombo = new Combo(composite, 12);
        int i = 0;
        while (i < ENGINE_ID_FORMAT.length) {
            this.engineIDFormatCombo.add(ENGINE_ID_FORMAT[i]);
            ++i;
        }
        this.engineIDFormatCombo.setText(ENGINE_ID_FORMAT[0]);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.engineIDFormatCombo.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("EngineFormat");
        label.setLayoutData((Object)new GridData());
        this.engineIDFormatText = new Text(composite, 2048);
        this.engineIDFormatText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.engineIDFormatText.setLayoutData((Object)gridData);
        this.hashCodeSetButton = new Button(composite, 0);
        this.hashCodeSetButton.setText("HashCode");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.hashCodeText = new Text(composite, 2048);
        this.hashCodeText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.hashCodeText.setLayoutData((Object)gridData);
        this.setInitialText();
        this.addSelectionListener();
        return composite;
    }

    private void addSelectionListener() {
        this.engineIDFormatCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                int index = SnmpV3AgentEnginePreferencePage.this.engineIDFormatCombo.getSelectionIndex();
                SnmpV3AgentEnginePreferencePage.this.selectEngineIDFormat(index);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.enterpriseIDText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event) {
            }

            public void keyReleased(KeyEvent event) {
                SnmpV3AgentEnginePreferencePage.this.enterpriseID = SnmpV3AgentEnginePreferencePage.this.enterpriseIDText.getText();
                SnmpV3AgentEnginePreferencePage.this.setEngineID();
            }
        });
        this.engineIDFormatText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event) {
            }

            public void keyReleased(KeyEvent event) {
                SnmpV3AgentEnginePreferencePage.this.engineIDFormat = SnmpV3AgentEnginePreferencePage.this.engineIDFormatText.getText();
                SnmpV3AgentEnginePreferencePage.this.setEngineID();
            }
        });
        this.hashCodeSetButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String hashCode = SnmpV3AgentEnginePreferencePage.this.createHashCode();
                SnmpV3AgentEnginePreferencePage.this.hashCodeText.setText(hashCode);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void selectEngineIDFormat(int index) {
        if (index == 0) {
            try {
                byte[] addr = InetAddress.getLocalHost().getAddress();
                if (addr.length != 4) {
                    MessageBox alertMessageBox = new MessageBox(this.getShell(), 72);
                    alertMessageBox.setMessage("Not IPv4 address !");
                    alertMessageBox.open();
                }
                String checkEngineIDFormat = this.hexBytetoString(addr);
                this.engineIDFormatIndex = "01";
                this.engineIDFormat = checkEngineIDFormat;
                this.engineIDFormatText.setText(this.engineIDFormat);
                this.setEngineID();
            }
            catch (UnknownHostException unknownHostException) {
                MessageBox alertMessageBox = new MessageBox(this.getShell(), 72);
                alertMessageBox.setMessage("UnknownHostException !");
                alertMessageBox.open();
                return;
            }
        } else if (index == 1) {
            try {
                byte[] addr = InetAddress.getLocalHost().getAddress();
                if (addr.length != 16) {
                    MessageBox alertMessageBox = new MessageBox(this.getShell(), 72);
                    alertMessageBox.setMessage("Not IPv6 address !");
                    alertMessageBox.open();
                }
                String checkEngineIDFormat = this.hexBytetoString(addr);
                this.engineIDFormatIndex = "02";
                this.engineIDFormat = checkEngineIDFormat;
                this.engineIDFormatText.setText(this.engineIDFormat);
                this.setEngineID();
            }
            catch (UnknownHostException unknownHostException) {
                MessageBox alertMessageBox = new MessageBox(this.getShell(), 72);
                alertMessageBox.setMessage("UnknownHostException !");
                alertMessageBox.open();
                return;
            }
        } else if (index == 2) {
            String checkEngineIDFormat = this.engineIDFormatText.getText();
            if (checkEngineIDFormat.length() == 12) {
                MessageBox alertMessageBox = new MessageBox(this.getShell(), 72);
                alertMessageBox.setMessage("MAC address(6 octets) !");
                alertMessageBox.open();
                this.engineIDFormatText.setFocus();
                return;
            }
            this.engineIDFormatIndex = "03";
            this.engineIDFormat = checkEngineIDFormat;
            this.engineIDFormatText.setText(this.engineIDFormat);
            this.setEngineID();
        } else if (index == 3) {
            String checkEngineIDFormat = this.engineIDFormatText.getText();
            if (checkEngineIDFormat.length() > 54) {
                MessageBox alertMessageBox = new MessageBox(this.getShell(), 72);
                alertMessageBox.setMessage("Maximum remaining length 27");
                alertMessageBox.open();
                this.engineIDFormatText.setFocus();
                return;
            }
            this.engineIDFormatIndex = "04";
            this.engineIDFormat = checkEngineIDFormat;
            this.setEngineID();
        } else if (index == 4) {
            String checkEngineIDFormat = this.engineIDFormatText.getText();
            if (checkEngineIDFormat.length() > 54) {
                MessageBox alertMessageBox = new MessageBox(this.getShell(), 72);
                alertMessageBox.setMessage("Maximum remaining length 27");
                alertMessageBox.open();
                this.engineIDFormatText.setFocus();
                return;
            }
            this.engineIDFormatIndex = "05";
            this.engineIDFormat = checkEngineIDFormat;
            this.setEngineID();
        }
    }

    private void setInitialText() {
        SnmpV3AgentConfigInfo snmpV3AgentInfo = SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo().getSnmpV3AgentResourceInfo();
        String engineID = snmpV3AgentInfo.getSnmpEngineID();
        this.enterpriseID = engineID.substring(0, 8);
        this.enterpriseIDText.setText(this.enterpriseID);
        String engineFormat = engineID.substring(9, engineID.length());
        this.engineIDFormatText.setText(engineFormat);
        this.engineIDFormat = engineFormat;
        this.engineIDFormatCombo.select(4);
        this.engineIDFormatIndex = "05";
    }

    private void setEngineID() {
        this.enterpriseID = this.enterpriseIDText.getText();
        String engineID = String.valueOf(this.enterpriseID) + this.engineIDFormatIndex + this.engineIDFormat;
        this.engineIDText.setText(engineID);
    }

    private String createHashCode() {
        int hashCode = ((Object)((Object)this)).hashCode();
        byte[] array = new byte[]{(byte)(hashCode >> 24 & 0xFF), (byte)(hashCode >> 16 & 0xFF), (byte)(hashCode >> 8 & 0xFF), (byte)(hashCode & 0xFF)};
        return this.hexBytetoString(array);
    }

    private String hexBytetoString(byte[] byteData) {
        StringBuffer returnString = new StringBuffer("");
        int i = 0;
        while (byteData.length > i) {
            int pos = byteData[i];
            if (pos < 0) {
                pos += 256;
            }
            returnString.append(Integer.toHexString(pos / 16));
            returnString.append(Integer.toHexString(pos % 16));
            ++i;
        }
        return returnString.toString();
    }

    protected void performDefaults() {
        SnmpV3AgentConfigInfo snmpV3AgentInfo = SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo().getSnmpV3AgentResourceInfo();
        String engineID = snmpV3AgentInfo.getSnmpEngineID();
        this.enterpriseID = engineID.substring(0, 8);
        this.enterpriseIDText.setText(this.enterpriseID);
        this.engineIDFormatCombo.select(4);
        this.engineIDFormatIndex = "05";
        String engineFormat = engineID.substring(9, engineID.length());
        this.engineIDFormatText.setText(engineFormat);
        this.engineIDFormat = engineFormat;
        this.engineIDText.setText(snmpV3AgentInfo.getSnmpEngineID());
    }

    public boolean performOk() {
        if (this.enterpriseID.length() > 8 || this.enterpriseID.length() < 1) {
            MessageBox alertMessageBox = new MessageBox(this.getShell(), 72);
            alertMessageBox.setMessage("Out range Enterprise ID length 1-4 Octets !");
            alertMessageBox.open();
            this.enterpriseIDText.setFocus();
            return true;
        }
        if ((this.engineIDFormatIndex.equals("4") || this.engineIDFormatIndex.equals("5")) && this.engineIDFormat.length() > 54) {
            MessageBox alertMessageBox = new MessageBox(this.getShell(), 72);
            alertMessageBox.setMessage("Maximum remaining length 27");
            alertMessageBox.open();
            this.engineIDFormatText.setFocus();
            return true;
        }
        if (!MessageDialog.openQuestion((Shell)this.getShell(), (String)"Confirm", (String)("SNMP EngineID = " + this.engineIDText.getText() + " ?"))) {
            return true;
        }
        SnmpAgentConfigInfo info = SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo().getSnmpAgentResourceInfo();
        SnmpV3AgentConfigInfo snmpV3Info = SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo().getSnmpV3AgentResourceInfo();
        snmpV3Info.setSnmpEngineID(this.engineIDText.getText());
        Document dom = SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo().updateDocument(info, snmpV3Info);
        BufferedWriter bufWriter = null;
        bufWriter = SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo().getResourceFileWriter();
        SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo().outputXMLFile(bufWriter, dom);
        if (bufWriter != null) {
            try {
                bufWriter.close();
            }
            catch (IOException e) {
                logger.warning("Abort close BufferedWriter for snmp V3 agent resource : " + e.getMessage());
                e.printStackTrace();
            }
        }
        if (NetJFWatcherApplication.getAgentOperationView() != null) {
            NetJFWatcherApplication.getAgentOperationView().updateSnmpAgentInfo();
        }
        return super.performOk();
    }
}

