/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpagent.process;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Logger;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpErrorStatusException;
import netjfwatcher.snmp.messageformat.SnmpVarBindList;
import netjfwatcher.snmp.messageformat.SnmpVariablePair;
import netjfwatcher.snmp.mibtree.AgentMibTree;
import netjfwatcher.snmp.mibtree.MibInfo;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.message.SnmpMessage;
import netjfwatcher.snmp.snmpobject.message.SnmpNull;
import netjfwatcher.snmp.snmpobject.message.SnmpObjectIdentifier;
import netjfwatcher.snmp.snmpobject.message.SnmpPDU;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmpagent.model.AgentInstanceDataMap;
import netjfwatcher.snmpagent.model.AgentInstanceDataRefreshQueue;
import netjfwatcher.snmpagent.model.AgentMonitorMessageQueue;

public abstract class AbstractAgentMessageProcessing {
    private static Logger logger;
    protected static HashMap agentOidHashMap;
    protected static int trapPort;
    protected static DateFormat dateformat;
    protected int version;
    protected DatagramPacket inPacket;
    protected DatagramSocket resSendDatagramSocket;
    protected DatagramSocket trapDatagramSocket;
    protected SnmpMessage receivedMessage;

    static {
        agentOidHashMap = AgentMibTree.getInstance().getOidHashMap();
        dateformat = new SimpleDateFormat("HH:mm:ss");
    }

    public AbstractAgentMessageProcessing() throws SocketException {
        logger = Logger.getLogger(this.getClass().getName());
        trapPort = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo().getSnmpTrapPort();
        try {
            this.trapDatagramSocket = new DatagramSocket();
        }
        catch (SocketException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }

    abstract void process(DatagramPacket var1, byte[] var2, int var3) throws GeneralSecurityException, SnmpV3ConfigurationException, SnmpErrorStatusException, SnmpBadValueException, IOException;

    protected void getRequest(int snmpVersion, String community, DatagramPacket inPacket, SnmpMessage receivedMessage) throws SnmpErrorStatusException, SnmpBadValueException, IOException {
        int errorStatus = 0;
        Object nextMibOid = null;
        SnmpVarBindList varbindList = new SnmpVarBindList();
        try {
            SnmpSequence varList = null;
            SnmpPDU receivedPDU = receivedMessage.getPDU();
            if (receivedPDU.getErrorStatus() != 0) {
                throw new SnmpErrorStatusException("OID  not available for retrieval");
            }
            varList = receivedPDU.getVarBindList();
            int varListCount = varList.getSequenceContentsList().size();
            SnmpSequence makeVarList = new SnmpSequence();
            AgentMonitorMessageQueue.getInstance().pushAgentMessage("Request ID=" + receivedPDU.getRequestID());
            int contentCount = 0;
            while (contentCount < varListCount) {
                SnmpSequence newPair = (SnmpSequence)varList.getSNMPObjectAt(contentCount);
                SnmpObjectIdentifier newObjectIdentifier = (SnmpObjectIdentifier)newPair.getSNMPObjectAt(0);
                varbindList.addSNMPObject(newPair);
                String retrievedOID = newObjectIdentifier.toString();
                logger.info("Request ID=" + receivedPDU.getRequestID() + " Request OID=" + retrievedOID);
                AgentMonitorMessageQueue.getInstance().pushAgentMessage("Request OID=" + retrievedOID);
                AbstractSnmpObject snmpValue = null;
                if (retrievedOID.equals("1.0")) {
                    retrievedOID = "1.3";
                }
                if (agentOidHashMap.containsKey(retrievedOID)) {
                    MibInfo miboid = (MibInfo)agentOidHashMap.get(retrievedOID);
                    if (miboid != null && miboid.isAgentInstance()) {
                        snmpValue = ((MibInfo)agentOidHashMap.get(retrievedOID)).getAgentMibValue();
                    } else {
                        logger.warning("No such name OID=" + retrievedOID);
                        errorStatus = 2;
                        snmpValue = new SnmpNull();
                    }
                } else {
                    errorStatus = 2;
                    logger.warning("No such name OID=" + retrievedOID);
                    if (nextMibOid != null) {
                        retrievedOID = nextMibOid;
                    }
                    snmpValue = new SnmpNull();
                }
                SnmpObjectIdentifier requestedObjectIdentifier = new SnmpObjectIdentifier(retrievedOID);
                SnmpVariablePair nextPair = new SnmpVariablePair(requestedObjectIdentifier, snmpValue);
                makeVarList.addSNMPObject(nextPair);
                ++contentCount;
            }
            this.sendResponse(snmpVersion, inPacket, receivedPDU.getRequestID(), community, makeVarList, errorStatus);
        }
        catch (SnmpBadValueException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }

    protected void getNextRequest(int snmpVersion, String community, DatagramPacket inPacket, SnmpMessage receivedMessage) throws SnmpErrorStatusException, SnmpBadValueException, IOException {
        int errorStatus = 0;
        String nextMibOid = null;
        SnmpVarBindList varbindList = new SnmpVarBindList();
        try {
            SnmpSequence varList = new SnmpSequence();
            SnmpPDU receivedPDU = receivedMessage.getPDU();
            if (receivedPDU.getErrorStatus() != 0) {
                throw new SnmpErrorStatusException("OID  not available for retrieval");
            }
            varList = receivedPDU.getVarBindList();
            int varListCount = varList.getSequenceContentsList().size();
            String retrievedOID = "";
            AbstractSnmpObject snmpValue = null;
            SnmpSequence makeVarList = new SnmpSequence();
            AgentMonitorMessageQueue.getInstance().pushAgentMessage("Request ID=" + receivedPDU.getRequestID());
            int contentCount = 0;
            while (contentCount < varListCount) {
                SnmpSequence newPair = (SnmpSequence)varList.getSNMPObjectAt(contentCount);
                SnmpObjectIdentifier newObjectIdentifier = (SnmpObjectIdentifier)newPair.getSNMPObjectAt(0);
                varbindList.addSNMPObject(newPair);
                errorStatus = 0;
                retrievedOID = newObjectIdentifier.toString();
                logger.info("Request ID=" + receivedPDU.getRequestID() + " Request OID=" + retrievedOID);
                AgentMonitorMessageQueue.getInstance().pushAgentMessage("Request OID=" + retrievedOID);
                if (retrievedOID.equals("1.0")) {
                    retrievedOID = "1.3";
                }
                if (agentOidHashMap.containsKey(retrievedOID)) {
                    MibInfo mibOid = (MibInfo)agentOidHashMap.get(retrievedOID);
                    MibInfo nextmiboid = null;
                    while ((mibOid = (MibInfo)agentOidHashMap.get(retrievedOID)) != null) {
                        nextmiboid = (MibInfo)agentOidHashMap.get(mibOid.getNextMibOid());
                        if (nextmiboid == null) {
                            logger.warning("Next Mib OID null. OID = " + retrievedOID);
                            break;
                        }
                        logger.info("Instance OID = " + retrievedOID);
                        if (nextmiboid.isAgentInstance()) {
                            logger.info("Instance OID = " + retrievedOID + " Access = " + nextmiboid.getAccess());
                            break;
                        }
                        retrievedOID = mibOid.getNextMibOid();
                    }
                    if (mibOid != null && nextmiboid != null) {
                        nextMibOid = mibOid.getNextMibOid();
                        snmpValue = ((MibInfo)agentOidHashMap.get(nextMibOid)).getAgentMibValue();
                        retrievedOID = ((MibInfo)agentOidHashMap.get(retrievedOID)).getNextMibOid();
                    } else {
                        logger.warning("Nosuch name OID = " + retrievedOID);
                        errorStatus = 2;
                        snmpValue = new SnmpNull();
                    }
                } else {
                    logger.warning("Nosuch name OID = " + retrievedOID);
                    errorStatus = 2;
                    if (nextMibOid != null) {
                        retrievedOID = nextMibOid;
                    }
                    snmpValue = new SnmpNull();
                }
                SnmpObjectIdentifier requestedObjectIdentifier = new SnmpObjectIdentifier(retrievedOID);
                SnmpVariablePair nextPair = new SnmpVariablePair(requestedObjectIdentifier, snmpValue);
                makeVarList.addSNMPObject(nextPair);
                ++contentCount;
            }
            this.sendResponse(snmpVersion, inPacket, receivedPDU.getRequestID(), community, makeVarList, errorStatus);
        }
        catch (SnmpBadValueException e) {
            logger.warning("Abort GetNextRequest command : " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }

    public void setRequest(int snmpVersion, String rwCommunity, DatagramPacket inPacket, SnmpMessage receivedMessage) throws SnmpErrorStatusException, SnmpBadValueException, IOException {
        int errorStatus = 0;
        try {
            SnmpSequence varList = null;
            SnmpPDU receivedPDU = receivedMessage.getPDU();
            if (receivedPDU.getErrorStatus() != 0) {
                throw new SnmpErrorStatusException("Error status not correct : " + receivedPDU.getErrorStatus());
            }
            varList = receivedPDU.getVarBindList();
            SnmpSequence newPair = (SnmpSequence)varList.getSNMPObjectAt(0);
            SnmpObjectIdentifier receiveOIDInstance = (SnmpObjectIdentifier)newPair.getSNMPObjectAt(0);
            AbstractSnmpObject receiveSNMPObject = newPair.getSNMPObjectAt(1);
            String retrievedOID = receiveOIDInstance.toString();
            logger.info("Request ID=" + receivedPDU.getRequestID() + " Request OID=" + retrievedOID + ", Value=" + receiveSNMPObject);
            AgentMonitorMessageQueue.getInstance().pushAgentMessage("Request ID=" + receivedPDU.getRequestID() + " Request OID=" + retrievedOID + " Value=" + receiveSNMPObject);
            AbstractSnmpObject snmpObjectValue = null;
            if (agentOidHashMap.containsKey(retrievedOID)) {
                MibInfo agentOidInfo = (MibInfo)agentOidHashMap.get(retrievedOID);
                if (agentOidInfo.isAgentInstance()) {
                    logger.info("instance : " + agentOidInfo.getAccess());
                    logger.info("Descrip : " + agentOidInfo.getDescrip() + " access : " + agentOidInfo.getAccess());
                    if (agentOidInfo.getAccess().equals("rw")) {
                        agentOidInfo.setAgentMibValue(receiveSNMPObject);
                        agentOidInfo.setValue(receiveSNMPObject.toString());
                        AgentMibTree.getInstance().getOidHashMap().put(retrievedOID, agentOidInfo);
                        snmpObjectValue = receiveSNMPObject;
                        MibInfo agentInstanceOidInfo = AgentInstanceDataMap.getInstance().getAgentInstanceDataInfo(retrievedOID);
                        if (agentInstanceOidInfo != null) {
                            agentInstanceOidInfo.setAgentMibValue(receiveSNMPObject);
                            agentInstanceOidInfo.setValue(receiveSNMPObject.toString());
                            AgentInstanceDataMap.getInstance().setAgentInstanceDataMap(retrievedOID, agentInstanceOidInfo);
                            AgentInstanceDataRefreshQueue.getInstance().pushQueue(agentInstanceOidInfo);
                        } else {
                            logger.warning("No Access : " + retrievedOID);
                            errorStatus = 6;
                            snmpObjectValue = new SnmpNull();
                        }
                    } else {
                        logger.warning("Not writable : " + retrievedOID);
                        errorStatus = 17;
                        snmpObjectValue = new SnmpNull();
                    }
                } else {
                    logger.warning("No Access : " + retrievedOID);
                    errorStatus = 6;
                    snmpObjectValue = new SnmpNull();
                }
            } else {
                logger.warning("Nosuch name : : " + retrievedOID);
                errorStatus = 2;
                snmpObjectValue = new SnmpNull();
            }
            this.sendResponse(snmpVersion, inPacket, receivedPDU.getRequestID(), retrievedOID, rwCommunity, snmpObjectValue, errorStatus);
        }
        catch (SnmpBadValueException e) {
            logger.warning("Abort SetRequest command : " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }

    public void sendResponse(int snmpVersion, DatagramPacket inPacket, int requestID, String oid, String community, AbstractSnmpObject snmpValueObject, int errorStatus) throws SnmpBadValueException, IOException {
        byte[] messageEncoding = this.makeMessage(snmpVersion, requestID, oid, community, snmpValueObject, errorStatus);
        DatagramPacket outPacket = new DatagramPacket(messageEncoding, messageEncoding.length, inPacket.getAddress(), inPacket.getPort());
        try {
            this.resSendDatagramSocket.send(outPacket);
            logger.info(this.hexBytetoString(messageEncoding, outPacket.getLength()));
            Date date = Calendar.getInstance().getTime();
            AgentMonitorMessageQueue.getInstance().pushAgentMessage("Response send date : " + dateformat.format(date) + " : Data length : " + messageEncoding.length + "Byte");
            AgentMonitorMessageQueue.getInstance().pushAgentMessage(String.valueOf(this.hexBytetoString(messageEncoding, messageEncoding.length)) + "\n");
        }
        catch (IOException e) {
            logger.warning("Response send : " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }

    public void sendResponse(int snmpVersion, DatagramPacket inPacket, int requestID, String community, SnmpSequence varList, int errorStatus) throws SnmpBadValueException, IOException {
        byte[] messageEncoding = this.makeMessage(snmpVersion, requestID, community, varList, errorStatus);
        DatagramPacket outPacket = new DatagramPacket(messageEncoding, messageEncoding.length, inPacket.getAddress(), inPacket.getPort());
        try {
            this.resSendDatagramSocket.send(outPacket);
            logger.info(this.hexBytetoString(messageEncoding, outPacket.getLength()));
            Date date = Calendar.getInstance().getTime();
            AgentMonitorMessageQueue.getInstance().pushAgentMessage("Response send date : " + dateformat.format(date) + " : Data length : " + messageEncoding.length + "Byte");
            AgentMonitorMessageQueue.getInstance().pushAgentMessage(String.valueOf(this.hexBytetoString(messageEncoding, messageEncoding.length)) + "\n");
        }
        catch (IOException e) {
            logger.warning("Response send : " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }

    public byte[] makeMessage(int snmVesion, int requestID, String oid, String community, AbstractSnmpObject snmpobject, int errorStatus) throws SnmpBadValueException {
        int errorIndex = 0;
        byte[] messageEncoding = null;
        try {
            SnmpObjectIdentifier requestedObjectIdentifier = new SnmpObjectIdentifier(oid);
            SnmpVariablePair nextPair = new SnmpVariablePair(requestedObjectIdentifier, snmpobject);
            SnmpSequence varList = new SnmpSequence();
            varList.addSNMPObject(nextPair);
            SnmpPDU pdu = new SnmpPDU(-94, requestID, errorStatus, errorIndex, varList);
            SnmpMessage message = new SnmpMessage(snmVesion, community, pdu);
            messageEncoding = message.getBEREncoding();
        }
        catch (SnmpBadValueException e) {
            logger.warning("Create response message : " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
        return messageEncoding;
    }

    public byte[] makeMessage(int snmVesion, int requestID, String community, SnmpSequence varList, int errorStatus) throws SnmpBadValueException {
        int errorIndex = 0;
        byte[] messageEncoding = null;
        try {
            SnmpPDU pdu = new SnmpPDU(-94, requestID, errorStatus, errorIndex, varList);
            SnmpMessage message = new SnmpMessage(snmVesion, community, pdu);
            messageEncoding = message.getBEREncoding();
        }
        catch (SnmpBadValueException e) {
            logger.warning("Create response message : " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
        return messageEncoding;
    }

    public abstract void sendTrap(String var1, String var2, SnmpSequence var3) throws GeneralSecurityException, UnknownHostException, SnmpV3ConfigurationException, SnmpBadValueException, IOException;

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.trapDatagramSocket != null) {
            this.trapDatagramSocket.close();
        }
    }

    public String hexBytetoString(byte[] byteData, int receiveLength) {
        StringBuffer returnString = new StringBuffer();
        int i = 0;
        while (byteData.length > i && receiveLength > i) {
            int pos;
            if (i != 0 && i % 16 == 0) {
                returnString.append(System.getProperty("line.separator"));
            }
            if ((pos = byteData[i]) < 0) {
                pos += 256;
            }
            returnString.append(Integer.toHexString(pos / 16));
            returnString.append(String.valueOf(Integer.toHexString(pos % 16)) + " ");
            ++i;
        }
        return returnString.toString();
    }

    public String hexByte(byte byteData) {
        String returnString = "";
        int pos = byteData;
        if (pos < 0) {
            pos += 256;
        }
        returnString = String.valueOf(returnString) + Integer.toHexString(pos / 16);
        returnString = String.valueOf(returnString) + Integer.toHexString(pos % 16);
        return returnString;
    }

    public String bytetoString(byte[] b) {
        String returnString = "";
        int i = 0;
        while (i < b.length) {
            returnString = String.valueOf(returnString) + Byte.toString(b[i]);
            ++i;
        }
        return returnString;
    }

    public String bytetoChar(byte[] b) {
        String returnString = "";
        int i = 0;
        while (i < b.length) {
            returnString = String.valueOf(returnString) + (char)b[i];
            ++i;
        }
        return returnString;
    }
}

