/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpmanager.preferences;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.socket.info.ResourceInfo;
import netjfwatcher.snmpmanager.preferences.AbstractSnmpPreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.jdom.Document;

public class SnmpPreferencePage
extends AbstractSnmpPreferencePage {
    private static final int TEXT_WIDTH = 120;
    private static Logger logger;
    private Text snmpPortText;
    private Text snmpTrapPortText;
    private Text snmpV1TimeoutText;
    private Text snmpV1RetryText;
    private Text snmpV2TimeoutText;
    private Text snmpV2RetryText;
    private Text snmpV3TimeoutText;
    private Text snmpV3RetryText;

    public void init(IWorkbench workbench) {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.setPreferenceStore(NetJFWatcherPlugin.getInstance().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite entryTable = new Composite(parent, 0);
        entryTable.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        entryTable.setLayout((Layout)gridLayout);
        Label label = new Label(entryTable, 0);
        label.setText("Snmp Port");
        label.setLayoutData((Object)new GridData());
        this.snmpPortText = new Text(entryTable, 133120);
        int snmpPort = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo().getSnmpPort();
        this.snmpPortText.setText(Integer.toString(snmpPort));
        GridData gridData = new GridData();
        gridData.widthHint = 120;
        this.snmpPortText.setLayoutData((Object)gridData);
        label = new Label(entryTable, 0);
        label.setText("Snmp Trap Port");
        label.setLayoutData((Object)new GridData());
        this.snmpTrapPortText = new Text(entryTable, 133120);
        int snmpTrapPort = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo().getSnmpTrapPort();
        this.snmpTrapPortText.setText(Integer.toString(snmpTrapPort));
        gridData = new GridData();
        gridData.widthHint = 120;
        this.snmpTrapPortText.setLayoutData((Object)gridData);
        Group snmpV1Group = new Group(entryTable, 0);
        snmpV1Group.setText("Snmp V1");
        snmpV1Group.setLayout((Layout)new GridLayout(2, false));
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        snmpV1Group.setLayoutData((Object)gridData);
        label = new Label((Composite)snmpV1Group, 0);
        label.setText("Timeout (ms)");
        label.setLayoutData((Object)new GridData());
        this.snmpV1TimeoutText = new Text((Composite)snmpV1Group, 133120);
        this.snmpV1TimeoutText.setText(SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo().getSnmpV1Timeout());
        gridData = new GridData();
        gridData.widthHint = 120;
        this.snmpV1TimeoutText.setLayoutData((Object)gridData);
        label = new Label((Composite)snmpV1Group, 0);
        label.setText("Retry");
        label.setLayoutData((Object)new GridData());
        this.snmpV1RetryText = new Text((Composite)snmpV1Group, 133120);
        this.snmpV1RetryText.setText(SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo().getSnmpV1Retry());
        gridData = new GridData();
        gridData.widthHint = 120;
        this.snmpV1RetryText.setLayoutData((Object)gridData);
        Group snmpV2Group = new Group(entryTable, 0);
        snmpV2Group.setText("Snmp V2");
        snmpV2Group.setLayout((Layout)new GridLayout(2, false));
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        snmpV2Group.setLayoutData((Object)gridData);
        label = new Label((Composite)snmpV2Group, 0);
        label.setText("Timeout (ms)");
        label.setLayoutData((Object)new GridData());
        this.snmpV2TimeoutText = new Text((Composite)snmpV2Group, 133120);
        this.snmpV2TimeoutText.setText(SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo().getSnmpV2Timeout());
        gridData = new GridData();
        gridData.widthHint = 120;
        this.snmpV2TimeoutText.setLayoutData((Object)gridData);
        label = new Label((Composite)snmpV2Group, 0);
        label.setText("Retry");
        label.setLayoutData((Object)new GridData());
        this.snmpV2RetryText = new Text((Composite)snmpV2Group, 133120);
        this.snmpV2RetryText.setText(SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo().getSnmpV2Retry());
        gridData = new GridData();
        gridData.widthHint = 120;
        this.snmpV2RetryText.setLayoutData((Object)gridData);
        Group snmpV3Group = new Group(entryTable, 0);
        snmpV3Group.setText("Snmp V3");
        snmpV3Group.setLayout((Layout)new GridLayout(2, false));
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        snmpV3Group.setLayoutData((Object)gridData);
        label = new Label((Composite)snmpV3Group, 0);
        label.setText("Timeout (ms)");
        label.setLayoutData((Object)new GridData());
        this.snmpV3TimeoutText = new Text((Composite)snmpV3Group, 133120);
        this.snmpV3TimeoutText.setText(SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo().getSnmpV3Timeout());
        gridData = new GridData();
        gridData.widthHint = 120;
        this.snmpV3TimeoutText.setLayoutData((Object)gridData);
        label = new Label((Composite)snmpV3Group, 0);
        label.setText("Retry");
        label.setLayoutData((Object)new GridData());
        this.snmpV3RetryText = new Text((Composite)snmpV3Group, 133120);
        this.snmpV3RetryText.setText(SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo().getSnmpV3Retry());
        gridData = new GridData();
        gridData.widthHint = 120;
        this.snmpV3RetryText.setLayoutData((Object)gridData);
        return entryTable;
    }

    protected void performDefaults() {
        ResourceInfo info = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo();
        this.snmpPortText.setText(Integer.toString(info.getSnmpPort()));
        this.snmpTrapPortText.setText(Integer.toString(info.getSnmpTrapPort()));
        this.snmpV1TimeoutText.setText(info.getSnmpV1Timeout());
        this.snmpV1RetryText.setText(info.getSnmpV1Retry());
        this.snmpV2TimeoutText.setText(info.getSnmpV2Timeout());
        this.snmpV2RetryText.setText(info.getSnmpV2Retry());
        this.snmpV3TimeoutText.setText(info.getSnmpV3Timeout());
        this.snmpV3RetryText.setText(info.getSnmpV3Retry());
    }

    public boolean performOk() {
        ResourceInfo info = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo();
        String snmpPort = this.snmpPortText.getText();
        String snmpTrapPort = this.snmpTrapPortText.getText();
        info.setSnmpPort(Integer.parseInt(snmpPort));
        info.setSnmpTrapPort(Integer.parseInt(snmpTrapPort));
        info.setSnmpV1Timeout(this.snmpV1TimeoutText.getText());
        info.setSnmpV1Retry(this.snmpV1RetryText.getText());
        info.setSnmpV2Timeout(this.snmpV2TimeoutText.getText());
        info.setSnmpV2Retry(this.snmpV2RetryText.getText());
        info.setSnmpV3Timeout(this.snmpV3TimeoutText.getText());
        info.setSnmpV3Retry(this.snmpV3RetryText.getText());
        this.saveSnmpXMLInfo(info);
        return super.performOk();
    }

    private void saveSnmpXMLInfo(ResourceInfo resourceInfo) {
        Document dom = null;
        BufferedWriter bufWriter = null;
        dom = this.updateSNMPResource(resourceInfo);
        bufWriter = SystemResourceConfig.getInstance().getResourceFileParse().getResourceFileWriter();
        this.outputXMLFile(bufWriter, dom);
        if (bufWriter != null) {
            try {
                bufWriter.close();
            }
            catch (IOException e) {
                logger.warning("Abort close BufferedWriter for snmp resource : " + e.getMessage());
                e.printStackTrace();
            }
        }
        SystemResourceConfig.getInstance().updateResourceset();
    }

    public Document updateSNMPResource(ResourceInfo resourceInfo) {
        Document dom = SystemResourceConfig.getInstance().getResourceFileParse().updateDocument(resourceInfo);
        return dom;
    }
}

