/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpmanager.trap;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import netjfwatcher.engine.common.model.DataStringDisplay;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmp.snmpv3.SnmpV3DecryptAbortException;
import netjfwatcher.snmpmanager.trap.ITrapListener;
import netjfwatcher.snmpmanager.trap.TrapDispatcher;

public final class ThreadTrapReceive
extends DataStringDisplay
implements Runnable {
    private static final int WAIT_SLEEP_TIME = 1000;
    private static Logger logger;
    private DatagramSocket dSocket;
    private final int trapPort;
    private Thread trapReceiveThread;
    private final List<ITrapListener> listenerList = Collections.synchronizedList(new ArrayList());

    private ThreadTrapReceive() {
        logger = Logger.getLogger(this.getClass().getName());
        this.trapPort = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo().getSnmpTrapPort();
    }

    public void addTrapListener(ITrapListener listener) {
        int i = 0;
        while (i < this.listenerList.size()) {
            if (listener == this.listenerList.get(i)) {
                return;
            }
            ++i;
        }
        this.listenerList.add(listener);
    }

    public void removeTrapListener(ITrapListener listener) {
        int i = 0;
        while (i < this.listenerList.size()) {
            if (listener == this.listenerList.get(i)) {
                this.listenerList.remove(i);
                break;
            }
            ++i;
        }
    }

    public boolean checkThread() {
        return this.trapReceiveThread != null && this.trapReceiveThread.isAlive();
    }

    public boolean startReceiving() {
        if (this.trapReceiveThread == null || !this.trapReceiveThread.isAlive()) {
            try {
                this.dSocket = new DatagramSocket(this.trapPort);
                this.trapReceiveThread = new Thread(this);
            }
            catch (SocketException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
                logger.warning("Trap thread start abort : " + e.getMessage());
                return false;
            }
            if (this.trapReceiveThread != null) {
                this.trapReceiveThread.start();
            }
            logger.info("Trap thread start successful");
            return true;
        }
        logger.warning("Trap thread start abort : trapReceiveThread = " + this.trapReceiveThread + "  trapReceiveThread isAlive = " + this.trapReceiveThread.isAlive());
        return false;
    }

    public void stopReceiving() {
        if (this.trapReceiveThread == null) {
            return;
        }
        this.trapReceiveThread.interrupt();
        if (this.dSocket != null) {
            this.dSocket.close();
            while (this.trapReceiveThread != null && this.trapReceiveThread.isAlive()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
            }
            this.dSocket = null;
        }
        logger.info("Trap thread stop");
        this.trapReceiveThread = null;
    }

    public void run() {
        logger.info("Trap receive start");
        while (this.trapReceiveThread != null && !this.trapReceiveThread.isInterrupted()) {
            TrapDispatcher dispPatcher = new TrapDispatcher();
            try {
                dispPatcher.disptcher(this.dSocket, this.listenerList);
            }
            catch (SocketException e) {
                if (this.dSocket.isClosed()) {
                    logger.info("Trap Receive Socket closed : " + e.getMessage());
                    continue;
                }
                logger.warning("Trap receive error : " + e.getMessage());
                e.printStackTrace();
            }
            catch (GeneralSecurityException e) {
                logger.warning("Trap receive error : " + e.getMessage());
                e.printStackTrace();
            }
            catch (SnmpV3ConfigurationException e) {
                logger.warning("Trap receive error : " + e.getMessage());
                e.printStackTrace();
            }
            catch (SnmpBadValueException e) {
                logger.warning("Trap receive error : " + e.getMessage());
                e.printStackTrace();
            }
            catch (SnmpV3DecryptAbortException e) {
                logger.warning("Trap receive error : " + e.getMessage());
                e.printStackTrace();
            }
            catch (IOException e) {
                logger.warning("Trap receive error : " + e.getMessage());
                e.printStackTrace();
            }
        }
        logger.info("Trap receive thread interrupted");
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.dSocket != null) {
            this.dSocket.close();
        }
    }

    public static ThreadTrapReceive getInstance() {
        return SingletonResource.RESOURCE;
    }

    /* synthetic */ ThreadTrapReceive(ThreadTrapReceive threadTrapReceive) {
        this();
    }

    private static class SingletonResource {
        static final ThreadTrapReceive RESOURCE = new ThreadTrapReceive(null);

        private SingletonResource() {
        }
    }
}

