/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.webbrowser.view;

import java.io.IOException;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WWinActionBars;
import org.eclipse.ui.internal.WorkbenchWindow;

public class BrowserLocationChangeListener
implements LocationListener {
    private static Logger logger;
    private static final int TOTAL_WORK = 100;
    private PreferenceStore webAccessPref;
    private IProgressMonitor monitor;
    private String urlTitle;

    public BrowserLocationChangeListener(String urlTitle) {
        logger = Logger.getLogger(this.getClass().getName());
        this.urlTitle = urlTitle;
        this.webAccessPref = new PreferenceStore("resources/webAccess.pref");
        IWorkbench workbench = PlatformUI.getWorkbench();
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)workbench.getActiveWorkbenchWindow();
        WWinActionBars bars = workbenchWindow.getActionBars();
        IStatusLineManager lineManager = bars.getStatusLineManager();
        this.monitor = lineManager.getProgressMonitor();
    }

    public void changing(LocationEvent event) {
        logger.info("Reading ... " + event.location);
        try {
            this.webAccessPref.load();
        }
        catch (IOException e1) {
            logger.warning(e1.getMessage());
        }
        if (this.webAccessPref != null) {
            this.monitor.beginTask("Reading ... " + this.urlTitle + " ( Host=" + this.webAccessPref.getString("HTTP_HOST") + " Port=" + this.webAccessPref.getString("HTTP_PORT") + " Context=" + this.webAccessPref.getString("HTTP_CONTEXT") + " )", 100);
        } else {
            this.monitor.beginTask("Reading ... " + this.urlTitle + "( " + event.location + " )", 100);
        }
    }

    public void changed(LocationEvent event) {
        this.monitor.done();
        logger.info("browsing complete : " + event.location);
    }
}

