/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.webbrowser.view;

import netjfwatcher.engine.model.action.ActionBuilderEditorsPartClose;
import netjfwatcher.webbrowser.menutree.IMenuNode;
import netjfwatcher.webbrowser.menutree.NetMenuTree;
import netjfwatcher.webbrowser.menutree.NetMenuTreeGroup;
import netjfwatcher.webbrowser.menutree.NetMenuTreeListener;
import netjfwatcher.webbrowser.menutree.NetMenuTreeViewContentProvider;
import netjfwatcher.webbrowser.menutree.NetMenuTreeViewLabelProvider;
import netjfwatcher.webbrowser.menutree.NetMenuTreeViewSorter;
import netjfwatcher.webbrowser.preferences.HttpAccessPreference;
import netjfwatcher.webbrowser.preferences.HttpAccessPreferenceException;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.ViewPart;
import org.w3c.dom.Node;

public class NodeMenuView
extends ViewPart {
    private static ActionBuilderEditorsPartClose actionBuilder = new ActionBuilderEditorsPartClose();
    private static TreeViewer menuTreeViewer;

    public ActionBuilderEditorsPartClose getActionBuilder() {
        return actionBuilder;
    }

    public void setFocus() {
    }

    public TreeViewer getViewer() {
        return menuTreeViewer;
    }

    public void createPartControl(Composite parent) {
        menuTreeViewer = new TreeViewer(parent);
        menuTreeViewer.setUseHashlookup(true);
        menuTreeViewer.setContentProvider((IContentProvider)new NetMenuTreeViewContentProvider());
        menuTreeViewer.setLabelProvider((IBaseLabelProvider)new NetMenuTreeViewLabelProvider());
        menuTreeViewer.setSorter((ViewerSorter)new NetMenuTreeViewSorter());
        menuTreeViewer.setInput(this.createInitialInput());
        menuTreeViewer.expandAll();
        this.createContextMenu();
        this.initActions();
        this.createNetworkMenuTree();
        this.setupNodeMenuViewListener();
    }

    private void setupNodeMenuViewListener() {
        menuTreeViewer.addSelectionChangedListener((ISelectionChangedListener)new NetMenuTreeListener());
    }

    private Object createInitialInput() {
        RootOfRootMenuGroup rootOfRoot = new RootOfRootMenuGroup();
        return rootOfRoot;
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add(this.getActionBuilder().actionCloseAllEditors());
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                NodeMenuView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuManager.createContextMenu(menuTreeViewer.getControl());
        menuTreeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)menuTreeViewer);
    }

    private void initActions() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add(this.getActionBuilder().actionCloseAllEditors());
    }

    public void createNetworkMenuTree() {
        IMenuNode menuNode = (IMenuNode)this.getViewer().getInput();
        NetMenuTreeGroup baseMenuGroup = menuNode.getParent();
        if (menuNode instanceof NetMenuTreeGroup) {
            baseMenuGroup = (NetMenuTreeGroup)menuNode;
        }
        try {
            baseMenuGroup.addChild(new NetMenuTree("Node Map Manager", HttpAccessPreference.getInstance().getNodeMapUrl()));
            baseMenuGroup.addChild(new NetMenuTree("Node List Manager", HttpAccessPreference.getInstance().getNodeManagerUrl()));
            baseMenuGroup.addChild(new NetMenuTree("Auth Node List Manager", HttpAccessPreference.getInstance().getAuthNodeManagerUrl()));
            baseMenuGroup.addChild(new NetMenuTree("Auth Maintenance Manager", HttpAccessPreference.getInstance().getMaintenanceUrl()));
            menuTreeViewer.expandAll();
            menuTreeViewer.refresh();
            this.setStatusLine();
        }
        catch (HttpAccessPreferenceException e) {
            e.printStackTrace();
        }
    }

    private void setStatusLine() throws HttpAccessPreferenceException {
        SubStatusLineManager statusLineManager = (SubStatusLineManager)this.getViewSite().getActionBars().getStatusLineManager();
        statusLineManager.setVisible(true);
        statusLineManager.setMessage("Access URL = " + HttpAccessPreference.getInstance().getUrl());
    }

    private static final class RootOfRootMenuGroup
    extends NetMenuTreeGroup {
        RootOfRootMenuGroup() {
            super("RootOfRoot");
        }

        public NetMenuTreeGroup getParent() {
            return null;
        }

        public void removeChild(Node toRemove) {
        }
    }
}

