/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.menus.IDynamicMenu;
import org.eclipse.ui.internal.menus.IMenuCollection;

final class DynamicMenuProxy
implements IDynamicMenu {
    private IConfigurationElement configurationElement;
    private IDynamicMenu dynamicMenu = null;
    private final String dynamicMenuAttributeName;

    public DynamicMenuProxy(IConfigurationElement configurationElement, String dynamicMenuAttributeName) {
        if (configurationElement == null) {
            throw new NullPointerException("The configuration element backing a dynamic menu proxy cannot be null");
        }
        if (dynamicMenuAttributeName == null) {
            throw new NullPointerException("The attribute containing the dynamic menu class must be known");
        }
        this.configurationElement = configurationElement;
        this.dynamicMenuAttributeName = dynamicMenuAttributeName;
    }

    public final void aboutToShow(IMenuCollection menu) {
        if (this.loadDynamicMenu()) {
            this.dynamicMenu.aboutToShow(menu);
        }
    }

    private final boolean loadDynamicMenu() {
        if (this.dynamicMenu == null) {
            try {
                this.dynamicMenu = (IDynamicMenu)this.configurationElement.createExecutableExtension(this.dynamicMenuAttributeName);
                this.configurationElement = null;
                return true;
            }
            catch (ClassCastException e) {
                Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, "The proxied dynamic menu was the wrong class", (Throwable)e);
                WorkbenchPlugin.log("The proxied dynamic menu was the wrong class", (IStatus)status);
                return false;
            }
            catch (CoreException e) {
                String message = "The proxied dynamic menu for '" + this.configurationElement.getAttribute(this.dynamicMenuAttributeName) + "' could not be loaded";
                Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, message, (Throwable)e);
                WorkbenchPlugin.log(message, (IStatus)status);
                return false;
            }
        }
        return true;
    }

    public final String toString() {
        if (this.dynamicMenu == null) {
            return this.configurationElement.getAttribute(this.dynamicMenuAttributeName);
        }
        return this.dynamicMenu.toString();
    }
}

