/*
 * Created on 2006/11/07
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.authentication;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.engine.filepreference.FilePreference;

import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;


public class AuthenticationConfigFileParse {

	/* conf TAG */
	private static final String CONF_TAG = "conf";
	
	/* user TAG */
	private static final String USER_TAG = "user";

	/* user name TAG */
	private static final String USER_NAME_TAG = "user_name";

	/* password TAG */
	private static final String PASSWORD_TAG = "password";
	
	/* l */
	private static final String ATTRIBUTE_VALUE = "value";

	private Map<String, String> userMap = Collections.synchronizedMap(new HashMap<String, String>());
	private List<String> userNameList = Collections.synchronizedList(new LinkedList<String>());
	private String userName;
	private String passwrod;

	/* Logging */
	private static Logger logger = null;



	public AuthenticationConfigFileParse() {
		logger = Logger.getLogger(this.getClass().getName());
		userMap.clear();
		userNameList.clear();
		Document doc = null;
        BufferedReader d = null;

        try {
            FileReader fi = new FileReader(FilePreference.AUTH_XML_FILE);
            d = new BufferedReader(fi);
        } catch (FileNotFoundException e1) {
            logger.warning("FileNotFoundException " + e1.getMessage());
            return;
        }

        try {
            // FileInputStream stream = new FileInputStream(f);
            SAXBuilder builder = new SAXBuilder();

            if (builder == null) {
                return;
            }

            doc = builder.build(d);
        } catch (JDOMException e) {
        	logger.warning("JDOMException " + e.getMessage());
            e.printStackTrace();
        } catch (IOException e) {
        	logger.warning("IOException " + e.getMessage());
            e.printStackTrace();
        }

		

		try {
			// rootvfo
			Element root = doc.getRootElement();
			
			List userList = root.getChildren(USER_TAG);

			Iterator iterator = userList.iterator();

			while (iterator.hasNext()) {

				Element userListEl = (Element) iterator.next();

				userName = userListEl.getChild(USER_NAME_TAG)
						.getAttributeValue(ATTRIBUTE_VALUE);
				
				passwrod = userListEl.getChild(PASSWORD_TAG)
				.getAttributeValue(ATTRIBUTE_VALUE);
				
				// System.out.println("userName=" +  userName + " passwrod=" + passwrod);
				userMap.put(userName, passwrod);
				userNameList.add(userName);

			}
		} catch (NullPointerException e) {
			logger.warning("NullPointerException " + e.getMessage());
			e.printStackTrace();
		}
	}


	public boolean checkUser(String userName, String password) {
		if(userMap.containsKey(userName)) {
			
			if(((String)userMap.get(userName)).equals(password)){
				return true;
			}
		}
		return false;
	}


	/**
	 * \[XBufferedWriterԂ܂B
	 * 
	 * @return bufferedWriter \[XBufferedWriter
	 */
	public BufferedWriter getResourceFileWriter() {
		File f = new File(FilePreference.AUTH_XML_FILE);
		// logger.info("Path : " + f.getAbsolutePath());

		if (f == null) {
			return null;
		}

		BufferedWriter bufferedWriter = null;

		try {
			FileWriter fi = new FileWriter(
					FilePreference.AUTH_XML_FILE);
			bufferedWriter = new BufferedWriter(fi);
		} catch (IOException e1) {
			e1.printStackTrace();

			return null;
		}

		return bufferedWriter;
	}
	

	public Document updateDocument(Map userInfoMap) {
		logger = Logger.getLogger(this.getClass().getName());

		Element confElement = new Element(CONF_TAG);
		Document doc = new Document(confElement);

		Element[] userEl = new Element[userInfoMap.size()];
		Element[] userNameEl = new Element[userInfoMap.size()];
		Element[] passwordEl = new Element[userInfoMap.size()];
		Iterator it = null;
		int i = 0;
		for (it = userInfoMap.keySet().iterator(); it.hasNext();) {
			String userNameData = (String) it.next();
			String passwordData = (String) userInfoMap.get(userNameData);
			userEl[i] = new Element(USER_TAG);
			userNameEl[i] = new Element(USER_NAME_TAG);
			passwordEl[i] = new Element(PASSWORD_TAG);
			confElement.addContent(userEl[i]);
			userEl[i].addContent(userNameEl[i]);
			userEl[i].addContent(passwordEl[i]);
			userNameEl[i].setAttribute(new Attribute(ATTRIBUTE_VALUE, userNameData));
			passwordEl[i].setAttribute(new Attribute(ATTRIBUTE_VALUE, passwordData));
			i++;
			
		}

		return doc;
	}
	
	public Map getUserMap() {
		return userMap;
	}


	public List getUserNameList() {
		return userNameList;
	}

}
