/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.database.access.control;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;


/**
 * f[^x[XANZXCX^Xi[Pool𐶐
 * NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class DatabaseAccessPool {
    /* f[^x[XANZXQueueTCY */
    private static final int LIST_SIZE = 10;

    /* MO */
    private static Logger logger;

    /* f[^x[XANZXQueue List */
    private final List<DatabaseAccess> databaseAccessQueueList =
        Collections.synchronizedList(new LinkedList<DatabaseAccess>());

    /**
     * f[^x[XANZXCX^Xi[Pool𐶐܂B
     *
     */
    private DatabaseAccessPool() {
        logger = Logger.getLogger(this.getClass().getName());
        setDatabaseAccessQueueList();
    }

    /**
     * f[^x[XANZXCX^XListPool܂B
     *
     */
    public void setDatabaseAccessQueueList() {
        databaseAccessQueueList.clear();

        for (int i = 0; i < LIST_SIZE; i++) {
            DatabaseAccess dataAccess = null;
            dataAccess = new DatabaseAccess();
            databaseAccessQueueList.add(
                databaseAccessQueueList.size(), dataAccess);
        }
    }

    /**
     * f[^x[XANZXCX^X܂B
     *
     * @param dataAccess f[^x[XANZXCX^X
     */
    public synchronized void releaseQueueDatabaseAccess(
        final DatabaseAccess dataAccess) {
        databaseAccessQueueList.add(databaseAccessQueueList.size(), dataAccess);

        // logger.info("release list.size() : " + list.size());
    }

    /**
     * f[^x[XANZXCX^X擾܂B
     *
     * @return dataAccess f[^x[XANZXCX^X
     */
    public synchronized DatabaseAccess popQueueDatabaseAccess() {
        DatabaseAccess dataAccess = null;

        if (databaseAccessQueueList.size() > 0) {
            dataAccess = (DatabaseAccess) databaseAccessQueueList.get(0);

            databaseAccessQueueList.remove(0);
        } else {
            logger.warning("Empty DatabaseAccess");
        }

        return dataAccess;
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static DatabaseAccessPool getInstance() {
        return SingletonAboutMessage.DBPOOL;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonAboutMessage {
        static final DatabaseAccessPool DBPOOL = new DatabaseAccessPool();
    }
}
