/*
 * Created on 2004/09/10
 *
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.database.access.model;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;



/**
 * PostgreSQLf[^x[X郁\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class PostgreSQLDatabaseInit {
    /** PostgreSQLp̃f[^x[XSQL */
    public static final String CREATE =
        "CREATE DATABASE " + AbstractDataAccessObject.POSTGRESQL_USE_DATABASE;

    /** PostgreSQLp̃f[^x[X폜SQL */
    public static final String DROP =
        "DROP DATABASE " + AbstractDataAccessObject.POSTGRESQL_USE_DATABASE;

    /* MO */
    private static Logger logger = null;

    /**
    * PostgreSQLNXCX^X𐶐܂B
    *
    */
    private PostgreSQLDatabaseInit() {
        /*  */
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * PostgreSQLNXCX^XԂ܂B
     *
     * @return PostgreSQLNXCX^X
     */
    public static PostgreSQLDatabaseInit getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * PostgreSQL̃m[hĎf[^x[X܂B
     *
     * @throws IllegalAccessException JDBChCoCX^X
     * sꍇ
     * @throws InstantiationException JDBChCoCX^X
     * sꍇ
     * @throws ClassNotFoundException JDBChCoȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public void createDatabase()
        throws SQLException, ClassNotFoundException, IllegalAccessException,
            InstantiationException {
        String databaseName;
        String jdbcdriver;
        String url;
        String username;
        String password;

        /* f[^x[XvpeB擾 */
        AbstractDataAccessObject databaseProp =
            DatabaseAccessControlKind.getInstance().getDataAccessObject();

        /* f[^x[X */
        databaseName =
            DatabaseAccessControlKind.getInstance().getDatabaseName();

        /* JDBChCo[ */
        jdbcdriver = databaseProp.getDriver();

        /* f[^x[XURL */
        url = databaseProp.getDatabaseurl()
            + AbstractDataAccessObject.USE_DATABASE;

        /* User */
        username = databaseProp.getUser();

        /* pX[h */
        password = databaseProp.getPassword();

        Statement stmt = null;
        Connection con = null;

        try {
            // JDBC Driver ̓o^
            Class.forName(jdbcdriver).newInstance();

            // f[^x[Xւ̐ڑ
            con = DriverManager.getConnection(url, username, password);

            // SQL Xe[ggEIuWFNg̍쐬
            stmt = con.createStatement();
            logger.info("Database Kind : " + databaseName);

            try {
                // f[^x[X폜
                stmt.executeUpdate(DROP);
            } catch (SQLException e1) {
                logger.info(DROP + " : " + e1.getMessage());
            }

            // f[^x[X쐬 nodewatch
            stmt.executeUpdate(CREATE);
        } catch (SQLException e) {
            logger.warning(
                databaseName + " : " + "URL = " + url + " : User = " + username
                + " : Password = " + password);
            logger.warning(databaseName + " : " + e.getMessage());

            // e.printStackTrace();
            throw e;
        } catch (IllegalAccessException e) {
            logger.severe(
                "IllegalAccessException " + jdbcdriver + " " + e.getMessage());
            throw e;
        } catch (InstantiationException e) {
            logger.severe(
                "InstantiationException " + jdbcdriver + " " + e.getMessage());
            throw e;
        } catch (ClassNotFoundException e) {
            logger.severe(
                "ClassNotFoundException " + jdbcdriver + " " + e.getMessage());

            throw e;
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e1) {
                    logger.severe(e1.getMessage());
                    e1.printStackTrace();
                }
            }

            if (con != null) {
                try {
                    con.close();
                } catch (SQLException e1) {
                    logger.severe(e1.getMessage());
                    e1.printStackTrace();
                }
            }
        }
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final PostgreSQLDatabaseInit RESOURCE =
            new PostgreSQLDatabaseInit();
    }
}
